/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.connector.http2;

import com.apusic.aas.util.res.StringManager;
import com.apusic.connector.http2.AbstractNonZeroStream;
import com.apusic.connector.http2.ConnectionException;
import com.apusic.connector.http2.Http2Error;
import com.apusic.connector.http2.Http2Exception;
import com.apusic.connector.http2.StreamException;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractStream.class);
    private final Integer identifier;
    private final String idAsString;
    private volatile AbstractStream parentStream = null;
    private final Set<AbstractNonZeroStream> childStreams = Collections.newSetFromMap(new ConcurrentHashMap());
    private long windowSize = 65535L;
    private volatile int connectionAllocationRequested = 0;
    private volatile int connectionAllocationMade = 0;

    AbstractStream(Integer identifier) {
        this.identifier = identifier;
        this.idAsString = identifier.toString();
    }

    final Integer getIdentifier() {
        return this.identifier;
    }

    final String getIdAsString() {
        return this.idAsString;
    }

    final int getIdAsInt() {
        return this.identifier;
    }

    final void detachFromParent() {
        if (this.parentStream != null) {
            this.parentStream.getChildStreams().remove(this);
            this.parentStream = null;
        }
    }

    final void addChild(AbstractNonZeroStream child) {
        child.setParentStream(this);
        this.childStreams.add(child);
    }

    final boolean isDescendant(AbstractStream stream) {
        AbstractStream parent;
        for (parent = stream.getParentStream(); parent != null && parent != this; parent = parent.getParentStream()) {
        }
        return parent != null;
    }

    final AbstractStream getParentStream() {
        return this.parentStream;
    }

    final void setParentStream(AbstractStream parentStream) {
        this.parentStream = parentStream;
    }

    final Set<AbstractNonZeroStream> getChildStreams() {
        return this.childStreams;
    }

    final synchronized void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    final synchronized long getWindowSize() {
        return this.windowSize;
    }

    synchronized void incrementWindowSize(int increment) throws Http2Exception {
        this.windowSize += (long)increment;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("abstractStream.windowSizeInc", this.getConnectionId(), this.getIdAsString(), Integer.toString(increment), Long.toString(this.windowSize)));
        }
        if (this.windowSize > Integer.MAX_VALUE) {
            String msg = sm.getString("abstractStream.windowSizeTooBig", this.getConnectionId(), this.identifier, Integer.toString(increment), Long.toString(this.windowSize));
            if (this.identifier == 0) {
                throw new ConnectionException(msg, Http2Error.FLOW_CONTROL_ERROR);
            }
            throw new StreamException(msg, Http2Error.FLOW_CONTROL_ERROR, this.identifier);
        }
    }

    final synchronized void decrementWindowSize(int decrement) {
        this.windowSize -= (long)decrement;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("abstractStream.windowSizeDec", this.getConnectionId(), this.getIdAsString(), Integer.toString(decrement), Long.toString(this.windowSize)));
        }
    }

    final int getConnectionAllocationRequested() {
        return this.connectionAllocationRequested;
    }

    final void setConnectionAllocationRequested(int connectionAllocationRequested) {
        log.debug(sm.getString("abstractStream.setConnectionAllocationRequested", this.getConnectionId(), this.getIdAsString(), Integer.toString(this.connectionAllocationRequested), Integer.toString(connectionAllocationRequested)));
        this.connectionAllocationRequested = connectionAllocationRequested;
    }

    final int getConnectionAllocationMade() {
        return this.connectionAllocationMade;
    }

    final void setConnectionAllocationMade(int connectionAllocationMade) {
        log.debug(sm.getString("abstractStream.setConnectionAllocationMade", this.getConnectionId(), this.getIdAsString(), Integer.toString(this.connectionAllocationMade), Integer.toString(connectionAllocationMade)));
        this.connectionAllocationMade = connectionAllocationMade;
    }

    abstract String getConnectionId();

    abstract int getWeight();
}

