/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.juli.logging;

import com.apusic.juli.OneLineFormatter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ApusicConsoleHandler
extends StreamHandler {
    private static final Boolean APUSIC_LOG_DISCARD_LOG_WHEN_QUEUE_FULL = Boolean.getBoolean("APUSIC_LOG_DISCARD_LOG_WHEN_QUEUE_FULL");
    private static final int MAX_QUEUE_SIZE = Integer.getInteger("APUSIC_LOG_MAX_QUEUE_SIZE", 8192);
    private BlockingQueue<LogRecord> pendingRecords = new LinkedBlockingQueue<LogRecord>(MAX_QUEUE_SIZE);
    private Thread pump = null;
    private boolean discardLogWhenQueueFull = false;
    private Vector<LogRecord> vector = new Vector();
    private static final Integer APUSIC_LOG_FLUSH_INTERVAL = Integer.getInteger("APUSIC_LOG_FLUSH_INTERVAL", -1);

    public ApusicConsoleHandler() {
        this.configure();
        this.setOutputStream(System.out);
    }

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        if (manager.getClass().getName().equals("")) {
            // empty if block
        }
        String cname = "java.util.logging.ConsoleHandler";
        try {
            Method getLevelPropertyMethod = LogManager.class.getDeclaredMethod("getLevelProperty", String.class, Level.class);
            Method getFilterPropertyMethod = LogManager.class.getDeclaredMethod("getFilterProperty", String.class, Filter.class);
            Method getStringPropertyMethod = LogManager.class.getDeclaredMethod("getStringProperty", String.class, String.class);
            Method getIntPropertyMethod = LogManager.class.getDeclaredMethod("getIntProperty", String.class, Integer.TYPE);
            Method getFormatterPropertyMethod = LogManager.class.getDeclaredMethod("getFormatterProperty", String.class, Formatter.class);
            getLevelPropertyMethod.setAccessible(true);
            getFilterPropertyMethod.setAccessible(true);
            getStringPropertyMethod.setAccessible(true);
            getIntPropertyMethod.setAccessible(true);
            getFormatterPropertyMethod.setAccessible(true);
            this.setLevel((Level)getLevelPropertyMethod.invoke((Object)manager, cname + ".level", Level.INFO));
            this.setFilter((Filter)getFilterPropertyMethod.invoke((Object)manager, cname + ".filter", null));
            this.setFormatter((Formatter)getFormatterPropertyMethod.invoke((Object)manager, cname + ".formatter", new OneLineFormatter()));
            try {
                this.setEncoding((String)getStringPropertyMethod.invoke((Object)manager, cname + ".encoding", null));
            }
            catch (Exception ex) {
                try {
                    this.setEncoding(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (APUSIC_LOG_DISCARD_LOG_WHEN_QUEUE_FULL.booleanValue()) {
                this.discardLogWhenQueueFull = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initializePump();
    }

    void initializePump() {
        this.pump = new Thread("ApusicConsoleHandler"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ApusicConsoleHandler.this.log();
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        };
        this.pump.setDaemon(true);
        this.pump.start();
    }

    public void log() {
        int size = 0;
        try {
            LogRecord record = this.pendingRecords.take();
            super.publish(record);
        }
        catch (InterruptedException e) {
            return;
        }
        this.vector.clear();
        if (APUSIC_LOG_FLUSH_INTERVAL > 0) {
            try {
                Thread.sleep(APUSIC_LOG_FLUSH_INTERVAL.intValue());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        size = this.pendingRecords.drainTo(this.vector);
        for (int j = 0; j < size; ++j) {
            super.publish(this.vector.get(j));
        }
        this.flush();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            if (this.discardLogWhenQueueFull) {
                this.pendingRecords.offer(record);
            } else {
                this.pendingRecords.put(record);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    @Override
    public void close() {
        this.pump.interrupt();
        int size = this.pendingRecords.size();
        if (size > 0) {
            ArrayList records = new ArrayList(size);
            this.pendingRecords.drainTo(records, size);
            for (LogRecord record : records) {
                super.publish(record);
            }
        }
        super.close();
    }
}

