/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.juli.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogOutputStream
extends OutputStream {
    private Logger logger;
    private Level level;
    private ByteArrayOutputStream bout;
    private String encoding;
    private static final Integer APUSIC_SYSOUT_LOG_FLUSH_INTERVAL = Integer.getInteger("APUSIC_SYSOUT_LOG_FLUSH_INTERVAL", -1);
    private static final Boolean APUSIC_DISABLE_SYSOUT_LOG_CACHE = Boolean.getBoolean("APUSIC_DISABLE_SYSOUT_LOG_CACHE");
    private static final int MAX_QUEUE_SIZE = Integer.getInteger("APUSIC_LOG_MAX_QUEUE_SIZE", 8192);
    private Vector<LogRecord> vector = new Vector();
    private BlockingQueue<LogRecord> pendingRecords = new LinkedBlockingQueue<LogRecord>(MAX_QUEUE_SIZE);
    private Thread thread;

    public LogOutputStream(Logger logger, Level level) {
        this(logger, level, null);
    }

    public LogOutputStream(String name, Level level) {
        this(name, level, null);
    }

    public LogOutputStream(Logger logger, Level level, String encoding) {
        this.logger = logger;
        this.level = level;
        this.bout = new ByteArrayOutputStream(8192);
        if (!APUSIC_DISABLE_SYSOUT_LOG_CACHE.booleanValue()) {
            this.initializePump();
        }
    }

    public LogOutputStream(String name, Level level, String encoding) {
        this.logger = Logger.getLogger(name);
        this.level = level;
        this.bout = new ByteArrayOutputStream();
        this.encoding = encoding;
        if (!APUSIC_DISABLE_SYSOUT_LOG_CACHE.booleanValue()) {
            this.initializePump();
        }
    }

    private void initializePump() {
        this.thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            LogOutputStream.this.log();
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        };
        this.thread.setName("LogOutputStream-" + this.level.getName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void log() {
        try {
            LogRecord record = this.pendingRecords.take();
            this.logger.log(record);
        }
        catch (InterruptedException e) {
            return;
        }
        this.vector.clear();
        if (APUSIC_SYSOUT_LOG_FLUSH_INTERVAL > 0) {
            try {
                Thread.sleep(APUSIC_SYSOUT_LOG_FLUSH_INTERVAL.intValue());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int msgs = this.pendingRecords.drainTo(this.vector);
        for (int j = 0; j < msgs; ++j) {
            this.logger.log(this.vector.get(j));
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.logger.isLoggable(this.level)) {
            this.bout.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.logger.isLoggable(this.level)) {
            this.bout.write(b, 0, b.length);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.logger.isLoggable(this.level)) {
            this.bout.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        byte[] bytes = this.bout.toByteArray();
        this.bout.reset();
        String content = null;
        content = null != this.encoding ? new String(bytes, this.encoding) : new String(bytes);
        if (bytes.length > 0) {
            if (APUSIC_DISABLE_SYSOUT_LOG_CACHE.booleanValue()) {
                this.logger.log(new LogRecord(this.level, content));
            } else {
                try {
                    this.pendingRecords.put(new LogRecord(this.level, content));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

