/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.util.bcel.classfile;

import com.apusic.aas.util.bcel.Const;
import com.apusic.aas.util.bcel.classfile.ClassFormatException;
import com.apusic.aas.util.bcel.classfile.Constant;
import java.io.DataInput;
import java.io.IOException;

public class ConstantPool {
    private final Constant[] constantPool;

    ConstantPool(DataInput input) throws IOException, ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constantPool = new Constant[constant_pool_count];
        for (int i = 1; i < constant_pool_count; ++i) {
            byte tag;
            this.constantPool[i] = Constant.readConstant(input);
            if (this.constantPool[i] == null || (tag = this.constantPool[i].getTag()) != 6 && tag != 5) continue;
            ++i;
        }
    }

    public Constant getConstant(int index) {
        if (index >= this.constantPool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constantPool.length);
        }
        return this.constantPool[index];
    }

    public Constant getConstant(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index + " and got " + c);
        }
        return c;
    }
}

