/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.util.bcel.classfile;

import com.apusic.aas.util.bcel.classfile.Constant;
import com.apusic.aas.util.bcel.classfile.ConstantClass;
import com.apusic.aas.util.bcel.classfile.ConstantPool;
import com.apusic.aas.util.bcel.classfile.ConstantUtf8;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;

final class Utility {
    private Utility() {
    }

    static String compactClassName(String str) {
        return str.replace('/', '.');
    }

    static String getClassName(ConstantPool constantPool, int index) {
        Constant c = constantPool.getConstant(index, (byte)7);
        int i = ((ConstantClass)c).getNameIndex();
        c = constantPool.getConstant(i, (byte)1);
        String name = ((ConstantUtf8)c).getBytes();
        return Utility.compactClassName(name);
    }

    static void skipFully(DataInput file, int length) throws IOException {
        int total = file.skipBytes(length);
        if (total != length) {
            throw new EOFException();
        }
    }

    static void swallowAttribute(DataInput file) throws IOException {
        Utility.skipFully(file, 2);
        int length = file.readInt();
        Utility.skipFully(file, length);
    }
}

