/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.util.net;

import com.apusic.aas.jni.Error;
import com.apusic.aas.util.ExceptionUtils;
import com.apusic.aas.util.net.AbstractEndpoint;
import com.apusic.aas.util.res.StringManager;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import com.apusic.util.CryptUtil;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Acceptor<U>
implements Runnable {
    private static final Log log = LogFactory.getLog(Acceptor.class);
    private static final StringManager sm = StringManager.getManager(Acceptor.class);
    private static final int INITIAL_ERROR_DELAY = 50;
    private static final int MAX_ERROR_DELAY = 1600;
    private final AbstractEndpoint<?, U> endpoint;
    private String threadName;
    private volatile boolean stopCalled = false;
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    protected volatile AcceptorState state = AcceptorState.NEW;
    private static int _licensedAddress = 1024;
    private static int _maxSockets = 28;
    private static int[] _addressLimits = new int[23];
    private static long[] _timeLimits = new long[16];
    private static int CONNECTIONS = 3;

    public Acceptor(AbstractEndpoint<?, U> endpoint) {
        this.endpoint = endpoint;
    }

    public final AcceptorState getState() {
        return this.state;
    }

    final void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    final String getThreadName() {
        return this.threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int errorDelay = 0;
        long pauseStart = 0L;
        try {
            while (!this.stopCalled) {
                while (this.endpoint.isPaused() && !this.stopCalled) {
                    if (this.state != AcceptorState.PAUSED) {
                        pauseStart = System.nanoTime();
                        this.state = AcceptorState.PAUSED;
                    }
                    if (System.nanoTime() - pauseStart <= 1000000L) continue;
                    try {
                        if (System.nanoTime() - pauseStart > 10000000L) {
                            Thread.sleep(10L);
                            continue;
                        }
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.stopCalled) break;
                this.state = AcceptorState.RUNNING;
                try {
                    this.endpoint.countUpOrAwaitConnection();
                    if (this.endpoint.isPaused()) continue;
                    Object socket = null;
                    try {
                        socket = this.endpoint.serverSocketAccept();
                        if (socket instanceof SocketChannel && Acceptor.checkConnectionLimit(((SocketChannel)socket).socket()) != 0L) {
                            this.endpoint.destroySocket(socket);
                            throw new Exception("ioe");
                        }
                    }
                    catch (Exception ioe) {
                        this.endpoint.countDownConnection();
                        if (this.endpoint.isRunning()) {
                            errorDelay = this.handleExceptionWithDelay(errorDelay);
                            throw ioe;
                        }
                        break;
                    }
                    errorDelay = 0;
                    if (!this.stopCalled && !this.endpoint.isPaused()) {
                        if (this.endpoint.setSocketOptions(socket)) continue;
                        this.endpoint.closeSocket(socket);
                        continue;
                    }
                    this.endpoint.destroySocket(socket);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    String msg = sm.getString("endpoint.accept.fail");
                    if (t instanceof Error) {
                        Error e = (Error)t;
                        if (e.getError() == 233) {
                            log.warn(msg, t);
                            continue;
                        }
                        log.error(msg, t);
                        continue;
                    }
                    if ("ioe".equals(t.getMessage())) continue;
                    log.error(msg, t);
                }
            }
        }
        finally {
            this.stopLatch.countDown();
        }
        this.state = AcceptorState.ENDED;
    }

    @Deprecated
    public void stop() {
        this.stop(10);
    }

    public void stop(int waitSeconds) {
        this.stopCalled = true;
        if (waitSeconds > 0) {
            try {
                if (!this.stopLatch.await(waitSeconds, TimeUnit.SECONDS)) {
                    log.warn(sm.getString("acceptor.stop.fail", this.getThreadName()));
                }
            }
            catch (InterruptedException e) {
                log.warn(sm.getString("acceptor.stop.interrupted", this.getThreadName()), e);
            }
        }
    }

    protected int handleExceptionWithDelay(int currentErrorDelay) {
        if (currentErrorDelay > 0) {
            try {
                Thread.sleep(currentErrorDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (currentErrorDelay == 0) {
            return 50;
        }
        if (currentErrorDelay < 1600) {
            return currentErrorDelay * 2;
        }
        return 1600;
    }

    public static int getConnections() {
        String co = System.getProperty("Connections");
        String comm = CryptUtil.getDecryptString((String)co);
        try {
            return Integer.parseInt(comm);
        }
        catch (Exception e) {
            return CONNECTIONS;
        }
    }

    public static final long checkConnectionLimit(Socket socket) {
        return _maxSockets > 0 ? Acceptor.checkConnectionLimit(socket.getInetAddress().hashCode()) : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long checkConnectionLimit(int address) {
        int maxSockets = _maxSockets;
        int licensedAddress = _licensedAddress;
        int[] addressLimits = _addressLimits;
        long[] timeLimits = _timeLimits;
        int[] nArray = addressLimits;
        synchronized (addressLimits) {
            int pos;
            if (maxSockets > addressLimits.length) {
                maxSockets = Acceptor.getConnections();
                if (maxSockets > addressLimits.length) {
                    addressLimits = _addressLimits = new int[maxSockets];
                    timeLimits = _timeLimits = new long[maxSockets];
                }
                _maxSockets = maxSockets;
                _licensedAddress = licensedAddress;
            }
            if (address == licensedAddress) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return 0L;
            }
            long time = System.currentTimeMillis();
            for (pos = 0; pos < maxSockets && address != addressLimits[pos] && 0 != addressLimits[pos]; ++pos) {
            }
            if (pos == maxSockets) {
                long timeout = 300000L - (time - timeLimits[0]);
                if (timeout > 0L) {
                    byte[] _msg = new byte[16];
                    long _xx = 2334102057544149356L;
                    long _yy = 2334398899846080844L;
                    for (int _i = 8; _i > 0; --_i) {
                        _msg[16 - _i] = (byte)_xx;
                        _msg[8 - _i] = (byte)_yy;
                        _xx >>= 8;
                        _yy >>= 8;
                    }
                    System.err.println(new String(_msg));
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return timeout;
                }
                --pos;
            }
            for (int i = pos; i > 0; --i) {
                addressLimits[i] = addressLimits[i - 1];
                timeLimits[i] = timeLimits[i - 1];
            }
            addressLimits[0] = address;
            timeLimits[0] = time;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return 0L;
        }
    }

    public static enum AcceptorState {
        NEW,
        RUNNING,
        PAUSED,
        ENDED;

    }
}

