/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.util.net;

import com.apusic.aas.util.net.SSLHostConfigCertificate;
import com.apusic.aas.util.net.SSLSupport;
import com.apusic.aas.util.net.SSLUtil;
import com.apusic.aas.util.net.jsse.JSSEImplementation;
import com.apusic.aas.util.res.StringManager;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSession;

public abstract class SSLImplementation {
    private static final Log logger = LogFactory.getLog(SSLImplementation.class);
    private static final StringManager sm = StringManager.getManager(SSLImplementation.class);

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return new JSSEImplementation();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String msg = sm.getString("sslImplementation.cnfe", className);
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e);
            }
            throw new ClassNotFoundException(msg, e);
        }
    }

    public SSLSupport getSSLSupport(SSLSession session, Map<String, List<String>> additionalAttributes) {
        return this.getSSLSupport(session);
    }

    @Deprecated
    public abstract SSLSupport getSSLSupport(SSLSession var1);

    public abstract SSLUtil getSSLUtil(SSLHostConfigCertificate var1);

    public abstract boolean isAlpnSupported();
}

