/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.util.net.openssl;

import com.apusic.aas.util.net.SSLContext;
import com.apusic.aas.util.net.SSLHostConfigCertificate;
import com.apusic.aas.util.net.SSLUtilBase;
import com.apusic.aas.util.net.jsse.JSSEKeyManager;
import com.apusic.aas.util.net.openssl.OpenSSLContext;
import com.apusic.aas.util.net.openssl.OpenSSLEngine;
import com.apusic.aas.util.res.StringManager;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;

public class OpenSSLUtil
extends SSLUtilBase {
    private static final Log log = LogFactory.getLog(OpenSSLUtil.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLUtil.class);

    public OpenSSLUtil(SSLHostConfigCertificate certificate) {
        super(certificate);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return OpenSSLEngine.IMPLEMENTED_PROTOCOLS_SET;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return OpenSSLEngine.AVAILABLE_CIPHER_SUITES;
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return true;
    }

    @Override
    public SSLContext createSSLContextInternal(List<String> negotiableProtocols) throws Exception {
        return new OpenSSLContext(this.certificate, negotiableProtocols);
    }

    public static X509KeyManager chooseKeyManager(KeyManager[] managers) throws Exception {
        if (managers == null) {
            return null;
        }
        for (KeyManager manager : managers) {
            if (!(manager instanceof JSSEKeyManager)) continue;
            return (JSSEKeyManager)manager;
        }
        for (KeyManager manager : managers) {
            if (!(manager instanceof X509KeyManager)) continue;
            return (X509KeyManager)manager;
        }
        throw new IllegalStateException(sm.getString("openssl.keyManagerMissing"));
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        try {
            return super.getKeyManagers();
        }
        catch (IllegalArgumentException e) {
            String msg = sm.getString("openssl.nonJsseChain", this.certificate.getCertificateChainFile());
            if (log.isDebugEnabled()) {
                log.info(msg, e);
            } else {
                log.info(msg);
            }
            return null;
        }
        catch (IOException | KeyStoreException e) {
            if (this.certificate.getCertificateFile() != null) {
                String msg = sm.getString("openssl.nonJsseCertificate", this.certificate.getCertificateFile(), this.certificate.getCertificateKeyFile());
                if (log.isDebugEnabled()) {
                    log.info(msg, e);
                } else {
                    log.info(msg);
                }
                return null;
            }
            throw e;
        }
    }
}

