/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.aas.util.xreflection;

import com.apusic.aas.util.IntrospectionUtils;
import com.apusic.aas.util.xreflection.ReflectionLessCodeGenerator;
import com.apusic.aas.util.xreflection.ReflectionProperty;
import com.apusic.aas.util.xreflection.SetPropertyClass;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class ObjectReflectionPropertyInspector {
    private static final Set<Class<?>> ALLOWED_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.TYPE, Integer.TYPE, Long.TYPE, String.class, InetAddress.class)));
    private static Map<Class<?>, SetPropertyClass> classes = new HashMap();

    public static void main(String ... args) throws Exception {
        File outputDir;
        if (args.length == 0) {
            System.err.println("Usage:\n\tcom.apusic.aas.util.xreflection.ObjectReflectionPropertyInspector <destination directory>");
            System.exit(1);
        }
        if (!(outputDir = new File(args[0])).exists() || !outputDir.isDirectory()) {
            System.err.println("Invalid output directory: " + outputDir.getAbsolutePath());
            System.exit(1);
        }
        Set<SetPropertyClass> baseClasses = ObjectReflectionPropertyInspector.getKnownClasses().stream().map(ObjectReflectionPropertyInspector::processClass).collect(Collectors.toSet());
        ObjectReflectionPropertyInspector.generateCode(baseClasses, "com.apusic.aas.util", outputDir, "XReflectionIntrospectionUtils");
    }

    private static final Set<Class<?>> getKnownClasses() throws ClassNotFoundException {
        return Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Class.forName("com.apusic.ams.authenticator.jaspic.SimpleAuthConfigProvider"), Class.forName("com.apusic.ams.authenticator.jaspic.PersistentProviderRegistrations$Property"), Class.forName("com.apusic.ams.authenticator.jaspic.PersistentProviderRegistrations$Provider"), Class.forName("com.apusic.ams.connector.Connector"), Class.forName("com.apusic.ams.core.AprLifecycleListener"), Class.forName("com.apusic.ams.core.ContainerBase"), Class.forName("com.apusic.ams.core.StandardContext"), Class.forName("com.apusic.ams.core.StandardEngine"), Class.forName("com.apusic.ams.core.StandardHost"), Class.forName("com.apusic.ams.core.StandardServer"), Class.forName("com.apusic.ams.core.StandardService"), Class.forName("com.apusic.ams.filters.AddDefaultCharsetFilter"), Class.forName("com.apusic.ams.filters.RestCsrfPreventionFilter"), Class.forName("com.apusic.ams.loader.ParallelWebappClassLoader"), Class.forName("com.apusic.ams.loader.WebappClassLoaderBase"), Class.forName("com.apusic.ams.realm.UserDatabaseRealm"), Class.forName("com.apusic.ams.valves.AccessLogValve"), Class.forName("com.apusic.connector.AbstractProtocol"), Class.forName("com.apusic.connector.ajp.AbstractAjpProtocol"), Class.forName("com.apusic.connector.ajp.AjpAprProtocol"), Class.forName("com.apusic.connector.ajp.AjpNio2Protocol"), Class.forName("com.apusic.connector.ajp.AjpNioProtocol"), Class.forName("com.apusic.connector.http11.AbstractHttp11JsseProtocol"), Class.forName("com.apusic.connector.http11.AbstractHttp11Protocol"), Class.forName("com.apusic.connector.http11.Http11AprProtocol"), Class.forName("com.apusic.connector.http11.Http11Nio2Protocol"), Class.forName("com.apusic.connector.http11.Http11NioProtocol"), Class.forName("com.apusic.aas.util.descriptor.web.ContextResource"), Class.forName("com.apusic.aas.util.descriptor.web.ResourceBase"), Class.forName("com.apusic.aas.util.modeler.AttributeInfo"), Class.forName("com.apusic.aas.util.modeler.FeatureInfo"), Class.forName("com.apusic.aas.util.modeler.ManagedBean"), Class.forName("com.apusic.aas.util.modeler.OperationInfo"), Class.forName("com.apusic.aas.util.modeler.ParameterInfo"), Class.forName("com.apusic.aas.util.net.AbstractEndpoint"), Class.forName("com.apusic.aas.util.net.AprEndpoint"), Class.forName("com.apusic.aas.util.net.Nio2Endpoint"), Class.forName("com.apusic.aas.util.net.NioEndpoint"), Class.forName("com.apusic.aas.util.net.SocketProperties"))));
    }

    public static void generateCode(Set<SetPropertyClass> baseClasses, String packageName, File location, String className) throws Exception {
        String packageDirectory = packageName.replace('.', '/');
        File sourceFileLocation = new File(location, packageDirectory);
        ReflectionLessCodeGenerator.generateCode(sourceFileLocation, className, packageName, baseClasses);
    }

    private static boolean isAllowedField(Field field) {
        return ALLOWED_TYPES.contains(field.getType()) && !Modifier.isFinal(field.getModifiers());
    }

    private static boolean isAllowedSetMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes() != null && method.getParameterTypes().length == 1 && ALLOWED_TYPES.contains(method.getParameterTypes()[0]) && !Modifier.isPrivate(method.getModifiers());
    }

    private static boolean isAllowedGetMethod(Method method) {
        return !(!method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes() != null && method.getParameterTypes().length != 0 || !ALLOWED_TYPES.contains(method.getReturnType()) || Modifier.isPrivate(method.getModifiers()));
    }

    private static SetPropertyClass getOrCreateSetPropertyClass(Class<?> clazz) {
        boolean base = clazz.getSuperclass() == null || clazz.getSuperclass() == Object.class;
        SetPropertyClass spc = classes.get(clazz);
        if (spc == null) {
            spc = new SetPropertyClass(clazz, base ? null : ObjectReflectionPropertyInspector.getOrCreateSetPropertyClass(clazz.getSuperclass()));
            classes.put(clazz, spc);
        }
        return spc;
    }

    static Method findGetter(Class<?> declaringClass, String propertyName) {
        for (String getterName : Arrays.asList("get" + IntrospectionUtils.capitalize(propertyName), "is" + propertyName)) {
            try {
                Method method = declaringClass.getMethod(getterName, new Class[0]);
                if (Modifier.isPrivate(method.getModifiers())) continue;
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        try {
            Method method = declaringClass.getMethod("getProperty", String.class, String.class);
            if (!Modifier.isPrivate(method.getModifiers())) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static Method findSetter(Class<?> declaringClass, String propertyName, Class<?> propertyType) {
        Method method;
        try {
            method = declaringClass.getMethod("set" + IntrospectionUtils.capitalize(propertyName), propertyType);
            if (!Modifier.isPrivate(method.getModifiers())) {
                return method;
            }
        }
        catch (NoSuchMethodException method2) {
            // empty catch block
        }
        try {
            method = declaringClass.getMethod("setProperty", String.class, String.class);
            if (!Modifier.isPrivate(method.getModifiers())) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static SetPropertyClass processClass(Class<?> clazz) {
        Field[] fields;
        Method[] methods;
        SetPropertyClass spc = ObjectReflectionPropertyInspector.getOrCreateSetPropertyClass(clazz);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (ObjectReflectionPropertyInspector.isAllowedSetMethod(method)) {
                String propertyName = ObjectReflectionPropertyInspector.decapitalize(method.getName().substring(3));
                Class<?> propertyType = method.getParameterTypes()[0];
                Method getter = ObjectReflectionPropertyInspector.findGetter(clazz, propertyName);
                Method setter = ObjectReflectionPropertyInspector.findSetter(clazz, propertyName, propertyType);
                ReflectionProperty property = new ReflectionProperty(spc.getClazz().getName(), propertyName, propertyType, setter, getter);
                spc.addProperty(property);
                continue;
            }
            if (!ObjectReflectionPropertyInspector.isAllowedGetMethod(method)) continue;
            boolean startsWithIs = method.getName().startsWith("is");
            String propertyName = ObjectReflectionPropertyInspector.decapitalize(method.getName().substring(startsWithIs ? 2 : 3));
            Class<?> propertyType = method.getReturnType();
            Method getter = ObjectReflectionPropertyInspector.findGetter(clazz, propertyName);
            Method setter = ObjectReflectionPropertyInspector.findSetter(clazz, propertyName, propertyType);
            ReflectionProperty property = new ReflectionProperty(spc.getClazz().getName(), propertyName, propertyType, setter, getter);
            spc.addProperty(property);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!ObjectReflectionPropertyInspector.isAllowedField(field)) continue;
            Method getter = ObjectReflectionPropertyInspector.findGetter(field.getDeclaringClass(), IntrospectionUtils.capitalize(field.getName()));
            Method setter = ObjectReflectionPropertyInspector.findSetter(field.getDeclaringClass(), IntrospectionUtils.capitalize(field.getName()), field.getType());
            ReflectionProperty property = new ReflectionProperty(spc.getClazz().getName(), field.getName(), field.getType(), setter, getter);
            spc.addProperty(property);
        }
        if (!spc.isBaseClass()) {
            SetPropertyClass parent = ObjectReflectionPropertyInspector.getOrCreateSetPropertyClass(spc.getClazz().getSuperclass());
            parent.addSubClass(spc);
            return ObjectReflectionPropertyInspector.processClass(parent.getClazz());
        }
        return spc;
    }
}

