/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.authenticator;

import com.apusic.ams.Authenticator;
import com.apusic.ams.Context;
import com.apusic.ams.Manager;
import com.apusic.ams.Session;
import com.apusic.ams.SessionEvent;
import com.apusic.ams.SessionListener;
import com.apusic.ams.authenticator.AuthenticatorBase;
import com.apusic.ams.authenticator.SingleSignOn;
import java.io.Serializable;

public class SingleSignOnListener
implements SessionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String ssoId;

    public SingleSignOnListener(String ssoId) {
        this.ssoId = ssoId;
    }

    @Override
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        Manager manager = session.getManager();
        if (manager == null) {
            return;
        }
        Context context = manager.getContext();
        Authenticator authenticator = context.getAuthenticator();
        if (!(authenticator instanceof AuthenticatorBase)) {
            return;
        }
        SingleSignOn sso = ((AuthenticatorBase)authenticator).sso;
        if (sso == null) {
            return;
        }
        sso.sessionDestroyed(this.ssoId, session);
    }
}

