/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.api;

import com.apusic.ams.config.api.CloudConfig;
import com.apusic.ams.config.json.JsonType;
import com.apusic.ams.config.json.SimpleJsonObject;
import com.apusic.ams.config.json.SimpleJsonParser;
import com.apusic.ams.config.json.SimpleJsonValue;
import com.apusic.ams.config.json.SimpleParseException;
import com.apusic.ams.config.json.SimpleTokenException;
import com.apusic.ams.config.util.CloudUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ApusicConfig
extends CloudConfig {
    public ApusicConfig() {
        this.key = "apusic_config";
    }

    @Override
    public void updateLocal(String map) {
        try {
            this.doUpdateConfig(map);
        }
        catch (Exception e) {
            this.logger.error(e);
        }
    }

    private synchronized boolean doUpdateConfig(String json) throws SimpleParseException, SimpleTokenException, ParserConfigurationException, IOException, SAXException {
        SimpleJsonParser parser = new SimpleJsonParser(json);
        SimpleJsonObject jsonObject = parser.parse().getJsonObject();
        if (jsonObject == null) {
            return false;
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        File file = CloudUtil.getFile("conf", "apusic.conf");
        Document document = builder.parse(file);
        Set<String> keys = jsonObject.getKeys();
        for (String key : keys) {
            SimpleJsonValue jsonObjectValue = jsonObject.getValue(key);
            if (jsonObjectValue == null || !jsonObjectValue.getType().equals((Object)JsonType.OBJECT)) {
                throw new IllegalArgumentException("Error config format.It should be a JsonObject, but " + jsonObjectValue);
            }
            this.updateDocument(document, key, jsonObjectValue.getJsonObject());
        }
        return this.doc2XmlFile(document);
    }

    private void updateDocument(Document document, String key, SimpleJsonObject jsonObject) {
        String[] keys = key.split("\\.");
        if (keys.length < 2) {
            throw new IllegalArgumentException("key value should contain tag and name attribute");
        }
        String tag = keys[keys.length - 2];
        String name = keys[keys.length - 1];
        NodeList nodeList = document.getElementsByTagName(tag);
        int length = nodeList.getLength();
        if (length < 1) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i).getAttributes().getNamedItem("name");
            if (!node.getNodeValue().equals(name)) continue;
            this.updateNode(nodeList.item(i), jsonObject);
        }
    }

    private void updateNode(Node node, SimpleJsonObject jsonObject) {
        Set<String> keys = jsonObject.getKeys();
        if (keys.size() <= 0) {
            return;
        }
        for (String key : keys) {
            SimpleJsonValue value = jsonObject.getValue(key);
            if (key.equalsIgnoreCase("name") || !value.getType().equals((Object)JsonType.STRING)) continue;
            node.getAttributes().getNamedItem(key).setNodeValue(value.getJsonString());
        }
    }

    private boolean doc2XmlFile(Document document) {
        boolean flag = true;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            File file = CloudUtil.getFile("conf", "apusic.conf");
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            flag = false;
            this.logger.error(ex);
        }
        return flag;
    }

    public static void main(String[] args) throws Exception {
        String pwd = System.getProperty("user.dir");
        System.setProperty("apusic.home", pwd);
        new ApusicConfig().doUpdateConfig("{\"config.endpoints.endpoint.ams-http\":{\"port\":\"8080\",\"protocol\":\"https\"}}");
    }
}

