/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.api;

import com.apusic.ams.config.api.CloudConfig;
import com.apusic.ams.config.json.SimpleJsonObject;
import com.apusic.ams.config.json.SimpleJsonParser;
import com.apusic.ams.config.util.CloudUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CachedConfig
extends CloudConfig {
    public CachedConfig() {
        this.key = "memcached_config";
    }

    @Override
    public void updateLocal(String map) {
        try {
            this.doUpdateConfig(map);
        }
        catch (Exception e) {
            this.logger.error(e);
        }
    }

    public synchronized boolean doUpdateConfig(String json) throws Exception {
        if (json == null || json.trim().isEmpty()) {
            return true;
        }
        SimpleJsonParser parser = new SimpleJsonParser(json);
        SimpleJsonObject jsonObject = parser.parse().getJsonObject();
        if (jsonObject == null) {
            return true;
        }
        Iterator<String> it = jsonObject.getKeys().iterator();
        HashMap<String, String> etcdMemcached = new HashMap<String, String>();
        while (it.hasNext()) {
            String proKey = it.next();
            String proValue = jsonObject.getValue(proKey).getJsonString();
            etcdMemcached.put(proKey, proValue);
        }
        if (etcdMemcached.size() <= 0) {
            return true;
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        File file = CloudUtil.getFile("conf", "context.xml");
        Document document = builder.parse(file);
        Element rootElement = document.getDocumentElement();
        NodeList childNodes = rootElement.getChildNodes();
        boolean hasResourceFlag = false;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("Manager")) continue;
            hasResourceFlag = true;
            NamedNodeMap childNodes_ShowAttr = childNode.getAttributes();
            for (Map.Entry entry : etcdMemcached.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (childNodes_ShowAttr != null && childNodes_ShowAttr.getNamedItem(key) != null) {
                    childNodes_ShowAttr.getNamedItem(key).setNodeValue(value);
                    continue;
                }
                ((Element)childNode).setAttribute(key, value);
            }
            if (childNodes_ShowAttr.getNamedItem("requestUriIgnorePattern") != null) continue;
            childNodes_ShowAttr.getNamedItem("requestUriIgnorePattern").setNodeValue(".*\\.(ico|png|gif|jpg|css|js)$");
        }
        if (!hasResourceFlag) {
            Element ResourceNode = document.createElement("Manager");
            for (Map.Entry entry : etcdMemcached.entrySet()) {
                ResourceNode.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            ResourceNode.setAttribute("requestUriIgnorePattern", ".*\\.(ico|png|gif|jpg|css|js)$");
            rootElement.appendChild(ResourceNode);
        }
        return this.doc2XmlFile(document);
    }

    public boolean doc2XmlFile(Document document) {
        boolean flag = true;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            File file = CloudUtil.getFile("conf", "context.xml");
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            flag = false;
            this.logger.error(ex);
        }
        return flag;
    }

    public static void main(String[] args) throws Exception {
        String pwd = System.getProperty("user.dir");
        System.setProperty("apusic.home", pwd);
        new CachedConfig().doUpdateConfig("{\"className\":\"com.apusic.net.Main\",\"sticky\":\"false\",\"sessionBackupTimeout\":\"1800\"}");
    }
}

