/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.api;

import com.apusic.ams.config.api.CloudConfig;
import com.apusic.ams.config.json.SimpleJsonObject;
import com.apusic.ams.config.json.SimpleJsonParser;
import com.apusic.ams.config.json.SimpleJsonValue;
import com.apusic.ams.config.util.CloudUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSourceConfig
extends CloudConfig {
    public DataSourceConfig() {
        this.key = "datasource_config";
    }

    @Override
    public void updateLocal(String map) {
        try {
            this.doUpdateConfig(map);
        }
        catch (Exception e) {
            this.logger.error(e);
        }
    }

    public synchronized boolean doUpdateConfig(String json) throws Exception {
        if (json == null || json.trim().isEmpty()) {
            return true;
        }
        SimpleJsonParser parser = new SimpleJsonParser(json);
        SimpleJsonObject jsonObject = parser.parse().getJsonObject();
        if (jsonObject == null) {
            return true;
        }
        Iterator<String> it = jsonObject.getKeys().iterator();
        HashMap<String, SimpleJsonValue> etcdDatasources = new HashMap<String, SimpleJsonValue>();
        while (it.hasNext()) {
            String proKey = it.next();
            SimpleJsonValue proValue = jsonObject.getValue(proKey);
            etcdDatasources.put(proKey, proValue);
        }
        if (etcdDatasources.size() <= 0) {
            return true;
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        File file = CloudUtil.getFile("conf", "context.xml");
        Document document = builder.parse(file);
        Element rootElement = document.getDocumentElement();
        NodeList childNodes = rootElement.getChildNodes();
        for (Map.Entry entry : etcdDatasources.entrySet()) {
            String key = (String)entry.getKey();
            SimpleJsonValue value = (SimpleJsonValue)entry.getValue();
            boolean hasResourceFlag = false;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                NamedNodeMap childNodes_ShowAttr;
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("Resource") || (childNodes_ShowAttr = childNode.getAttributes()) == null || childNodes_ShowAttr.getNamedItem("name") == null || !childNodes_ShowAttr.getNamedItem("name").getNodeValue().equals(key)) continue;
                hasResourceFlag = true;
                SimpleJsonObject subValues = value.getJsonObject();
                for (String subKey : subValues.getKeys()) {
                    String subValue = subValues.getValue(subKey).getJsonString();
                    ((Element)childNode).setAttribute(subKey, subValue);
                }
            }
            if (hasResourceFlag) continue;
            Element dataSourceNode = document.createElement("Resource");
            SimpleJsonObject subValues = value.getJsonObject();
            for (String subKey : subValues.getKeys()) {
                String subValue = subValues.getValue(subKey).getJsonString();
                dataSourceNode.setAttribute(subKey, subValue);
            }
            dataSourceNode.setAttribute("name", key);
            rootElement.appendChild(dataSourceNode);
        }
        return this.doc2XmlFile(document);
    }

    public boolean doc2XmlFile(Document document) {
        boolean flag = true;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            File file = CloudUtil.getFile("conf", "context.xml");
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            flag = false;
            this.logger.error(ex);
        }
        return flag;
    }

    public static void main(String[] args) throws Exception {
        String pwd = System.getProperty("user.dir");
        System.setProperty("apusic.home", pwd);
        new DataSourceConfig().doUpdateConfig("{\"jdbc/DataSource\":{\"auth\":\"Container\", \"type\":\"javax.sql.DataSource\", \"driverClassName\":\"oracle.jdbc.OracleDriver\", \"url\":\"jdbc:oracle:thin:@127.0.0.1:1521:orcl\", \"username\":\"user\", \"password\":\"password\", \"maxActive\":\"20\", \"maxIdle\":\"10000\", \"maxWait\":\"-1\"}}");
    }
}

