/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.api;

import com.apusic.ams.config.api.CloudConfig;
import com.apusic.ams.config.util.CloudUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JvmConfig
extends CloudConfig {
    private static Pattern other_p = Pattern.compile("OTHERS_JVMOPTS+\\s*=(.*)");
    private static Pattern memory_p = Pattern.compile("MEMORY_JVMOPTS+\\s*=(.*)");

    public JvmConfig() {
        this.key = "jvm_opt";
    }

    private synchronized boolean doUpdateConfig(String value) {
        if (value == null || value.trim().isEmpty()) {
            return true;
        }
        value = value.trim();
        while (value.length() > 0 && value.startsWith("\"")) {
            value = value.substring(1);
        }
        while (value.length() > 0 && value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        String[] options = value.split("\\s+");
        StringBuilder memOptions = new StringBuilder();
        StringBuilder otherOptions = new StringBuilder();
        for (String option : options) {
            if (option.startsWith("-Xms") || option.startsWith("-Xmx") || option.startsWith("-XX:MaxPermSize")) {
                memOptions.append(" ").append(option);
                continue;
            }
            otherOptions.append(" ").append(option);
        }
        if (value == null || value.trim().isEmpty()) {
            return true;
        }
        String OS2 = System.getProperty("os.name");
        boolean isWindows = OS2.toUpperCase().startsWith("WINDOWS");
        File file = isWindows ? CloudUtil.getFile("bin", "apusic.bat") : CloudUtil.getFile("bin", "apusic.sh");
        List<String> content = this.readFile(file);
        if (content == null) {
            return false;
        }
        this.changeOption(content, memory_p, memOptions.toString().trim(), isWindows);
        this.changeOption(content, other_p, otherOptions.toString().trim(), isWindows);
        return this.writeFile(file, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(File file) {
        BufferedReader in = null;
        ArrayList<String> contents = new ArrayList<String>();
        try {
            String line;
            FileInputStream fin = new FileInputStream(file);
            in = new BufferedReader(new InputStreamReader(fin));
            while ((line = in.readLine()) != null) {
                contents.add(line);
            }
            ArrayList<String> arrayList = contents;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error(e);
            List<String> list = null;
            return list;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.error(e);
                }
            }
        }
    }

    private void changeOption(List<String> content, Pattern pattern, String value, boolean isWindows) {
        for (int i = 0; i < content.size(); ++i) {
            String line = content.get(i);
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            if (!isWindows) {
                value = "\"" + value + "\"";
            }
            line = line.replace(m.group(1), value);
            content.set(i, line);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(File file, List<String> content) {
        OutputStreamWriter out = null;
        try {
            FileOutputStream fout = new FileOutputStream(file);
            out = new OutputStreamWriter(fout);
            String lineSep = System.getProperty("line.separator");
            for (String line : content) {
                out.write(line + lineSep);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.error(e);
                }
            }
        }
    }

    @Override
    public void updateLocal(String map) {
        this.doUpdateConfig(map);
    }
}

