/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.api;

import com.apusic.ams.config.api.CloudConfig;
import com.apusic.ams.config.json.SimpleJsonObject;
import com.apusic.ams.config.json.SimpleJsonParser;
import com.apusic.ams.config.util.CloudUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class LoggingConfig
extends CloudConfig {
    public LoggingConfig() {
        this.key = "logging_conf";
    }

    @Override
    public void updateLocal(String map) {
        this.doUpdateConfig(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean doUpdateConfig(String json) {
        if (json == null || json.trim().isEmpty()) {
            return true;
        }
        Properties prop = new Properties();
        File file = CloudUtil.getFile("conf", "logging.properties");
        FileOutputStream oFile = null;
        FileInputStream iFile = null;
        try {
            iFile = new FileInputStream(file);
            prop.load(iFile);
            iFile.close();
            oFile = new FileOutputStream(file);
            SimpleJsonParser parser = new SimpleJsonParser(json);
            SimpleJsonObject jsonObject = parser.parse().getJsonObject();
            if (jsonObject == null) {
                boolean bl = false;
                return bl;
            }
            for (String proKey : jsonObject.getKeys()) {
                String proValue = jsonObject.getValue(proKey).getJsonString();
                prop.setProperty(proKey, proValue);
            }
            prop.store(oFile, "The New properties file");
        }
        catch (Exception e) {
            this.logger.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (iFile != null) {
                    iFile.close();
                }
                if (oFile != null) {
                    oFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String pwd = System.getProperty("user.dir");
        System.setProperty("apusic.home", pwd);
        new LoggingConfig().doUpdateConfig("{\"com.apusic.connector.http2.level\":\"FINER\"}");
    }
}

