/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.json;

import com.apusic.ams.config.json.JsonType;
import com.apusic.ams.config.json.SimpleJsonArray;
import com.apusic.ams.config.json.SimpleJsonNamePair;
import com.apusic.ams.config.json.SimpleJsonObject;
import com.apusic.ams.config.json.SimpleJsonTokenizer;
import com.apusic.ams.config.json.SimpleJsonValue;
import com.apusic.ams.config.json.SimpleParseException;
import com.apusic.ams.config.json.SimpleTokenException;

public class SimpleJsonParser {
    private SimpleJsonTokenizer tokenizer;
    private String input;
    private static final int MAXINPUTSIZE = 25000;
    private static final int MAXDEPTH = 20;

    public SimpleJsonParser(String input) {
        this.input = input;
        this.tokenizer = new SimpleJsonTokenizer();
    }

    public SimpleJsonValue parse() throws SimpleParseException, SimpleTokenException {
        if (this.input == null) {
            throw new SimpleParseException("Null input");
        }
        if (this.input.length() > 25000) {
            throw new SimpleParseException("Exceeded Maximum Input Size 25000");
        }
        SimpleJsonValue val = null;
        this.tokenizer.tokenize(this.input);
        String str = this.tokenizer.peekNext();
        int depth = 1;
        if (str.equals("{")) {
            val = new SimpleJsonValue(this.parseObject(depth));
            if (this.tokenizer.hasNext()) {
                throw new SimpleParseException("Parse error invalid json object trailing data");
            }
        } else if (str.equals("[")) {
            val = new SimpleJsonValue(this.parseArray(depth));
            if (this.tokenizer.hasNext()) {
                throw new SimpleParseException("Parse error invalid json array trailing data");
            }
        } else {
            throw new SimpleParseException("Parse error invalid json format");
        }
        return val;
    }

    private SimpleJsonArray parseArray(int depth) throws SimpleParseException {
        if (depth == 20) {
            throw new SimpleParseException("Parse json array exception - maximum depth exceeded");
        }
        SimpleJsonArray arr = new SimpleJsonArray();
        boolean done = false;
        while (!done) {
            String token = this.tokenizer.peekNext();
            if (token == null) {
                throw new SimpleParseException("Parse json array exception");
            }
            if (token.equals("[")) {
                this.tokenizer.nextToken();
                SimpleJsonValue val = this.getValue(depth);
                if (val == null) continue;
                arr.addValue(val);
                continue;
            }
            if (token.equals(",")) {
                this.tokenizer.nextToken();
                arr.addValue(this.getValue(depth));
                continue;
            }
            if ("]".equals(token)) {
                this.tokenizer.nextToken();
                done = true;
                continue;
            }
            throw new SimpleParseException("Parse json array exception");
        }
        return arr;
    }

    private SimpleJsonValue getValue(int depth) throws SimpleParseException {
        if (depth == 20) {
            throw new SimpleParseException("Parse json getValue exception - maximum depth exceeded");
        }
        SimpleJsonValue ret = new SimpleJsonValue();
        String token = this.tokenizer.peekNext();
        if (token == null) {
            throw new SimpleParseException("Parse json getValue exception");
        }
        if (token.startsWith("\"")) {
            ret.setType(JsonType.STRING);
            ret.setJsonString(this.getJsonString());
        } else if (this.isNumber(token)) {
            ret.setType(JsonType.NUMBER);
            ret.setJsonNumber(token);
            this.tokenizer.nextToken();
        } else if (token.startsWith("{")) {
            ret.setType(JsonType.OBJECT);
            ret.setJsonObject(this.parseObject(depth + 1));
        } else if (token.startsWith("[")) {
            ret.setType(JsonType.ARRAY);
            ret.setJsonArray(this.parseArray(depth + 1));
        } else if ("true".equals(token) || "false".equals(token)) {
            ret.setType(JsonType.BOOLEAN);
            ret.setJsonBoolean(token);
            this.tokenizer.nextToken();
        } else if ("null".equals(token)) {
            ret.setType(JsonType.NULL);
            ret.setJsonNull(token);
            this.tokenizer.nextToken();
        } else if ("]".equals(token) && "[".equals(this.tokenizer.prevToken())) {
            ret = null;
        } else {
            throw new SimpleParseException("Parse json getValue exception");
        }
        return ret;
    }

    private SimpleJsonObject parseObject(int depth) throws SimpleParseException {
        if (depth == 20) {
            throw new SimpleParseException("Parse json object exception - maximum depth exceeded");
        }
        SimpleJsonObject jsObj = new SimpleJsonObject();
        boolean done = false;
        while (!done) {
            SimpleJsonNamePair np;
            String token = this.tokenizer.peekNext();
            if (token == null) {
                throw new SimpleParseException("Parse json object exception");
            }
            if ("{".equals(token)) {
                this.tokenizer.nextToken();
                np = this.parseNamePair(depth);
                if (np == null) continue;
                jsObj.setNameValue(np.getName(), np.getValue());
                continue;
            }
            if ("}".equals(token)) {
                done = true;
                this.tokenizer.nextToken();
                continue;
            }
            if (",".equals(token)) {
                this.tokenizer.nextToken();
                np = this.parseNamePair(depth);
                if (np == null) {
                    throw new SimpleParseException("Parse json object exception");
                }
                jsObj.setNameValue(np.getName(), np.getValue());
                continue;
            }
            throw new SimpleParseException("Parse json object exception");
        }
        return jsObj;
    }

    private SimpleJsonNamePair parseNamePair(int depth) throws SimpleParseException {
        if (depth == 20) {
            throw new SimpleParseException("Parse json name pair exception - maximum depth exceeded");
        }
        SimpleJsonNamePair namepair = new SimpleJsonNamePair();
        boolean done = false;
        boolean emptystring = true;
        while (!done) {
            String token = this.tokenizer.peekNext();
            if (token == null) {
                throw new SimpleParseException("Parse json name pair exception");
            }
            if (token.startsWith("\"")) {
                namepair.setName(this.getJsonString());
                emptystring = false;
                continue;
            }
            if (":".equals(token)) {
                if (emptystring) {
                    throw new SimpleParseException("Parse json name pair exception");
                }
                this.tokenizer.nextToken();
                namepair.setValue(this.getValue(depth));
                done = true;
                continue;
            }
            if ("}".equals(token) && "{".equals(this.tokenizer.prevToken())) {
                done = true;
                namepair = null;
                continue;
            }
            throw new SimpleParseException("Parse json name pair exception");
        }
        return namepair;
    }

    private boolean isNumber(String token) throws SimpleParseException {
        boolean ret = false;
        if (token == null || token.length() == 0) {
            throw new SimpleParseException("Parse json getValue Number exception");
        }
        char c = token.charAt(0);
        switch (c) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private String getJsonString() throws SimpleParseException {
        String ret = this.tokenizer.nextToken();
        if (ret == null) {
            throw new SimpleParseException("Parse json name pair getString exception");
        }
        if (ret.length() <= 1) {
            throw new SimpleParseException("Parse json name pair getString exception");
        }
        ret = ret.substring(1, ret.length() - 1);
        return ret;
    }
}

