/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.json;

import com.apusic.ams.config.json.SimpleTokenException;
import java.util.ArrayList;

public class SimpleJsonTokenizer {
    private int index = 0;
    private ArrayList<String> tokens = new ArrayList();
    private int tokens_index = 0;

    public String peekNext() {
        if (this.tokens_index < this.tokens.size() && this.tokens_index >= 0) {
            return this.tokens.get(this.tokens_index);
        }
        return null;
    }

    public String nextToken() {
        String ret = null;
        if (this.tokens_index < this.tokens.size() && this.tokens_index >= 0) {
            ret = this.tokens.get(this.tokens_index);
            ++this.tokens_index;
        }
        return ret;
    }

    public String prevToken() {
        String ret = null;
        if (this.tokens_index <= this.tokens.size() && this.tokens_index >= 1) {
            ret = this.tokens.get(this.tokens_index - 1);
        }
        return ret;
    }

    public boolean hasNext() {
        return this.tokens_index < this.tokens.size() && this.tokens_index >= 0;
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    private void skipSpace(String input) {
        if (input == null) {
            return;
        }
        if (this.index < input.length() && this.index >= 0) {
            char c = input.charAt(this.index);
            while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                ++this.index;
                if (this.index >= input.length() || this.index <= 0) break;
                c = input.charAt(this.index);
            }
        }
    }

    public void tokenize(String input) throws SimpleTokenException {
        if (input == null) {
            return;
        }
        this.index = 0;
        this.skipSpace(input);
        this.tokens = new ArrayList();
        this.tokens_index = 0;
        block8: while (this.index < input.length() && this.index >= 0) {
            char c = input.charAt(this.index);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.skipSpace(input);
                    continue block8;
                }
                case ',': 
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    this.tokens.add(Character.toString(c));
                    ++this.index;
                    continue block8;
                }
                case '\"': {
                    this.tokens.add(this.getJsonString(input));
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.tokens.add(this.getJsonNumber(input, false));
                    continue block8;
                }
                case '-': {
                    this.tokens.add(this.getJsonNumber(input, true));
                    continue block8;
                }
                case 'f': 
                case 'n': 
                case 't': {
                    this.tokens.add(this.getNullTrueFalse(input));
                    continue block8;
                }
            }
            throw new SimpleTokenException("Invalid token");
        }
    }

    private String getNullTrueFalse(String input) throws SimpleTokenException {
        if (input == null || this.index >= input.length() || this.index < 0) {
            throw new SimpleTokenException("Invalid null/true/false tokenization error");
        }
        StringBuffer sb = new StringBuffer();
        char c = input.charAt(this.index);
        switch (c) {
            case 'n': {
                if (this.index + 4 > input.length()) {
                    throw new SimpleTokenException("Invalid null/true/false tokenization error");
                }
                String str_null = input.substring(this.index, this.index + 4);
                if ("null".equals(str_null)) {
                    sb.append(str_null);
                }
                this.index += 4;
                break;
            }
            case 't': {
                if (this.index + 4 > input.length()) {
                    throw new SimpleTokenException("Invalid null/true/false tokenization error");
                }
                String str_true = input.substring(this.index, this.index + 4);
                if ("true".equals(str_true)) {
                    sb.append(str_true);
                }
                this.index += 4;
                break;
            }
            case 'f': {
                if (this.index + 5 > input.length()) {
                    throw new SimpleTokenException("Invalid null/true/false tokenization error");
                }
                String str_false = input.substring(this.index, this.index + 5);
                if ("false".equals(str_false)) {
                    sb.append(str_false);
                }
                this.index += 5;
                break;
            }
            default: {
                throw new SimpleTokenException("Invalid null/true/false tokenization error");
            }
        }
        return sb.toString();
    }

    private String getJsonNumber(String input, boolean neg) throws SimpleTokenException {
        char nc;
        if (input == null || this.index >= input.length() || this.index < 0) {
            throw new SimpleTokenException("Invalid Number tokenization error");
        }
        StringBuffer sb = new StringBuffer();
        char c = input.charAt(this.index);
        sb.append(c);
        ++this.index;
        boolean done = false;
        boolean decimal = false;
        boolean exponential = false;
        boolean exponential_sign = false;
        if (c == '0') {
            if (this.index >= input.length() || this.index < 0) {
                throw new SimpleTokenException("Invalid Number tokenization error");
            }
            nc = input.charAt(this.index);
            switch (nc) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    throw new SimpleTokenException("Invalid Number tokenization error leading zero");
                }
            }
        }
        while (!done) {
            if (this.index >= input.length() || this.index < 0) {
                throw new SimpleTokenException("Invalid Number tokenization error");
            }
            c = input.charAt(this.index);
            if (Character.isDigit(c)) {
                sb.append(c);
                ++this.index;
                if (!neg) continue;
                neg = false;
                if (c != '0') continue;
                if (this.index >= input.length() || this.index < 0) {
                    throw new SimpleTokenException("Invalid Number tokenization error");
                }
                nc = input.charAt(this.index);
                switch (nc) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        throw new SimpleTokenException("Invalid Number tokenization error leading zero");
                    }
                }
                continue;
            }
            if (c == '.' && !neg) {
                if (!decimal) {
                    sb.append(c);
                    decimal = true;
                    ++this.index;
                    if (this.index >= input.length() || this.index < 0) {
                        throw new SimpleTokenException("Invalid Number tokenization error");
                    }
                    c = input.charAt(this.index);
                    if (Character.isDigit(c)) {
                        sb.append(c);
                        ++this.index;
                        continue;
                    }
                    throw new SimpleTokenException("Invalid Number (decimal) tokenization error");
                }
                throw new SimpleTokenException("Invalid Number (decimal) tokenization error");
            }
            if (!(c != 'e' && c != 'E' || neg || exponential)) {
                sb.append(c);
                ++this.index;
                exponential = true;
                boolean innerdone = false;
                boolean added_digit_after_e = false;
                boolean added_digit_after_e_sign = false;
                while (!innerdone) {
                    if (this.index >= input.length() || this.index < 0) {
                        throw new SimpleTokenException("Invalid Number (exponential) tokenization error");
                    }
                    char ch = input.charAt(this.index);
                    if (Character.isDigit(ch)) {
                        sb.append(ch);
                        ++this.index;
                        added_digit_after_e = true;
                        if (!exponential_sign) continue;
                        added_digit_after_e_sign = true;
                        continue;
                    }
                    if (!(ch != '-' && ch != '+' || exponential_sign)) {
                        sb.append(ch);
                        ++this.index;
                        exponential_sign = true;
                        continue;
                    }
                    innerdone = true;
                }
                if (added_digit_after_e || added_digit_after_e_sign) continue;
                throw new SimpleTokenException("Invalid Number (exponential) tokenization error");
            }
            if ((c == ',' || c == '}' || c == ']' || Character.isWhitespace(c)) && !neg) {
                done = true;
                continue;
            }
            throw new SimpleTokenException("Invalid Number(termination) tokenization error");
        }
        return sb.toString();
    }

    private String getJsonStringEscapeSequenceHex(String input) throws SimpleTokenException {
        ++this.index;
        if (input == null || this.index >= input.length() || this.index < 0) {
            throw new SimpleTokenException("Invalid String tokenization (escape sequence \\u hexidecimal) error");
        }
        StringBuffer sb = new StringBuffer();
        sb.append('u');
        block3: for (int i = 0; i < 4; ++i) {
            if (this.index >= input.length() || this.index < 0) {
                throw new SimpleTokenException("Invalid String tokenization (escape sequence \\u hexidecimal) error");
            }
            char c = input.charAt(this.index);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    sb.append(c);
                    ++this.index;
                    continue block3;
                }
                default: {
                    throw new SimpleTokenException("Invalid String tokenization (escape sequence \\u hexidecimal) error");
                }
            }
        }
        return sb.toString();
    }

    private String getJsonStringEscapeSequence(String input) throws SimpleTokenException {
        ++this.index;
        if (input == null || this.index >= input.length() || this.index < 0) {
            throw new SimpleTokenException("Invalid String tokenization (escape sequence) error");
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\\');
        char c = input.charAt(this.index);
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                sb.append(c);
                ++this.index;
                break;
            }
            case 'u': {
                sb.append(this.getJsonStringEscapeSequenceHex(input));
                break;
            }
            default: {
                throw new SimpleTokenException("Invalid String tokenization (escape sequence) error");
            }
        }
        return sb.toString();
    }

    private String getJsonString(String input) throws SimpleTokenException {
        if (input == null || this.index >= input.length() || this.index < 0) {
            throw new SimpleTokenException("Invalid String tokenization error");
        }
        StringBuffer sb = new StringBuffer();
        char c = input.charAt(this.index);
        sb.append(c);
        ++this.index;
        boolean done = false;
        while (!done) {
            if (this.index >= input.length() || this.index < 0) {
                throw new SimpleTokenException("Invalid String tokenization error");
            }
            c = input.charAt(this.index);
            if (c == '\\') {
                sb.append(this.getJsonStringEscapeSequence(input));
                continue;
            }
            if (Character.isISOControl(c)) {
                throw new SimpleTokenException("Invalid String tokenization error, control chars");
            }
            if (c == '\"') {
                done = true;
            }
            sb.append(c);
            ++this.index;
        }
        return sb.toString();
    }

    public void printTokens() {
        for (String t : this.tokens) {
            System.out.println(t);
        }
    }
}

