/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.json;

import com.apusic.ams.config.json.JsonType;
import com.apusic.ams.config.json.SimpleJsonArray;
import com.apusic.ams.config.json.SimpleJsonObject;

public class SimpleJsonValue {
    JsonType type;
    private String jsonstring;
    private String jsonnumber;
    private SimpleJsonObject jsonobject;
    private SimpleJsonArray jsonarray;
    private String jsonboolean;
    private String jsonnull;

    public SimpleJsonValue() {
        this.jsonstring = null;
        this.jsonnumber = null;
        this.jsonobject = null;
        this.jsonarray = null;
        this.jsonboolean = null;
        this.jsonnull = null;
    }

    public SimpleJsonValue(SimpleJsonObject obj) {
        this.type = JsonType.OBJECT;
        this.jsonobject = obj;
    }

    public SimpleJsonValue(SimpleJsonArray arr) {
        this.type = JsonType.ARRAY;
        this.jsonarray = arr;
    }

    public SimpleJsonValue(String input, JsonType type) {
        switch (type) {
            case STRING: {
                this.type = type;
                this.jsonstring = input;
                break;
            }
            case NUMBER: {
                this.type = type;
                this.jsonnumber = input;
                break;
            }
            case BOOLEAN: {
                this.type = type;
                this.setJsonBoolean(input);
                break;
            }
            case NULL: {
                this.type = type;
                this.setJsonNull(input);
                break;
            }
        }
    }

    public void setType(JsonType type) {
        this.type = type;
    }

    public JsonType getType() {
        return this.type;
    }

    public void setJsonString(String s) {
        this.jsonstring = s;
    }

    public String getJsonString() {
        return this.jsonstring;
    }

    public void setJsonNumber(String num) {
        this.jsonnumber = num;
    }

    public String getJsonNumber() {
        return this.jsonnumber;
    }

    public void setJsonObject(SimpleJsonObject jsonObj) {
        this.jsonobject = jsonObj;
    }

    public SimpleJsonObject getJsonObject() {
        return this.jsonobject;
    }

    public void setJsonArray(SimpleJsonArray arr) {
        this.jsonarray = arr;
    }

    public SimpleJsonArray getJsonArray() {
        return this.jsonarray;
    }

    public void setJsonBoolean(String b) {
        if (b == null) {
            return;
        }
        if ("false".equals(b) || "true".equals(b)) {
            this.jsonboolean = b;
        }
    }

    public String getJsonBoolean() {
        return this.jsonboolean;
    }

    public void setJsonNull(String n) {
        if (n == null) {
            return;
        }
        if ("null".equals(n)) {
            this.jsonnull = n;
        }
    }

    public String getJsonNull() {
        return this.jsonnull;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case STRING: {
                if (this.jsonstring == null) break;
                sb.append("\"" + this.jsonstring + "\"");
                break;
            }
            case NUMBER: {
                if (this.jsonnumber == null) break;
                sb.append(this.jsonnumber);
                break;
            }
            case OBJECT: {
                if (this.jsonobject != null) {
                    sb.append(this.jsonobject.toString());
                    break;
                }
                sb.append("{}");
                break;
            }
            case ARRAY: {
                if (this.jsonarray != null) {
                    sb.append(this.jsonarray.toString());
                    break;
                }
                sb.append("[]");
                break;
            }
            case BOOLEAN: {
                if (this.jsonboolean == null) break;
                sb.append(this.jsonboolean);
                break;
            }
            case NULL: {
                if (this.jsonnull == null) break;
                sb.append(this.jsonnull);
                break;
            }
        }
        return sb.toString();
    }
}

