/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.listener;

import com.apusic.ams.LifecycleEvent;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.config.api.ApusicConfig;
import com.apusic.ams.config.api.CachedConfig;
import com.apusic.ams.config.api.CloudConfigMgr;
import com.apusic.ams.config.api.DataSourceConfig;
import com.apusic.ams.config.api.JvmConfig;
import com.apusic.ams.config.api.LoggingConfig;
import com.apusic.ams.config.util.CloudUtil;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class ApolloPluginLoader
implements LifecycleListener {
    private static final Log logger = LogFactory.getLog(ApolloPluginLoader.class);
    public static final String AAS_CONFIG_APOLLO_APP_ID = "AAS_CONFIG_APOLLO_APP_ID";
    public static final String AAS_CONFIG_APOLLO_ACCESSKEY_SECRET = "AAS_CONFIG_APOLLO_ACCESSKEY_SECRET";
    public static final String AAS_CONFIG_APOLLO_META_SERVER = "AAS_CONFIG_APOLLO_META_SERVER";
    public static final String AAS_CONFIG_APOLLO_CLUSTER = "AAS_CONFIG_APOLLO_CLUSTER";
    public static final String AAS_CONFIG_APOLLO_IDC = "AAS_CONFIG_APOLLO_IDC";
    public static final String AAS_CONFIG_APOLLO_NAMESPACE = "AAS_CONFIG_APOLLO_NAMESPACE";
    public static final String AAS_CONFIG_APOLLO_ENV = "AAS_CONFIG_APOLLO_ENV";
    private static final String _APOLLO_CLUSTER_ = "apollo.cluster";
    private ClassLoader classloader;
    private String appId;
    private String accessKeySecret;
    private String namespace;
    private String cluster;
    private String metaUrl;
    private String idc;
    private String env;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getMetaUrl() {
        return this.metaUrl;
    }

    public void setMetaUrl(String metaUrl) {
        this.metaUrl = metaUrl;
    }

    public String getIdc() {
        return this.idc;
    }

    public void setIdc(String idc) {
        this.idc = idc;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public ApolloPluginLoader() {
        File file = CloudUtil.getFile("plugins", "apollo");
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            urlList.add(new File(file, "aas-apollo.jar").toURI().toURL());
            if (file.isDirectory()) {
                for (File jar : file.listFiles()) {
                    if (jar.getName().equals("aas-apollo.jar") || !jar.getName().endsWith(".jar")) continue;
                    urlList.add(jar.toURI().toURL());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.classloader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        this.resetParameters();
        if (this.metaUrl == null || this.appId == null) {
            logger.error("apollo config not set!!! ");
            return;
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        String oldCluster = System.getProperty(_APOLLO_CLUSTER_);
        try {
            this.setSystemProperty(_APOLLO_CLUSTER_, this.cluster, "");
            this.setSystemProperty(AAS_CONFIG_APOLLO_APP_ID, this.appId, "");
            this.setSystemProperty(AAS_CONFIG_APOLLO_ACCESSKEY_SECRET, this.accessKeySecret, "");
            this.setSystemProperty(AAS_CONFIG_APOLLO_META_SERVER, this.metaUrl, "");
            this.setSystemProperty(AAS_CONFIG_APOLLO_CLUSTER, this.cluster, "");
            this.setSystemProperty(AAS_CONFIG_APOLLO_IDC, this.idc, "");
            this.setSystemProperty(AAS_CONFIG_APOLLO_NAMESPACE, this.namespace, "");
            this.setSystemProperty(AAS_CONFIG_APOLLO_ENV, this.env, "");
            Thread.currentThread().setContextClassLoader(this.classloader);
            Class<?> clazz = this.classloader.loadClass("com.apusic.ams.apollo.config.ApolloConfigMgr");
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, String.class, String.class, String.class, String.class);
            CloudConfigMgr mgr = (CloudConfigMgr)constructor.newInstance(this.metaUrl, this.appId, this.idc, this.cluster, this.namespace, this.env);
            mgr.addCloudConfig(new ApusicConfig());
            mgr.addCloudConfig(new JvmConfig());
            mgr.addCloudConfig(new LoggingConfig());
            mgr.addCloudConfig(new DataSourceConfig());
            mgr.addCloudConfig(new CachedConfig());
            mgr.fetch();
            mgr.watch();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.setSystemProperty(_APOLLO_CLUSTER_, oldCluster, "");
        }
    }

    private void setSystemProperty(String name, String value, String ifNullValue) {
        System.setProperty(name, value == null ? ifNullValue : value);
    }

    private void resetParameters() {
        String _appId = System.getProperty(AAS_CONFIG_APOLLO_APP_ID, System.getenv(AAS_CONFIG_APOLLO_APP_ID));
        String _accessKeySecret = System.getProperty(AAS_CONFIG_APOLLO_ACCESSKEY_SECRET, System.getenv(AAS_CONFIG_APOLLO_ACCESSKEY_SECRET));
        String _metaUrl = System.getProperty(AAS_CONFIG_APOLLO_META_SERVER, System.getenv(AAS_CONFIG_APOLLO_META_SERVER));
        String _cluster = System.getProperty(AAS_CONFIG_APOLLO_CLUSTER, System.getenv(AAS_CONFIG_APOLLO_CLUSTER));
        String _idc = System.getProperty(AAS_CONFIG_APOLLO_IDC, System.getenv(AAS_CONFIG_APOLLO_IDC));
        String _namespace = System.getProperty(AAS_CONFIG_APOLLO_NAMESPACE, System.getenv(AAS_CONFIG_APOLLO_NAMESPACE));
        String _env = System.getProperty(AAS_CONFIG_APOLLO_ENV, System.getenv(AAS_CONFIG_APOLLO_ENV));
        if (_appId != null && _appId.length() > 0) {
            this.appId = _appId;
        }
        if (_accessKeySecret != null && _accessKeySecret.length() > 0) {
            this.accessKeySecret = _accessKeySecret;
        }
        if (this.metaUrl != null && _metaUrl.length() > 0) {
            this.metaUrl = _metaUrl;
        }
        if (_cluster != null && _cluster.length() > 0) {
            this.cluster = _cluster;
        }
        if (_idc != null && _idc.length() > 0) {
            this.idc = _idc;
        }
        if (_namespace != null && _namespace.length() > 0) {
            this.namespace = _namespace;
        }
        if (_env != null && _env.length() > 0) {
            this.env = _env;
        }
    }
}

