/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.config.listener;

import com.apusic.ams.LifecycleEvent;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.config.api.ApusicConfig;
import com.apusic.ams.config.api.CachedConfig;
import com.apusic.ams.config.api.CloudConfigMgr;
import com.apusic.ams.config.api.DataSourceConfig;
import com.apusic.ams.config.api.JvmConfig;
import com.apusic.ams.config.api.LoggingConfig;
import com.apusic.ams.config.util.CloudUtil;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class EtcdPluginLoader
implements LifecycleListener {
    private static final Log logger = LogFactory.getLog(EtcdPluginLoader.class);
    private static final String AAS_CONFIG_ETCD_HOST = "AAS_CONFIG_ETCD_HOST";
    private static final String AAS_CONFIG_ETCD_PORT = "AAS_CONFIG_ETCD_PORT";
    private static final String AAS_CONFIG_ETCD_NAMESPACE = "AAS_CONFIG_ETCD_NAMESPACE";
    private static final String AAS_CONFIG_ETCD_CLUSTERID = "AAS_CONFIG_ETCD_CLUSTERID";
    private String host;
    private String port;
    private String namespace;
    private String clusterId;
    private ClassLoader classloader;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public EtcdPluginLoader() {
        File file = CloudUtil.getFile("plugins", this.getEtcdLibDir());
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            urlList.add(new File(file, "aas-etcd.jar").toURI().toURL());
            if (file.isDirectory()) {
                for (File jar : file.listFiles()) {
                    if (jar.getName().equals("aas-etcd.jar") || !jar.getName().endsWith(".jar")) continue;
                    urlList.add(jar.toURI().toURL());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.classloader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), Thread.currentThread().getContextClassLoader());
    }

    public String getManagerClass() {
        return "com.apusic.ams.etcd.config.EtcdConfigMgrV2";
    }

    public String getEtcdLibDir() {
        return "etcd";
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        this.resetParameters();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            Class<?> clazz = this.classloader.loadClass(this.getManagerClass());
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, String.class, String.class);
            CloudConfigMgr mgr = (CloudConfigMgr)constructor.newInstance(this.host, this.port, this.namespace, this.clusterId);
            ApusicConfig apusic_conf = new ApusicConfig();
            JvmConfig jvm_conf = new JvmConfig();
            LoggingConfig logging_conf = new LoggingConfig();
            DataSourceConfig data_conf = new DataSourceConfig();
            CachedConfig memcached_config = new CachedConfig();
            mgr.addCloudConfig(apusic_conf);
            mgr.addCloudConfig(jvm_conf);
            mgr.addCloudConfig(logging_conf);
            mgr.addCloudConfig(data_conf);
            mgr.addCloudConfig(memcached_config);
            mgr.fetch();
            mgr.watch();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void resetParameters() {
        String _host = System.getProperty(AAS_CONFIG_ETCD_HOST, System.getenv(AAS_CONFIG_ETCD_HOST));
        String _port = System.getProperty(AAS_CONFIG_ETCD_PORT, System.getenv(AAS_CONFIG_ETCD_PORT));
        String _namespace = System.getProperty(AAS_CONFIG_ETCD_NAMESPACE, System.getenv(AAS_CONFIG_ETCD_NAMESPACE));
        String _clusterId = System.getProperty(AAS_CONFIG_ETCD_CLUSTERID, System.getenv(AAS_CONFIG_ETCD_CLUSTERID));
        if (_host != null && _host.length() > 0) {
            this.host = _host;
        }
        if (_port != null && _port.length() > 0) {
            this.port = _port;
        }
        if (_namespace != null && _namespace.length() > 0) {
            this.namespace = _namespace;
        }
        if (_clusterId != null && _clusterId.length() > 0) {
            this.clusterId = _clusterId;
        }
    }
}

