/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.core;

import com.apusic.aas.util.buf.MessageBytes;
import com.apusic.aas.util.res.StringManager;
import com.apusic.ams.Wrapper;
import com.apusic.ams.connector.Request;
import com.apusic.ams.connector.Response;
import com.apusic.ams.valves.ValveBase;
import com.apusic.connector.ContinueResponseTiming;
import java.io.IOException;
import javax.servlet.ServletException;

final class StandardContextValve
extends ValveBase {
    private static final StringManager sm = StringManager.getManager(StandardContextValve.class);

    public StandardContextValve() {
        super(true);
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
            response.sendError(404);
            return;
        }
        Wrapper wrapper = request.getWrapper();
        if (wrapper == null || wrapper.isUnavailable()) {
            response.sendError(404);
            return;
        }
        try {
            response.sendAcknowledgement(ContinueResponseTiming.IMMEDIATELY);
        }
        catch (IOException ioe) {
            this.container.getLogger().error(sm.getString("standardContextValve.acknowledgeException"), ioe);
            request.setAttribute("javax.servlet.error.exception", ioe);
            response.sendError(500);
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(wrapper.getPipeline().isAsyncSupported());
        }
        wrapper.getPipeline().getFirst().invoke(request, response);
    }
}

