/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.core;

import com.apusic.aas.util.ExceptionUtils;
import com.apusic.aas.util.buf.StringCache;
import com.apusic.aas.util.modeler.Registry;
import com.apusic.aas.util.res.StringManager;
import com.apusic.aas.util.threads.ScheduledThreadPoolExecutor;
import com.apusic.aas.util.threads.TaskThreadFactory;
import com.apusic.ams.Context;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleState;
import com.apusic.ams.Server;
import com.apusic.ams.Service;
import com.apusic.ams.core.NamingContextListener;
import com.apusic.ams.core.ReportEventMgrAdapter;
import com.apusic.ams.core.StandardService;
import com.apusic.ams.deploy.NamingResourcesImpl;
import com.apusic.ams.mbeans.MBeanFactory;
import com.apusic.ams.startup.Apusic;
import com.apusic.ams.util.ExtensionValidator;
import com.apusic.ams.util.LifecycleMBeanBase;
import com.apusic.ams.util.ServerInfo;
import com.apusic.com.google.gson.Gson;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import com.apusic.util.CryptUtil;
import com.apusic.util.CryptUtilAuthData;
import com.apusic.util.MacMain;
import com.apusic.util.RSAUtil;
import com.apusic.util.Utils;
import com.apusic.util.Version;
import com.apusic.util.broker.BrokerMgrFac;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class StandardServer
extends LifecycleMBeanBase
implements Server {
    private static final Log log = LogFactory.getLog(StandardServer.class);
    private static final StringManager sm = StringManager.getManager(StandardServer.class);
    private javax.naming.Context globalNamingContext = null;
    private NamingResourcesImpl globalNamingResources = null;
    private final NamingContextListener namingContextListener;
    private int port = 8005;
    private int portOffset = 0;
    private String address = "localhost";
    private Random random = null;
    private Service[] services = new Service[0];
    private final Object servicesLock = new Object();
    private String shutdown = "SHUTDOWN";
    final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private volatile boolean stopAwait = false;
    private Apusic apusic = null;
    private ClassLoader parentClassLoader = null;
    private volatile Thread awaitThread = null;
    private volatile ServerSocket awaitSocket = null;
    private File apusicHome = null;
    private File apusicBase = null;
    private final Object namingToken = new Object();
    protected int utilityThreads = 2;
    protected boolean utilityThreadsAsDaemon = false;
    private java.util.concurrent.ScheduledThreadPoolExecutor utilityExecutor = null;
    private ScheduledExecutorService utilityExecutorWrapper = null;
    private ScheduledExecutorService licenseExecutor = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> periodicLifecycleEventFuture = null;
    private ScheduledFuture<?> monitorFuture;
    protected int periodicEventDelay = 10;
    private ObjectName onameStringCache;
    private ObjectName onameMBeanFactory;

    public StandardServer() {
        this.globalNamingResources = new NamingResourcesImpl();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming()) {
            this.namingContextListener = new NamingContextListener();
            this.addLifecycleListener(this.namingContextListener);
        } else {
            this.namingContextListener = null;
        }
    }

    @Override
    public Object getNamingToken() {
        return this.namingToken;
    }

    @Override
    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    @Override
    public NamingResourcesImpl getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    @Override
    public void setGlobalNamingResources(NamingResourcesImpl globalNamingResources) {
        NamingResourcesImpl oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public String getServerBuilt() {
        return ServerInfo.getServerBuilt();
    }

    public String getServerNumber() {
        return ServerInfo.getServerNumber();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPortOffset() {
        return this.portOffset;
    }

    @Override
    public void setPortOffset(int portOffset) {
        if (portOffset < 0) {
            throw new IllegalArgumentException(sm.getString("standardServer.portOffset.invalid", portOffset));
        }
        this.portOffset = portOffset;
    }

    @Override
    public int getPortWithOffset() {
        int port = this.getPort();
        if (port > 0) {
            return port + this.getPortOffset();
        }
        return port;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public Apusic getApusic() {
        return this.apusic;
    }

    @Override
    public void setApusic(Apusic apusic) {
        this.apusic = apusic;
    }

    @Override
    public int getUtilityThreads() {
        return this.utilityThreads;
    }

    private static int getUtilityThreadsInternal(int utilityThreads) {
        int result = utilityThreads;
        if (result <= 0 && (result = Runtime.getRuntime().availableProcessors() + result) < 2) {
            result = 2;
        }
        return result;
    }

    @Override
    public void setUtilityThreads(int utilityThreads) {
        int oldUtilityThreads = this.utilityThreads;
        if (StandardServer.getUtilityThreadsInternal(utilityThreads) < StandardServer.getUtilityThreadsInternal(oldUtilityThreads)) {
            return;
        }
        this.utilityThreads = utilityThreads;
        if (oldUtilityThreads != utilityThreads && this.utilityExecutor != null) {
            this.reconfigureUtilityExecutor(StandardServer.getUtilityThreadsInternal(utilityThreads));
        }
    }

    private synchronized void reconfigureUtilityExecutor(int threads) {
        if (this.utilityExecutor != null) {
            this.utilityExecutor.setCorePoolSize(threads);
        } else {
            java.util.concurrent.ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new java.util.concurrent.ScheduledThreadPoolExecutor(threads, new TaskThreadFactory("Apusic-utility-", this.utilityThreadsAsDaemon, 1));
            scheduledThreadPoolExecutor.setKeepAliveTime(10L, TimeUnit.SECONDS);
            scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.utilityExecutor = scheduledThreadPoolExecutor;
            this.utilityExecutorWrapper = new ScheduledThreadPoolExecutor(this.utilityExecutor);
        }
    }

    public boolean getUtilityThreadsAsDaemon() {
        return this.utilityThreadsAsDaemon;
    }

    public void setUtilityThreadsAsDaemon(boolean utilityThreadsAsDaemon) {
        this.utilityThreadsAsDaemon = utilityThreadsAsDaemon;
    }

    public final int getPeriodicEventDelay() {
        return this.periodicEventDelay;
    }

    public final void setPeriodicEventDelay(int periodicEventDelay) {
        this.periodicEventDelay = periodicEventDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(Service service) {
        service.setServer(this);
        Object object = this.servicesLock;
        synchronized (object) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.getState().isAvailable()) {
                try {
                    service.start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
        }
    }

    public void stopAwait() {
        this.stopAwait = true;
        Thread t = this.awaitThread;
        if (t != null) {
            ServerSocket s = this.awaitSocket;
            if (s != null) {
                this.awaitSocket = null;
                try {
                    s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            t.interrupt();
            try {
                t.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void await() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.servicesLock;
        synchronized (object) {
            for (Service service : this.services) {
                if (!name.equals(service.getName())) continue;
                return service;
            }
        }
        return null;
    }

    @Override
    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            onames[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(Service service) {
        Object object = this.servicesLock;
        synchronized (object) {
            int j = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            try {
                this.services[j].stop();
            }
            catch (LifecycleException i) {
                // empty catch block
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == j) continue;
                results[k++] = this.services[i];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
        }
    }

    @Override
    public File getApusicBase() {
        if (this.apusicBase != null) {
            return this.apusicBase;
        }
        this.apusicBase = this.getApusicHome();
        return this.apusicBase;
    }

    @Override
    public void setApusicBase(File apusicBase) {
        this.apusicBase = apusicBase;
    }

    @Override
    public File getApusicHome() {
        return this.apusicHome;
    }

    @Override
    public void setApusicHome(File apusicHome) {
        this.apusicHome = apusicHome;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardServer[");
        sb.append(this.getPort());
        sb.append(']');
        return sb.toString();
    }

    public synchronized void storeConfig() throws InstanceNotFoundException, MBeanException {
        try {
            ObjectName sname = new ObjectName("Apusic:type=StoreConfig");
            MBeanServer server = Registry.getRegistry(null, null).getMBeanServer();
            if (server.isRegistered(sname)) {
                server.invoke(sname, "storeConfig", null, null);
            } else {
                log.error(sm.getString("standardServer.storeConfig.notAvailable", sname));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("standardServer.storeConfig.error"), t);
        }
    }

    public synchronized void storeContext(Context context) throws InstanceNotFoundException, MBeanException {
        try {
            ObjectName sname = new ObjectName("Apusic:type=StoreConfig");
            MBeanServer server = Registry.getRegistry(null, null).getMBeanServer();
            if (server.isRegistered(sname)) {
                server.invoke(sname, "store", new Object[]{context}, new String[]{"java.lang.String"});
            } else {
                log.error(sm.getString("standardServer.storeConfig.notAvailable", sname));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("standardServer.storeConfig.contextError", context.getName()), t);
        }
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("apusic.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
        this.globalNamingResources.start();
        Object object = this.servicesLock;
        synchronized (object) {
            for (Service service : this.services) {
                service.start();
            }
        }
        if (this.periodicEventDelay > 0) {
            this.monitorFuture = this.getUtilityExecutor().scheduleWithFixedDelay(() -> this.startPeriodicLifecycleEvent(), 0L, 60L, TimeUnit.SECONDS);
        }
    }

    protected void startPeriodicLifecycleEvent() {
        if (this.periodicLifecycleEventFuture == null || this.periodicLifecycleEventFuture != null && this.periodicLifecycleEventFuture.isDone()) {
            if (this.periodicLifecycleEventFuture != null && this.periodicLifecycleEventFuture.isDone()) {
                try {
                    this.periodicLifecycleEventFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error(sm.getString("standardServer.periodicEventError"), e);
                }
            }
            this.periodicLifecycleEventFuture = this.getUtilityExecutor().scheduleAtFixedRate(() -> this.fireLifecycleEvent("periodic", null), this.periodicEventDelay, this.periodicEventDelay, TimeUnit.SECONDS);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        block156: {
            int lic_version = 0;
            String lic_sn = null;
            String lic_cdkey = null;
            String lic_prodname = null;
            String lic_edition = null;
            String lic_editionAlias = null;
            String lic_prodversion = null;
            String lic_licensee = null;
            String lic_addressStr = "";
            String lic_authAddStr = "";
            String lic_authBy = "";
            String lic_aowedIPs = "";
            boolean lic_center = false;
            int lic_address = 0;
            int lic_connections = 0;
            long lic_datefrom = 0L;
            long lic_dateend = 0L;
            int lic_durationDays = 0;
            int lic_licenses = 0;
            Map lic_extraAttrs = null;
            String lic_ip = null;
            int lic_port = -1;
            String lic_id = "0000000000";
            String signature = null;
            byte[] lic_input = null;
            File lic_file = null;
            InputStream lic_is = null;
            int lic_granted = 2130706433;
            try {
                boolean isNormal;
                Object in;
                int _i;
                String verfile = new StringBuffer("com/apusic/").append("web/WebSe").append("rviceUtil.cl").append("ass").toString();
                byte[] lic_name = new byte[16];
                byte[] share_lic_name = new byte[16];
                byte[] share_lic_dir = new byte[16];
                long _xx = 7105912L;
                long _yy = 3343205216377071980L;
                for (_i = 8; _i > 0; --_i) {
                    lic_name[16 - _i] = (byte)_xx;
                    lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0L;
                _yy = 29401359424121196L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_name[16 - _i] = (byte)_xx;
                    share_lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0x303030L;
                _yy = 3487320404452927852L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_dir[16 - _i] = (byte)_xx;
                    share_lic_dir[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
                if (keypath != null && !keypath.equals("") && !(lic_file = new File(keypath)).exists()) {
                    lic_file = Utils.getLicFile((String)keypath);
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
                }
                lic_is = lic_file.exists() ? new FileInputStream(lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
                String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
                StringBuffer sb = new StringBuffer();
                boolean isnew = false;
                BufferedReader ps = null;
                ps = new BufferedReader(new InputStreamReader(lic_is, fileCharset));
                ps.mark(1024);
                String line = ps.readLine();
                if (line.trim().startsWith("{")) {
                    isnew = true;
                }
                if (isnew) {
                    while (line != null) {
                        sb.append(line);
                        line = ps.readLine();
                    }
                    Gson gson = new Gson();
                    Map map0 = gson.fromJson(sb.toString(), Map.class);
                    String sign = (String)map0.get("sign");
                    String data = (String)map0.get("license");
                    boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                    if (!baomiOK) {
                        throw new Exception("m");
                    }
                    lic_version = 1;
                    Map map = gson.fromJson(data, Map.class);
                    lic_licensee = (String)map.get("code");
                    lic_prodversion = (String)map.get("productVersion");
                    lic_datefrom = ((Double)map.get("createDate")).longValue();
                    lic_dateend = ((Double)map.get("expireDate")).longValue();
                    lic_addressStr = (String)map.get("deviceId");
                    Map groupMap = (Map)((List)map.get("groups")).get(0);
                    String connstr = (String)groupMap.get("count");
                    lic_connections = Integer.parseInt(connstr);
                    Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                    lic_licenses = ((Double)moduleMap.get("count")).intValue();
                    String extStr = (String)map.get("extraData");
                    Map extMap = gson.fromJson(extStr, Map.class);
                    lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                    lic_edition = (String)lic_extraAttrs.get("specification");
                    lic_prodname = (String)lic_extraAttrs.get("productEnName");
                    lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                    lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                    lic_id = (String)lic_extraAttrs.get("id");
                    lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                    lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                }
                if (!isnew) {
                    int _keySize;
                    ps.reset();
                    InputSource is = new InputSource(ps);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element root = doc.getDocumentElement();
                    signature = root.getAttribute("signature");
                    Class<?> base64Class = null;
                    try {
                        base64Class = Class.forName("com.apusic.util.Base64");
                    }
                    catch (Throwable t) {
                        base64Class = Class.forName("com.apusic.license.util.Base64");
                    }
                    Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                    lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{signature.getBytes("UTF-8")});
                    byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                    int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                    int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                    byte[] _nbytes = new byte[_nlen];
                    byte[] _ebytes = new byte[_elen];
                    System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                    System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                    BigInteger _n = new BigInteger(1, _nbytes);
                    BigInteger _e = new BigInteger(1, _ebytes);
                    int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                    int _outputBlockSize = _keySize - 1;
                    int _outSize = (lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                    byte[] _output = new byte[_outSize];
                    int _inputOffset = 0;
                    int _outputOffset = 0;
                    while (_inputOffset < lic_input.length) {
                        byte[] _block = new byte[_inputBlockSize];
                        int _remainder = lic_input.length - _inputOffset;
                        if (_remainder > _inputBlockSize) {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _inputBlockSize);
                        } else {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _remainder);
                        }
                        BigInteger _x = new BigInteger(1, _block);
                        BigInteger _y = _x.modPow(_e, _n);
                        _block = _y.toByteArray();
                        if (_block.length <= _outputBlockSize) {
                            System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                        } else {
                            System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                        }
                        _inputOffset += _inputBlockSize;
                        _outputOffset += _outputBlockSize;
                    }
                    int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                    int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                    byte[] lic_data = new byte[lic_len];
                    for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                        lic_data[_i2] = _output[lic_off];
                        lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                    }
                    ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                    DataInputStream _in = new DataInputStream(_bis);
                    lic_version = _in.readShort();
                    lic_sn = _in.readUTF();
                    lic_cdkey = _in.readUTF();
                    lic_prodname = _in.readUTF();
                    if (lic_version >= 4) {
                        String lic_extraAttrsStr;
                        lic_edition = _in.readUTF();
                        lic_editionAlias = _in.readUTF();
                        lic_prodversion = _in.readUTF();
                        lic_licensee = _in.readUTF();
                        if (lic_version == 32 || lic_version > 49) {
                            lic_addressStr = _in.readUTF();
                        } else {
                            lic_address = _in.readInt();
                        }
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_licenses = _in.readInt();
                        if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                            try {
                                Gson gson = new Gson();
                                lic_extraAttrs = gson.fromJson(lic_extraAttrsStr, Map.class);
                                lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                                lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                                lic_id = (String)lic_extraAttrs.get("id");
                                lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                                lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                            }
                            catch (Exception gson) {}
                        }
                    } else if (lic_version == 3) {
                        lic_licenses = _in.readInt();
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_address = _in.readInt();
                        if (_in.available() != 0) {
                            lic_licensee = _in.readUTF();
                        }
                    } else {
                        String _cpus = _in.readUTF();
                        lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                        lic_datefrom = _in.readLong();
                        lic_address = _in.readInt();
                        if (lic_address == -1) {
                            lic_connections = 5;
                            lic_durationDays = 15;
                        } else {
                            lic_connections = 0;
                            lic_durationDays = 0;
                        }
                    }
                    lic_ip = (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF);
                }
                boolean iscenter = lic_center;
                if ("Virtual Edition".equals(lic_edition) || iscenter) {
                    try {
                        long _timediff;
                        block155: {
                            if (!"D".equals("I")) {
                                int respLen;
                                String[] signMethods;
                                Serializable ipList;
                                SecureRandom rand;
                                FilterOutputStream out;
                                String licVersion;
                                Object reqMsg;
                                String pathid;
                                InetAddress addr;
                                Enumeration<InetAddress> iparray;
                                NetworkInterface nw;
                                Object hwmac;
                                if (lic_durationDays > 0) {
                                    long _timediff2 = System.currentTimeMillis() - lic_datefrom;
                                    if (_timediff2 >= 0L && _timediff2 < (long)lic_durationDays * 86400L * 1000L) {
                                        lic_granted = 0;
                                    } else {
                                        lic_granted = 2130706434;
                                        Socket socket = null;
                                        FilterOutputStream out2 = null;
                                        BufferedInputStream in2 = null;
                                        SecureRandom rand2 = new SecureRandom();
                                        try {
                                            StringBuffer ipList2 = new StringBuffer();
                                            hwmac = null;
                                            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                            while (all.hasMoreElements()) {
                                                byte[] mac;
                                                nw = all.nextElement();
                                                if (nw.isLoopback() || (mac = nw.getHardwareAddress()) == null) continue;
                                                iparray = nw.getInetAddresses();
                                                while (iparray.hasMoreElements()) {
                                                    addr = iparray.nextElement();
                                                    String testaddr = addr.getHostAddress();
                                                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                    ipList2.append(testaddr);
                                                    ipList2.append(",");
                                                    if (hwmac != null) continue;
                                                    StringBuffer sb2 = new StringBuffer();
                                                    byte[] tmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                                    for (int i = 0; i < tmac.length; ++i) {
                                                        String s;
                                                        if (i != 0) {
                                                            sb2.append("-");
                                                        }
                                                        sb2.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                                    }
                                                    hwmac = sb2.toString().toUpperCase();
                                                }
                                            }
                                            if (ipList2.length() == 0) {
                                                throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                            }
                                            pathid = Utils.getServerRoot();
                                            long nonce = rand2.nextLong();
                                            String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                            int authPort = lic_port;
                                            BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                            boolean usebroker = BrokerMgrFac.useBroker();
                                            if (usebroker) {
                                                String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(ipList2.toString());
                                                String[] ipPorts = ipPort.split(":");
                                                authIP = ipPorts[0];
                                                authPort = Integer.parseInt(ipPorts[1]);
                                            }
                                            StringBuilder reqData = new StringBuilder();
                                            reqData.append("version").append("=").append("2.0").append("&");
                                            reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                            reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                            reqData.append("actionFlag").append("=").append("D").append("&");
                                            reqData.append("id").append("=").append(lic_id).append("&");
                                            reqData.append("ipList").append("=").append(ipList2.toString()).append("&");
                                            reqData.append("mac").append("=").append((String)hwmac).append("&");
                                            reqData.append("signature").append("=").append(signature).append("&");
                                            reqData.append("pathID").append("=").append(pathid).append("&");
                                            reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                            String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                            reqMsg = new StringBuilder();
                                            ((StringBuilder)reqMsg).append("POST ").append("/update").append(" HTTP/1.1\r\n");
                                            ((StringBuilder)reqMsg).append("Cache-Control: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("Pragma: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Host: ").append(authIP).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Accept: text/html\r\n");
                                            ((StringBuilder)reqMsg).append("Connection: close\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                            ((StringBuilder)reqMsg).append("\r\n");
                                            ((StringBuilder)reqMsg).append(encry_reqData);
                                            socket = new Socket(authIP, authPort);
                                            out2 = new BufferedOutputStream(socket.getOutputStream());
                                            in2 = new BufferedInputStream(socket.getInputStream());
                                            out2.write(((StringBuilder)reqMsg).toString().getBytes());
                                            ((BufferedOutputStream)out2).flush();
                                            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                            byte[] buffer = new byte[1000];
                                            int len = -1;
                                            while ((len = in2.read(buffer)) != -1) {
                                                bytesOut.write(buffer, 0, len);
                                            }
                                            byte[] response = bytesOut.toByteArray();
                                            byte[] respBuffer0 = Utils.analyseAgentResponse((byte[])response);
                                            byte[] respBuffer = CryptUtilAuthData.getDecryptByte((byte[])respBuffer0);
                                            String result = new String(respBuffer, 0, 5);
                                            if ("error".equals(result)) {
                                                System.out.println(result);
                                            } else if ("okkkk".equals(result)) {
                                                int _i3;
                                                byte[] licname0 = new byte[16];
                                                byte[] licname1 = new byte[16];
                                                long _xx2 = 7105912L;
                                                long _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname1[16 - _i3] = (byte)_xx2;
                                                    licname1[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                _xx2 = 28266723269176696L;
                                                _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname0[16 - _i3] = (byte)_xx2;
                                                    licname0[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                File file0 = Utils.getLicFile((String)new String(licname0, 0, 0, 15));
                                                File file1 = Utils.getLicFile((String)new String(licname1, 0, 0, 11));
                                                if (file0.exists()) {
                                                    file0.delete();
                                                }
                                                file1.renameTo(file0);
                                                FileOutputStream fw = new FileOutputStream(file1);
                                                fw.write(respBuffer, 5, respBuffer.length - 5);
                                                fw.close();
                                                if ("M".equals("D")) {
                                                    lic_granted = 0;
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            throw ex;
                                        }
                                        finally {
                                            if (out2 != null) {
                                                try {
                                                    out2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (in2 != null) {
                                                try {
                                                    in2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (socket != null) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                        }
                                    }
                                }
                                if ("1.0".equals(licVersion = System.getProperty(new StringBuffer("com.a").append("pusic.licen").append("se.version").toString()))) {
                                    Socket socket = null;
                                    out = null;
                                    in = null;
                                    rand = new SecureRandom();
                                    try {
                                        int loopNum;
                                        int len;
                                        ipList = new ArrayList();
                                        int ipLen = 0;
                                        hwmac = null;
                                        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                        while (all.hasMoreElements()) {
                                            byte[] mac;
                                            nw = all.nextElement();
                                            if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                                            iparray = nw.getInetAddresses();
                                            while (iparray.hasMoreElements()) {
                                                addr = iparray.nextElement();
                                                String testaddr = addr.getHostAddress();
                                                byte[] binAddr = addr.getAddress();
                                                if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                ipLen += 4;
                                                ipList.add(binAddr);
                                                if (hwmac != null) continue;
                                                hwmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                            }
                                        }
                                        if (ipList.isEmpty()) {
                                            throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                        }
                                        pathid = Utils.getServerRoot();
                                        BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                        boolean usebroker = BrokerMgrFac.useBroker();
                                        if (!usebroker) {
                                            socket = new Socket(lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip, lic_port);
                                        } else {
                                            String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(new String((byte[])ipList.get(0)));
                                            String[] ipPorts = ipPort.split(":");
                                            socket = new Socket(ipPorts[0], Integer.parseInt(ipPorts[1]));
                                        }
                                        out = new BufferedOutputStream(socket.getOutputStream());
                                        byte[] pre = new byte[]{77, 85, 88, 32, 97, 99, 115, 99, 13, 10};
                                        byte[] OKReply = new byte[]{43, 79, 75, 13, 10};
                                        int waittime = Integer.getInteger(new StringBuffer("com.a").append("pusic.licen").append("se.wait").toString(), 300);
                                        ByteBuffer buff = ByteBuffer.allocate(8);
                                        out.write(pre);
                                        out.write("1.0".getBytes());
                                        long nonce = rand.nextLong();
                                        out.write(buff.putLong(nonce).array());
                                        buff.clear();
                                        out.write(buff.putLong(System.currentTimeMillis()).array());
                                        out.write("D".getBytes());
                                        out.write(lic_id.getBytes());
                                        buff.clear();
                                        out.write(buff.putLong(lic_input.length).array());
                                        out.write(lic_input);
                                        buff.clear();
                                        out.write(buff.putLong(ipLen).array());
                                        reqMsg = ipList.iterator();
                                        while (reqMsg.hasNext()) {
                                            byte[] ipAddr = (byte[])reqMsg.next();
                                            out.write(ipAddr);
                                        }
                                        buff.clear();
                                        out.write(buff.putLong(((Object)hwmac).length).array());
                                        out.write((byte[])hwmac);
                                        buff.clear();
                                        out.write(buff.putLong(pathid.length()).array());
                                        out.write(pathid.getBytes());
                                        ((BufferedOutputStream)out).flush();
                                        signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                        String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                        Mac mac = Mac.getInstance(methodName);
                                        mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                        byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                        respLen = expectedResponse.length;
                                        byte[] response = new byte[respLen];
                                        byte[] resTmp = new byte[5];
                                        in = new BufferedInputStream(socket.getInputStream());
                                        int offset = len = ((FilterInputStream)in).read(resTmp);
                                        for (loopNum = 3; len < resTmp.length && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(resTmp, offset, resTmp.length - offset);
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (Arrays.equals(resTmp, OKReply)) {
                                            len = ((FilterInputStream)in).read(response);
                                        } else {
                                            System.arraycopy(resTmp, 0, response, 0, 5);
                                            len = ((BufferedInputStream)in).read(response, 5, respLen - 5);
                                            len += 5;
                                        }
                                        offset = len;
                                        for (loopNum = 3; len < respLen && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(response, offset, respLen - offset);
                                            len += count;
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (len == expectedResponse.length && Arrays.equals(response, expectedResponse)) {
                                            break block155;
                                        }
                                        throw new Exception(new String(response));
                                    }
                                    catch (IOException ex) {
                                        throw ex;
                                    }
                                    finally {
                                        if (out != null) {
                                            try {
                                                out.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (in != null) {
                                            try {
                                                ((BufferedInputStream)in).close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                Socket socket = null;
                                out = null;
                                in = null;
                                rand = new SecureRandom();
                                try {
                                    ipList = new StringBuffer();
                                    String hwmac2 = null;
                                    Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                    while (all.hasMoreElements()) {
                                        byte[] mac;
                                        NetworkInterface nw2 = all.nextElement();
                                        if (nw2.isLoopback() || !nw2.isUp() || (mac = nw2.getHardwareAddress()) == null) continue;
                                        Enumeration<InetAddress> iparray2 = nw2.getInetAddresses();
                                        while (iparray2.hasMoreElements()) {
                                            InetAddress addr2 = iparray2.nextElement();
                                            String testaddr = addr2.getHostAddress();
                                            if (addr2.isLoopbackAddress() || addr2.isAnyLocalAddress() || addr2.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                            ((StringBuffer)ipList).append(testaddr);
                                            ((StringBuffer)ipList).append(",");
                                            if (hwmac2 != null) continue;
                                            StringBuffer sb3 = new StringBuffer();
                                            byte[] tmac = NetworkInterface.getByInetAddress(addr2).getHardwareAddress();
                                            for (int i = 0; i < tmac.length; ++i) {
                                                String s;
                                                if (i != 0) {
                                                    sb3.append("-");
                                                }
                                                sb3.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                            }
                                            hwmac2 = sb3.toString().toUpperCase();
                                        }
                                    }
                                    if (((StringBuffer)ipList).length() == 0) {
                                        throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                    }
                                    String pathid2 = Utils.getServerRoot();
                                    long nonce = rand.nextLong();
                                    String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                    int authPort = lic_port;
                                    BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                    boolean usebroker = BrokerMgrFac.useBroker();
                                    if (usebroker) {
                                        String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(((StringBuffer)ipList).toString());
                                        String[] ipPorts = ipPort.split(":");
                                        authIP = ipPorts[0];
                                        authPort = Integer.parseInt(ipPorts[1]);
                                    }
                                    StringBuilder reqData = new StringBuilder();
                                    reqData.append("version").append("=").append("2.0").append("&");
                                    reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                    reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                    reqData.append("actionFlag").append("=").append("D").append("&");
                                    reqData.append("id").append("=").append(lic_id).append("&");
                                    reqData.append("ipList").append("=").append(((StringBuffer)ipList).toString()).append("&");
                                    reqData.append("mac").append("=").append(hwmac2).append("&");
                                    reqData.append("pathID").append("=").append(pathid2).append("&");
                                    reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                    String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                    StringBuilder reqMsg2 = new StringBuilder();
                                    reqMsg2.append("POST ").append("/").append(" HTTP/1.1\r\n");
                                    reqMsg2.append("Cache-Control: no-cache\r\n");
                                    reqMsg2.append("Pragma: no-cache\r\n");
                                    reqMsg2.append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                    reqMsg2.append("Host: ").append(authIP).append("\r\n");
                                    reqMsg2.append("Accept: text/html\r\n");
                                    reqMsg2.append("Connection: close\r\n");
                                    reqMsg2.append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                    reqMsg2.append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                    reqMsg2.append("\r\n");
                                    reqMsg2.append(encry_reqData);
                                    socket = new Socket(authIP, authPort);
                                    out = new BufferedOutputStream(socket.getOutputStream());
                                    in = new BufferedInputStream(socket.getInputStream());
                                    out.write(reqMsg2.toString().getBytes());
                                    ((BufferedOutputStream)out).flush();
                                    signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                    String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                    Mac mac = Mac.getInstance(methodName);
                                    mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                    byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                    respLen = expectedResponse.length;
                                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                    byte[] buffer = new byte[100];
                                    int len = -1;
                                    while ((len = ((FilterInputStream)in).read(buffer)) != -1) {
                                        bytesOut.write(buffer, 0, len);
                                    }
                                    byte[] respBuffer = bytesOut.toByteArray();
                                    byte[] response = Utils.analyseAgentResponse((byte[])respBuffer);
                                    if (Arrays.equals(response, expectedResponse)) {
                                        break block155;
                                    }
                                    throw new Exception(new String(response));
                                }
                                catch (IOException ex) {
                                    throw ex;
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (in != null) {
                                        try {
                                            ((BufferedInputStream)in).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (socket != null) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                        }
                        lic_granted = lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0;
                        lic_address = -1;
                    }
                    catch (Throwable _ex) {
                        lic_granted = -1;
                        System.out.println(_ex.getMessage());
                        _ex.printStackTrace();
                    }
                }
                boolean bl = isNormal = !lic_center;
                if (!isNormal || "Virtual Edition".equals(lic_edition)) break block156;
                Throwable taddr = null;
                try {
                    lic_granted = 2130706435;
                    if (lic_version >= 2) {
                        boolean ck = false;
                        if (lic_aowedIPs != null && !"".equals(lic_aowedIPs)) {
                            in = lic_aowedIPs;
                            String regEx = new StringBuffer("^").append((String)in).append("\\.").append(".*$").toString();
                            Pattern p = Pattern.compile(regEx);
                            InetAddress lh = InetAddress.getLocalHost();
                            String ip = lh.getHostAddress();
                            byte[] adds = lh.getAddress();
                            if (p.matcher(ip).matches()) {
                                ck = true;
                            } else {
                                Enumeration<NetworkInterface> netInts = NetworkInterface.getNetworkInterfaces();
                                while (netInts.hasMoreElements() && !ck) {
                                    NetworkInterface networkInterface = netInts.nextElement();
                                    Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                                    while (ips.hasMoreElements() && !ck) {
                                        lh = ips.nextElement();
                                        adds = lh.getAddress();
                                        String tip = lh.getHostAddress();
                                        if (!p.matcher(tip).matches()) continue;
                                        ck = true;
                                    }
                                }
                            }
                            if (!ck) {
                                lic_address = ((adds[0] & 0xFF) << 24) + ((adds[1] & 0xFF) << 16) + ((adds[2] & 0xFF) << 8) + ((adds[3] & 0xFF) << 0);
                                throw new Exception("error");
                            }
                        }
                        if (lic_address != -1 && !lic_addressStr.equals("255.255.255.255")) {
                            lic_ip = lic_address == 0 ? lic_addressStr : lic_ip;
                            InetAddress _addr = InetAddress.getByName(lic_ip);
                            ServerSocket _ss = new ServerSocket(0, 1, _addr);
                            _ss.close();
                        }
                    }
                    if (lic_version == 1) {
                        boolean ck = false;
                        List ips = MacMain.getLocalIPs();
                        ips.add(new StringBuffer("255").append(".255").append(".255").append(".255").toString());
                        for (String ip : ips) {
                            if (!lic_addressStr.equals(MacMain.getSoftCode((String)ip))) continue;
                            ck = true;
                            break;
                        }
                        if (!"10.1.2".startsWith(lic_prodversion)) {
                            System.out.println("v");
                            ck = false;
                        }
                        if (!ck) {
                            throw new Exception("rror");
                        }
                    }
                }
                catch (Throwable _ex) {
                    taddr = _ex;
                }
                if (taddr == null) {
                    long _timediff;
                    lic_granted = lic_version == 1 ? (lic_dateend > 0L ? (System.currentTimeMillis() >= lic_datefrom && System.currentTimeMillis() <= lic_dateend ? 0 : 2130706434) : 0) : (lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0);
                }
            }
            catch (Throwable _ex0) {
                System.out.println(_ex0.getMessage());
            }
        }
        ReportEventMgrAdapter.reportShutDown();
        this.stopInternal0();
        this.setState(LifecycleState.STOPPING);
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
            this.monitorFuture = null;
        }
        if (this.periodicLifecycleEventFuture != null) {
            this.periodicLifecycleEventFuture.cancel(false);
            this.periodicLifecycleEventFuture = null;
        }
        this.fireLifecycleEvent("configure_stop", null);
        for (Service service : this.services) {
            service.stop();
        }
        this.globalNamingResources.stop();
        this.stopAwait();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        this.getLicense();
        this.initInternal0();
        super.initInternal();
        if (Boolean.getBoolean("com.apusic.security.ssl.EnableGMTLS")) {
            this.insertGMProvider();
        }
        this.reconfigureUtilityExecutor(StandardServer.getUtilityThreadsInternal(this.utilityThreads));
        this.register(this.utilityExecutor, "type=UtilityExecutor");
        this.onameStringCache = this.register(new StringCache(), "type=StringCache");
        MBeanFactory factory = new MBeanFactory();
        factory.setContainer(this);
        this.onameMBeanFactory = this.register(factory, "type=MBeanFactory");
        this.globalNamingResources.init();
        if (this.getApusic() != null) {
            for (ClassLoader cl = this.getApusic().getParentClassLoader(); cl != null && cl != ClassLoader.getSystemClassLoader(); cl = cl.getParent()) {
                URL[] urls;
                if (!(cl instanceof URLClassLoader)) continue;
                for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                    if (!url.getProtocol().equals("file")) continue;
                    try {
                        File f = new File(url.toURI());
                        if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                        ExtensionValidator.addSystemResource(f);
                    }
                    catch (IOException | URISyntaxException exception) {
                        // empty catch block
                    }
                }
            }
        }
        for (Service service : this.services) {
            service.init();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        for (Service service : this.services) {
            service.destroy();
        }
        this.globalNamingResources.destroy();
        this.unregister(this.onameMBeanFactory);
        this.unregister(this.onameStringCache);
        if (this.utilityExecutor != null) {
            this.utilityExecutor.shutdownNow();
            this.unregister("type=UtilityExecutor");
            this.utilityExecutor = null;
        }
        super.destroyInternal();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.apusic != null) {
            return this.apusic.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        Service service;
        String domain = null;
        Service[] services = this.findServices();
        if (services.length > 0 && (service = services[0]) != null) {
            domain = service.getDomain();
        }
        return domain;
    }

    @Override
    protected final String getObjectNameKeyProperties() {
        return "type=Server";
    }

    @Override
    public ScheduledExecutorService getUtilityExecutor() {
        return this.utilityExecutorWrapper;
    }

    private void insertGMProvider() throws LifecycleException {
        block2: {
            Object provider = null;
            try {
                provider = Class.forName("com.apusic.org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                Security.insertProviderAt(provider, 1);
                provider = Class.forName("com.apusic.org.bouncycastle.jsse.provider.BouncyCastleJsseProvider").newInstance();
                Security.insertProviderAt(provider, 2);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error(e);
                throw new LifecycleException(e);
            }
        }
    }

    private void stopInternal0() {
        this.licenseExecutor.shutdown();
    }

    private void getLicense() {
        boolean getnew = false;
        if (!ReportEventMgrAdapter.hasServer()) {
            return;
        }
        int lic_version = 0;
        String lic_sn = null;
        String lic_cdkey = null;
        String lic_prodname = null;
        String lic_edition = null;
        String lic_editionAlias = null;
        String lic_prodversion = null;
        String lic_licensee = null;
        String lic_addressStr = "";
        String lic_authAddStr = "";
        String lic_authBy = "";
        String lic_aowedIPs = "";
        boolean lic_center = false;
        int lic_address = 0;
        int lic_connections = 0;
        long lic_datefrom = 0L;
        long lic_dateend = 0L;
        int lic_durationDays = 0;
        int lic_licenses = 0;
        Map lic_extraAttrs = null;
        String lic_ip = null;
        int lic_port = -1;
        String lic_id = "0000000000";
        String signature = null;
        byte[] lic_input = null;
        File lic_file = null;
        InputStream lic_is = null;
        int lic_granted = 2130706433;
        try {
            int _i;
            byte[] lic_name = new byte[16];
            byte[] share_lic_name = new byte[16];
            byte[] share_lic_dir = new byte[16];
            long _xx = 7105912L;
            long _yy = 3343205216377071980L;
            for (_i = 8; _i > 0; --_i) {
                lic_name[16 - _i] = (byte)_xx;
                lic_name[8 - _i] = (byte)_yy;
                _xx >>= 8;
                _yy >>= 8;
            }
            _xx = 0L;
            _yy = 29401359424121196L;
            for (_i = 8; _i > 0; --_i) {
                share_lic_name[16 - _i] = (byte)_xx;
                share_lic_name[8 - _i] = (byte)_yy;
                _xx >>= 8;
                _yy >>= 8;
            }
            _xx = 0x303030L;
            _yy = 3487320404452927852L;
            for (_i = 8; _i > 0; --_i) {
                share_lic_dir[16 - _i] = (byte)_xx;
                share_lic_dir[8 - _i] = (byte)_yy;
                _xx >>= 8;
                _yy >>= 8;
            }
            String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
            if (keypath != null && !keypath.equals("") && !(lic_file = new File(keypath)).exists()) {
                lic_file = Utils.getLicFile((String)keypath);
            }
            if (lic_file == null || !lic_file.exists()) {
                lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
            }
            if (lic_file == null || !lic_file.exists()) {
                lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
            }
            lic_is = lic_file.exists() ? new FileInputStream(lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
            String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
            StringBuffer sb = new StringBuffer();
            boolean isnew = false;
            BufferedReader ps = null;
            ps = new BufferedReader(new InputStreamReader(lic_is, fileCharset));
            ps.mark(1024);
            String line = ps.readLine();
            if (line.trim().startsWith("{")) {
                isnew = true;
            }
            if (isnew) {
                while (line != null) {
                    sb.append(line);
                    line = ps.readLine();
                }
                Gson gson = new Gson();
                Map map0 = gson.fromJson(sb.toString(), Map.class);
                String sign = (String)map0.get("sign");
                String data = (String)map0.get("license");
                boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                if (!baomiOK) {
                    throw new Exception("m");
                }
                lic_version = 1;
                Map map = gson.fromJson(data, Map.class);
                lic_licensee = (String)map.get("code");
                lic_prodversion = (String)map.get("productVersion");
                lic_datefrom = ((Double)map.get("createDate")).longValue();
                lic_dateend = ((Double)map.get("expireDate")).longValue();
                lic_addressStr = (String)map.get("deviceId");
                Map groupMap = (Map)((List)map.get("groups")).get(0);
                String connstr = (String)groupMap.get("count");
                lic_connections = Integer.parseInt(connstr);
                Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                lic_licenses = ((Double)moduleMap.get("count")).intValue();
                String extStr = (String)map.get("extraData");
                Map extMap = gson.fromJson(extStr, Map.class);
                lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                lic_edition = (String)lic_extraAttrs.get("specification");
                lic_prodname = (String)lic_extraAttrs.get("productEnName");
                lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                lic_id = (String)lic_extraAttrs.get("id");
                lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
            }
            if (!isnew) {
                int _keySize;
                ps.reset();
                InputSource is = new InputSource(ps);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document doc = builder.parse(is);
                Element root = doc.getDocumentElement();
                signature = root.getAttribute("signature");
                Class<?> base64Class = null;
                try {
                    base64Class = Class.forName("com.apusic.util.Base64");
                }
                catch (Throwable t) {
                    base64Class = Class.forName("com.apusic.license.util.Base64");
                }
                Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{signature.getBytes("UTF-8")});
                byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                byte[] _nbytes = new byte[_nlen];
                byte[] _ebytes = new byte[_elen];
                System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                BigInteger _n = new BigInteger(1, _nbytes);
                BigInteger _e = new BigInteger(1, _ebytes);
                int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                int _outputBlockSize = _keySize - 1;
                int _outSize = (lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                byte[] _output = new byte[_outSize];
                int _inputOffset = 0;
                int _outputOffset = 0;
                while (_inputOffset < lic_input.length) {
                    byte[] _block = new byte[_inputBlockSize];
                    int _remainder = lic_input.length - _inputOffset;
                    if (_remainder > _inputBlockSize) {
                        System.arraycopy(lic_input, _inputOffset, _block, 0, _inputBlockSize);
                    } else {
                        System.arraycopy(lic_input, _inputOffset, _block, 0, _remainder);
                    }
                    BigInteger _x = new BigInteger(1, _block);
                    BigInteger _y = _x.modPow(_e, _n);
                    _block = _y.toByteArray();
                    if (_block.length <= _outputBlockSize) {
                        System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                    } else {
                        System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                    }
                    _inputOffset += _inputBlockSize;
                    _outputOffset += _outputBlockSize;
                }
                int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                byte[] lic_data = new byte[lic_len];
                for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                    lic_data[_i2] = _output[lic_off];
                    lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                }
                ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                DataInputStream _in = new DataInputStream(_bis);
                lic_version = _in.readShort();
                lic_sn = _in.readUTF();
                lic_cdkey = _in.readUTF();
                lic_prodname = _in.readUTF();
                if (lic_version >= 4) {
                    String lic_extraAttrsStr;
                    lic_edition = _in.readUTF();
                    lic_editionAlias = _in.readUTF();
                    lic_prodversion = _in.readUTF();
                    lic_licensee = _in.readUTF();
                    if (lic_version == 32 || lic_version > 49) {
                        lic_addressStr = _in.readUTF();
                    } else {
                        lic_address = _in.readInt();
                    }
                    lic_connections = _in.readInt();
                    lic_datefrom = _in.readLong();
                    lic_durationDays = _in.readInt();
                    lic_licenses = _in.readInt();
                    if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                        try {
                            Gson gson = new Gson();
                            lic_extraAttrs = gson.fromJson(lic_extraAttrsStr, Map.class);
                            lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                            lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                            lic_id = (String)lic_extraAttrs.get("id");
                            lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                            lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                        }
                        catch (Exception exception) {}
                    }
                } else if (lic_version == 3) {
                    lic_licenses = _in.readInt();
                    lic_connections = _in.readInt();
                    lic_datefrom = _in.readLong();
                    lic_durationDays = _in.readInt();
                    lic_address = _in.readInt();
                    if (_in.available() != 0) {
                        lic_licensee = _in.readUTF();
                    }
                } else {
                    String _cpus = _in.readUTF();
                    lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                    lic_datefrom = _in.readLong();
                    lic_address = _in.readInt();
                    if (lic_address == -1) {
                        lic_connections = 5;
                        lic_durationDays = 15;
                    } else {
                        lic_connections = 0;
                        lic_durationDays = 0;
                    }
                }
                lic_ip = (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF);
            }
            if (lic_durationDays > 0 && (long)lic_durationDays * 86400L * 1000L + lic_datefrom < System.currentTimeMillis()) {
                getnew = true;
            }
        }
        catch (Exception ex) {
            getnew = true;
        }
        ReportEventMgrAdapter.getLicense(getnew, String.valueOf(lic_version), lic_edition, lic_file);
    }

    private void initInternal0() {
        SimpleDateFormat fmt;
        Date dueDate;
        Date startDate;
        int lic_granted;
        int lic_licenses;
        int lic_durationDays;
        long lic_dateend;
        long lic_datefrom;
        int lic_connections;
        int lic_address;
        String lic_addressStr;
        String lic_licensee;
        String lic_prodversion;
        String lic_edition;
        String lic_prodname;
        int lic_version;
        block161: {
            lic_version = 0;
            String lic_sn = null;
            String lic_cdkey = null;
            lic_prodname = null;
            lic_edition = null;
            String lic_editionAlias = null;
            lic_prodversion = null;
            lic_licensee = null;
            lic_addressStr = "";
            String lic_authAddStr = "";
            String lic_authBy = "";
            String lic_aowedIPs = "";
            boolean lic_center = false;
            lic_address = 0;
            lic_connections = 0;
            lic_datefrom = 0L;
            lic_dateend = 0L;
            lic_durationDays = 0;
            lic_licenses = 0;
            Map lic_extraAttrs = null;
            String lic_ip = null;
            int lic_port = -1;
            String lic_id = "0000000000";
            String signature = null;
            byte[] lic_input = null;
            File lic_file = null;
            InputStream lic_is = null;
            lic_granted = 2130706433;
            try {
                boolean isNormal;
                Object in;
                int _i;
                String verfile = new StringBuffer("com/apusic/").append("web/WebSe").append("rviceUtil.cl").append("ass").toString();
                byte[] lic_name = new byte[16];
                byte[] share_lic_name = new byte[16];
                byte[] share_lic_dir = new byte[16];
                long _xx = 7105912L;
                long _yy = 3343205216377071980L;
                for (_i = 8; _i > 0; --_i) {
                    lic_name[16 - _i] = (byte)_xx;
                    lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0L;
                _yy = 29401359424121196L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_name[16 - _i] = (byte)_xx;
                    share_lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0x303030L;
                _yy = 3487320404452927852L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_dir[16 - _i] = (byte)_xx;
                    share_lic_dir[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
                if (keypath != null && !keypath.equals("") && !(lic_file = new File(keypath)).exists()) {
                    lic_file = Utils.getLicFile((String)keypath);
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
                }
                lic_is = lic_file.exists() ? new FileInputStream(lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
                String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
                StringBuffer sb = new StringBuffer();
                boolean isnew = false;
                BufferedReader ps = null;
                ps = new BufferedReader(new InputStreamReader(lic_is, fileCharset));
                ps.mark(1024);
                String line = ps.readLine();
                if (line.trim().startsWith("{")) {
                    isnew = true;
                }
                if (isnew) {
                    while (line != null) {
                        sb.append(line);
                        line = ps.readLine();
                    }
                    Gson gson = new Gson();
                    Map map0 = gson.fromJson(sb.toString(), Map.class);
                    String sign = (String)map0.get("sign");
                    String data = (String)map0.get("license");
                    boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                    if (!baomiOK) {
                        throw new Exception("m");
                    }
                    lic_version = 1;
                    Map map = gson.fromJson(data, Map.class);
                    lic_licensee = (String)map.get("code");
                    lic_prodversion = (String)map.get("productVersion");
                    lic_datefrom = ((Double)map.get("createDate")).longValue();
                    lic_dateend = ((Double)map.get("expireDate")).longValue();
                    lic_addressStr = (String)map.get("deviceId");
                    Map groupMap = (Map)((List)map.get("groups")).get(0);
                    String connstr = (String)groupMap.get("count");
                    lic_connections = Integer.parseInt(connstr);
                    Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                    lic_licenses = ((Double)moduleMap.get("count")).intValue();
                    String extStr = (String)map.get("extraData");
                    Map extMap = gson.fromJson(extStr, Map.class);
                    lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                    lic_edition = (String)lic_extraAttrs.get("specification");
                    lic_prodname = (String)lic_extraAttrs.get("productEnName");
                    lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                    lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                    lic_id = (String)lic_extraAttrs.get("id");
                    lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                    lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                }
                if (!isnew) {
                    int _keySize;
                    ps.reset();
                    InputSource is = new InputSource(ps);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element root = doc.getDocumentElement();
                    signature = root.getAttribute("signature");
                    Class<?> base64Class = null;
                    try {
                        base64Class = Class.forName("com.apusic.util.Base64");
                    }
                    catch (Throwable t) {
                        base64Class = Class.forName("com.apusic.license.util.Base64");
                    }
                    Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                    lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{signature.getBytes("UTF-8")});
                    byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                    int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                    int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                    byte[] _nbytes = new byte[_nlen];
                    byte[] _ebytes = new byte[_elen];
                    System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                    System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                    BigInteger _n = new BigInteger(1, _nbytes);
                    BigInteger _e = new BigInteger(1, _ebytes);
                    int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                    int _outputBlockSize = _keySize - 1;
                    int _outSize = (lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                    byte[] _output = new byte[_outSize];
                    int _inputOffset = 0;
                    int _outputOffset = 0;
                    while (_inputOffset < lic_input.length) {
                        byte[] _block = new byte[_inputBlockSize];
                        int _remainder = lic_input.length - _inputOffset;
                        if (_remainder > _inputBlockSize) {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _inputBlockSize);
                        } else {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _remainder);
                        }
                        BigInteger _x = new BigInteger(1, _block);
                        BigInteger _y = _x.modPow(_e, _n);
                        _block = _y.toByteArray();
                        if (_block.length <= _outputBlockSize) {
                            System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                        } else {
                            System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                        }
                        _inputOffset += _inputBlockSize;
                        _outputOffset += _outputBlockSize;
                    }
                    int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                    int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                    byte[] lic_data = new byte[lic_len];
                    for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                        lic_data[_i2] = _output[lic_off];
                        lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                    }
                    ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                    DataInputStream _in = new DataInputStream(_bis);
                    lic_version = _in.readShort();
                    lic_sn = _in.readUTF();
                    lic_cdkey = _in.readUTF();
                    lic_prodname = _in.readUTF();
                    if (lic_version >= 4) {
                        String lic_extraAttrsStr;
                        lic_edition = _in.readUTF();
                        lic_editionAlias = _in.readUTF();
                        lic_prodversion = _in.readUTF();
                        lic_licensee = _in.readUTF();
                        if (lic_version == 32 || lic_version > 49) {
                            lic_addressStr = _in.readUTF();
                        } else {
                            lic_address = _in.readInt();
                        }
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_licenses = _in.readInt();
                        if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                            try {
                                Gson gson = new Gson();
                                lic_extraAttrs = gson.fromJson(lic_extraAttrsStr, Map.class);
                                lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                                lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                                lic_id = (String)lic_extraAttrs.get("id");
                                lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                                lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                            }
                            catch (Exception gson) {}
                        }
                    } else if (lic_version == 3) {
                        lic_licenses = _in.readInt();
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_address = _in.readInt();
                        if (_in.available() != 0) {
                            lic_licensee = _in.readUTF();
                        }
                    } else {
                        String _cpus = _in.readUTF();
                        lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                        lic_datefrom = _in.readLong();
                        lic_address = _in.readInt();
                        if (lic_address == -1) {
                            lic_connections = 5;
                            lic_durationDays = 15;
                        } else {
                            lic_connections = 0;
                            lic_durationDays = 0;
                        }
                    }
                    lic_ip = (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF);
                }
                boolean iscenter = lic_center;
                if ("Virtual Edition".equals(lic_edition) || iscenter) {
                    try {
                        long _timediff;
                        block160: {
                            if (!"S".equals("I")) {
                                int respLen;
                                String[] signMethods;
                                Serializable ipList;
                                SecureRandom rand;
                                FilterOutputStream out;
                                String licVersion;
                                Object reqMsg;
                                String pathid;
                                InetAddress addr;
                                Enumeration<InetAddress> iparray;
                                NetworkInterface nw;
                                Object hwmac;
                                if (lic_durationDays > 0) {
                                    long _timediff2 = System.currentTimeMillis() - lic_datefrom;
                                    if (_timediff2 >= 0L && _timediff2 < (long)lic_durationDays * 86400L * 1000L) {
                                        lic_granted = 0;
                                    } else {
                                        lic_granted = 2130706434;
                                        Socket socket = null;
                                        FilterOutputStream out2 = null;
                                        BufferedInputStream in2 = null;
                                        SecureRandom rand2 = new SecureRandom();
                                        try {
                                            StringBuffer ipList2 = new StringBuffer();
                                            hwmac = null;
                                            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                            while (all.hasMoreElements()) {
                                                byte[] mac;
                                                nw = all.nextElement();
                                                if (nw.isLoopback() || (mac = nw.getHardwareAddress()) == null) continue;
                                                iparray = nw.getInetAddresses();
                                                while (iparray.hasMoreElements()) {
                                                    addr = iparray.nextElement();
                                                    String testaddr = addr.getHostAddress();
                                                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                    ipList2.append(testaddr);
                                                    ipList2.append(",");
                                                    if (hwmac != null) continue;
                                                    StringBuffer sb2 = new StringBuffer();
                                                    byte[] tmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                                    for (int i = 0; i < tmac.length; ++i) {
                                                        String s;
                                                        if (i != 0) {
                                                            sb2.append("-");
                                                        }
                                                        sb2.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                                    }
                                                    hwmac = sb2.toString().toUpperCase();
                                                }
                                            }
                                            if (ipList2.length() == 0) {
                                                throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                            }
                                            pathid = Utils.getServerRoot();
                                            long nonce = rand2.nextLong();
                                            String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                            int authPort = lic_port;
                                            BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                            boolean usebroker = BrokerMgrFac.useBroker();
                                            if (usebroker) {
                                                String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(ipList2.toString());
                                                String[] ipPorts = ipPort.split(":");
                                                authIP = ipPorts[0];
                                                authPort = Integer.parseInt(ipPorts[1]);
                                            }
                                            StringBuilder reqData = new StringBuilder();
                                            reqData.append("version").append("=").append("2.0").append("&");
                                            reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                            reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                            reqData.append("actionFlag").append("=").append("S").append("&");
                                            reqData.append("id").append("=").append(lic_id).append("&");
                                            reqData.append("ipList").append("=").append(ipList2.toString()).append("&");
                                            reqData.append("mac").append("=").append((String)hwmac).append("&");
                                            reqData.append("signature").append("=").append(signature).append("&");
                                            reqData.append("pathID").append("=").append(pathid).append("&");
                                            reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                            String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                            reqMsg = new StringBuilder();
                                            ((StringBuilder)reqMsg).append("POST ").append("/update").append(" HTTP/1.1\r\n");
                                            ((StringBuilder)reqMsg).append("Cache-Control: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("Pragma: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Host: ").append(authIP).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Accept: text/html\r\n");
                                            ((StringBuilder)reqMsg).append("Connection: close\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                            ((StringBuilder)reqMsg).append("\r\n");
                                            ((StringBuilder)reqMsg).append(encry_reqData);
                                            socket = new Socket(authIP, authPort);
                                            out2 = new BufferedOutputStream(socket.getOutputStream());
                                            in2 = new BufferedInputStream(socket.getInputStream());
                                            out2.write(((StringBuilder)reqMsg).toString().getBytes());
                                            ((BufferedOutputStream)out2).flush();
                                            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                            byte[] buffer = new byte[1000];
                                            int len = -1;
                                            while ((len = in2.read(buffer)) != -1) {
                                                bytesOut.write(buffer, 0, len);
                                            }
                                            byte[] response = bytesOut.toByteArray();
                                            byte[] respBuffer0 = Utils.analyseAgentResponse((byte[])response);
                                            byte[] respBuffer = CryptUtilAuthData.getDecryptByte((byte[])respBuffer0);
                                            String result = new String(respBuffer, 0, 5);
                                            if ("error".equals(result)) {
                                                System.out.println(result);
                                            } else if ("okkkk".equals(result)) {
                                                int _i3;
                                                byte[] licname0 = new byte[16];
                                                byte[] licname1 = new byte[16];
                                                long _xx2 = 7105912L;
                                                long _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname1[16 - _i3] = (byte)_xx2;
                                                    licname1[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                _xx2 = 28266723269176696L;
                                                _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname0[16 - _i3] = (byte)_xx2;
                                                    licname0[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                File file0 = Utils.getLicFile((String)new String(licname0, 0, 0, 15));
                                                File file1 = Utils.getLicFile((String)new String(licname1, 0, 0, 11));
                                                if (file0.exists()) {
                                                    file0.delete();
                                                }
                                                file1.renameTo(file0);
                                                FileOutputStream fw = new FileOutputStream(file1);
                                                fw.write(respBuffer, 5, respBuffer.length - 5);
                                                fw.close();
                                                if ("M".equals("S")) {
                                                    lic_granted = 0;
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            throw ex;
                                        }
                                        finally {
                                            if (out2 != null) {
                                                try {
                                                    out2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (in2 != null) {
                                                try {
                                                    in2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (socket != null) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                        }
                                    }
                                }
                                if ("1.0".equals(licVersion = System.getProperty(new StringBuffer("com.a").append("pusic.licen").append("se.version").toString()))) {
                                    Socket socket = null;
                                    out = null;
                                    in = null;
                                    rand = new SecureRandom();
                                    try {
                                        int loopNum;
                                        int len;
                                        ipList = new ArrayList();
                                        int ipLen = 0;
                                        hwmac = null;
                                        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                        while (all.hasMoreElements()) {
                                            byte[] mac;
                                            nw = all.nextElement();
                                            if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                                            iparray = nw.getInetAddresses();
                                            while (iparray.hasMoreElements()) {
                                                addr = iparray.nextElement();
                                                String testaddr = addr.getHostAddress();
                                                byte[] binAddr = addr.getAddress();
                                                if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                ipLen += 4;
                                                ipList.add(binAddr);
                                                if (hwmac != null) continue;
                                                hwmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                            }
                                        }
                                        if (ipList.isEmpty()) {
                                            throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                        }
                                        pathid = Utils.getServerRoot();
                                        BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                        boolean usebroker = BrokerMgrFac.useBroker();
                                        if (!usebroker) {
                                            socket = new Socket(lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip, lic_port);
                                        } else {
                                            String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(new String((byte[])ipList.get(0)));
                                            String[] ipPorts = ipPort.split(":");
                                            socket = new Socket(ipPorts[0], Integer.parseInt(ipPorts[1]));
                                        }
                                        out = new BufferedOutputStream(socket.getOutputStream());
                                        byte[] pre = new byte[]{77, 85, 88, 32, 97, 99, 115, 99, 13, 10};
                                        byte[] OKReply = new byte[]{43, 79, 75, 13, 10};
                                        int waittime = Integer.getInteger(new StringBuffer("com.a").append("pusic.licen").append("se.wait").toString(), 300);
                                        ByteBuffer buff = ByteBuffer.allocate(8);
                                        out.write(pre);
                                        out.write("1.0".getBytes());
                                        long nonce = rand.nextLong();
                                        out.write(buff.putLong(nonce).array());
                                        buff.clear();
                                        out.write(buff.putLong(System.currentTimeMillis()).array());
                                        out.write("S".getBytes());
                                        out.write(lic_id.getBytes());
                                        buff.clear();
                                        out.write(buff.putLong(lic_input.length).array());
                                        out.write(lic_input);
                                        buff.clear();
                                        out.write(buff.putLong(ipLen).array());
                                        reqMsg = ipList.iterator();
                                        while (reqMsg.hasNext()) {
                                            byte[] ipAddr = (byte[])reqMsg.next();
                                            out.write(ipAddr);
                                        }
                                        buff.clear();
                                        out.write(buff.putLong(((Object)hwmac).length).array());
                                        out.write((byte[])hwmac);
                                        buff.clear();
                                        out.write(buff.putLong(pathid.length()).array());
                                        out.write(pathid.getBytes());
                                        ((BufferedOutputStream)out).flush();
                                        signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                        String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                        Mac mac = Mac.getInstance(methodName);
                                        mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                        byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                        respLen = expectedResponse.length;
                                        byte[] response = new byte[respLen];
                                        byte[] resTmp = new byte[5];
                                        in = new BufferedInputStream(socket.getInputStream());
                                        int offset = len = ((FilterInputStream)in).read(resTmp);
                                        for (loopNum = 3; len < resTmp.length && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(resTmp, offset, resTmp.length - offset);
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (Arrays.equals(resTmp, OKReply)) {
                                            len = ((FilterInputStream)in).read(response);
                                        } else {
                                            System.arraycopy(resTmp, 0, response, 0, 5);
                                            len = ((BufferedInputStream)in).read(response, 5, respLen - 5);
                                            len += 5;
                                        }
                                        offset = len;
                                        for (loopNum = 3; len < respLen && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(response, offset, respLen - offset);
                                            len += count;
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (len == expectedResponse.length && Arrays.equals(response, expectedResponse)) {
                                            break block160;
                                        }
                                        throw new Exception(new String(response));
                                    }
                                    catch (IOException ex) {
                                        throw ex;
                                    }
                                    finally {
                                        if (out != null) {
                                            try {
                                                out.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (in != null) {
                                            try {
                                                ((BufferedInputStream)in).close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                Socket socket = null;
                                out = null;
                                in = null;
                                rand = new SecureRandom();
                                try {
                                    ipList = new StringBuffer();
                                    String hwmac2 = null;
                                    Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                    while (all.hasMoreElements()) {
                                        byte[] mac;
                                        NetworkInterface nw2 = all.nextElement();
                                        if (nw2.isLoopback() || !nw2.isUp() || (mac = nw2.getHardwareAddress()) == null) continue;
                                        Enumeration<InetAddress> iparray2 = nw2.getInetAddresses();
                                        while (iparray2.hasMoreElements()) {
                                            InetAddress addr2 = iparray2.nextElement();
                                            String testaddr = addr2.getHostAddress();
                                            if (addr2.isLoopbackAddress() || addr2.isAnyLocalAddress() || addr2.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                            ((StringBuffer)ipList).append(testaddr);
                                            ((StringBuffer)ipList).append(",");
                                            if (hwmac2 != null) continue;
                                            StringBuffer sb3 = new StringBuffer();
                                            byte[] tmac = NetworkInterface.getByInetAddress(addr2).getHardwareAddress();
                                            for (int i = 0; i < tmac.length; ++i) {
                                                String s;
                                                if (i != 0) {
                                                    sb3.append("-");
                                                }
                                                sb3.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                            }
                                            hwmac2 = sb3.toString().toUpperCase();
                                        }
                                    }
                                    if (((StringBuffer)ipList).length() == 0) {
                                        throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                    }
                                    String pathid2 = Utils.getServerRoot();
                                    long nonce = rand.nextLong();
                                    String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                    int authPort = lic_port;
                                    BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                    boolean usebroker = BrokerMgrFac.useBroker();
                                    if (usebroker) {
                                        String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(((StringBuffer)ipList).toString());
                                        String[] ipPorts = ipPort.split(":");
                                        authIP = ipPorts[0];
                                        authPort = Integer.parseInt(ipPorts[1]);
                                    }
                                    StringBuilder reqData = new StringBuilder();
                                    reqData.append("version").append("=").append("2.0").append("&");
                                    reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                    reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                    reqData.append("actionFlag").append("=").append("S").append("&");
                                    reqData.append("id").append("=").append(lic_id).append("&");
                                    reqData.append("ipList").append("=").append(((StringBuffer)ipList).toString()).append("&");
                                    reqData.append("mac").append("=").append(hwmac2).append("&");
                                    reqData.append("pathID").append("=").append(pathid2).append("&");
                                    reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                    String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                    StringBuilder reqMsg2 = new StringBuilder();
                                    reqMsg2.append("POST ").append("/").append(" HTTP/1.1\r\n");
                                    reqMsg2.append("Cache-Control: no-cache\r\n");
                                    reqMsg2.append("Pragma: no-cache\r\n");
                                    reqMsg2.append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                    reqMsg2.append("Host: ").append(authIP).append("\r\n");
                                    reqMsg2.append("Accept: text/html\r\n");
                                    reqMsg2.append("Connection: close\r\n");
                                    reqMsg2.append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                    reqMsg2.append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                    reqMsg2.append("\r\n");
                                    reqMsg2.append(encry_reqData);
                                    socket = new Socket(authIP, authPort);
                                    out = new BufferedOutputStream(socket.getOutputStream());
                                    in = new BufferedInputStream(socket.getInputStream());
                                    out.write(reqMsg2.toString().getBytes());
                                    ((BufferedOutputStream)out).flush();
                                    signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                    String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                    Mac mac = Mac.getInstance(methodName);
                                    mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                    byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                    respLen = expectedResponse.length;
                                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                    byte[] buffer = new byte[100];
                                    int len = -1;
                                    while ((len = ((FilterInputStream)in).read(buffer)) != -1) {
                                        bytesOut.write(buffer, 0, len);
                                    }
                                    byte[] respBuffer = bytesOut.toByteArray();
                                    byte[] response = Utils.analyseAgentResponse((byte[])respBuffer);
                                    if (Arrays.equals(response, expectedResponse)) {
                                        break block160;
                                    }
                                    throw new Exception(new String(response));
                                }
                                catch (IOException ex) {
                                    throw ex;
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (in != null) {
                                        try {
                                            ((BufferedInputStream)in).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (socket != null) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                        }
                        lic_granted = lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0;
                        lic_address = -1;
                    }
                    catch (Throwable _ex) {
                        lic_granted = -1;
                        System.out.println(_ex.getMessage());
                        _ex.printStackTrace();
                    }
                }
                boolean bl = isNormal = !lic_center;
                if (!isNormal || "Virtual Edition".equals(lic_edition)) break block161;
                Throwable taddr = null;
                try {
                    lic_granted = 2130706435;
                    if (lic_version >= 2) {
                        boolean ck = false;
                        if (lic_aowedIPs != null && !"".equals(lic_aowedIPs)) {
                            in = lic_aowedIPs;
                            String regEx = new StringBuffer("^").append((String)in).append("\\.").append(".*$").toString();
                            Pattern p = Pattern.compile(regEx);
                            InetAddress lh = InetAddress.getLocalHost();
                            String ip = lh.getHostAddress();
                            byte[] adds = lh.getAddress();
                            if (p.matcher(ip).matches()) {
                                ck = true;
                            } else {
                                Enumeration<NetworkInterface> netInts = NetworkInterface.getNetworkInterfaces();
                                while (netInts.hasMoreElements() && !ck) {
                                    NetworkInterface networkInterface = netInts.nextElement();
                                    Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                                    while (ips.hasMoreElements() && !ck) {
                                        lh = ips.nextElement();
                                        adds = lh.getAddress();
                                        String tip = lh.getHostAddress();
                                        if (!p.matcher(tip).matches()) continue;
                                        ck = true;
                                    }
                                }
                            }
                            if (!ck) {
                                lic_address = ((adds[0] & 0xFF) << 24) + ((adds[1] & 0xFF) << 16) + ((adds[2] & 0xFF) << 8) + ((adds[3] & 0xFF) << 0);
                                throw new Exception("error");
                            }
                        }
                        if (lic_address != -1 && !lic_addressStr.equals("255.255.255.255")) {
                            lic_ip = lic_address == 0 ? lic_addressStr : lic_ip;
                            InetAddress _addr = InetAddress.getByName(lic_ip);
                            ServerSocket _ss = new ServerSocket(0, 1, _addr);
                            _ss.close();
                        }
                    }
                    if (lic_version == 1) {
                        boolean ck = false;
                        List ips = MacMain.getLocalIPs();
                        ips.add(new StringBuffer("255").append(".255").append(".255").append(".255").toString());
                        for (String ip : ips) {
                            if (!lic_addressStr.equals(MacMain.getSoftCode((String)ip))) continue;
                            ck = true;
                            break;
                        }
                        if (!"10.1.2".startsWith(lic_prodversion)) {
                            System.out.println("v");
                            ck = false;
                        }
                        if (!ck) {
                            throw new Exception("rror");
                        }
                    }
                }
                catch (Throwable _ex) {
                    taddr = _ex;
                }
                if (taddr == null) {
                    long _timediff;
                    lic_granted = lic_version == 1 ? (lic_dateend > 0L ? (System.currentTimeMillis() >= lic_datefrom && System.currentTimeMillis() <= lic_dateend ? 0 : 2130706434) : 0) : (lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0);
                }
            }
            catch (Throwable _ex0) {
                System.out.println(_ex0.getMessage());
            }
        }
        System.setProperty("Connections", CryptUtil.getEncryptString((String)String.valueOf(lic_connections)));
        if (lic_granted == 2130706435) {
            System.err.println(new StringBuffer("lice").append("nse is in").append("valid,i").append("p not gra").append("nted!").toString());
            System.exit(1);
        }
        if (lic_granted == 2130706434) {
            System.err.println(new StringBuffer("lice").append("nse is in").append("valid,o").append("ut of d").append("ate").toString());
            System.exit(1);
        }
        if (lic_version != 50 && !"Apusic Application Server".equals(lic_prodname) || lic_granted != 0) {
            System.err.println(new StringBuffer("lice").append("nse is in").append("valid.").toString());
            System.exit(1);
        }
        System.out.println(lic_prodname + " " + lic_edition + " " + lic_prodversion);
        System.out.println("Licensed to " + lic_licensee);
        if (lic_connections != 0) {
            System.out.println("Connetions limited to " + lic_connections);
        }
        if (lic_address != -1) {
            String ip;
            String string = ip = lic_addressStr.equals("") ? (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF) : lic_addressStr;
            if (!ip.startsWith("255.255.")) {
                System.out.println("granted to " + ip);
            }
        }
        if (lic_durationDays != 0) {
            startDate = new Date(lic_datefrom);
            dueDate = new Date(lic_datefrom + (long)lic_durationDays * 86400000L);
            fmt = new SimpleDateFormat("yyyy-MM-dd");
            System.out.println("Licensed from " + fmt.format(startDate) + " to " + fmt.format(dueDate));
        }
        if (lic_dateend != 0L) {
            startDate = new Date(lic_datefrom);
            dueDate = new Date(lic_dateend);
            fmt = new SimpleDateFormat("yyyy-MM-dd");
            System.out.println("Licensed from " + fmt.format(startDate) + " to " + fmt.format(dueDate));
        }
        System.out.println("CPUs limited to " + lic_licenses);
        System.out.println("");
        Version.setEdition(lic_edition);
        Version.setConnections((int)lic_connections);
        Version.setCPUs((int)lic_licenses);
        Version.setLicVersion((int)lic_version);
        Version.setLicenseEE(lic_licensee);
        Version.setDateFrom((long)lic_datefrom);
        Version.setDuration((int)lic_durationDays);
        Version.setLicProduct(lic_prodname);
        ReportEventMgrAdapter.startReport();
        String inter = System.getProperty("apusic.lic.monitor.interval", "1800");
        int interval = Integer.parseInt(inter);
        this.licenseExecutor.scheduleAtFixedRate(new MonitorTask(), 0L, interval > 3600 ? 3600L : (long)interval, TimeUnit.SECONDS);
    }

    class MonitorTask
    implements Runnable {
        private volatile int count = 0;
        int lic_version = 0;
        String lic_sn = null;
        String lic_cdkey = null;
        String lic_prodname = null;
        String lic_edition = null;
        String lic_editionAlias = null;
        String lic_prodversion = null;
        String lic_licensee = null;
        String lic_addressStr = "";
        String lic_authAddStr = "";
        String lic_authBy = "";
        String lic_aowedIPs = "";
        boolean lic_center = false;
        int lic_address = 0;
        int lic_connections = 0;
        long lic_datefrom = 0L;
        long lic_dateend = 0L;
        int lic_durationDays = 0;
        int lic_licenses = 0;
        Map<String, String> lic_extraAttrs = null;
        String lic_ip = null;
        int lic_port = -1;
        String lic_id = "0000000000";
        String signature = null;
        byte[] lic_input = null;
        File lic_file = null;
        InputStream lic_is = null;
        int lic_granted = 2130706433;

        public MonitorTask() {
            this.init();
        }

        private void init() {
            block35: {
                try {
                    int _keySize;
                    int _i;
                    String verfile = new StringBuffer("com/apusic/").append("web/WebSe").append("rviceUtil.cl").append("ass").toString();
                    byte[] lic_name = new byte[16];
                    byte[] share_lic_name = new byte[16];
                    byte[] share_lic_dir = new byte[16];
                    long _xx = 7105912L;
                    long _yy = 3343205216377071980L;
                    for (_i = 8; _i > 0; --_i) {
                        lic_name[16 - _i] = (byte)_xx;
                        lic_name[8 - _i] = (byte)_yy;
                        _xx >>= 8;
                        _yy >>= 8;
                    }
                    _xx = 0L;
                    _yy = 29401359424121196L;
                    for (_i = 8; _i > 0; --_i) {
                        share_lic_name[16 - _i] = (byte)_xx;
                        share_lic_name[8 - _i] = (byte)_yy;
                        _xx >>= 8;
                        _yy >>= 8;
                    }
                    _xx = 0x303030L;
                    _yy = 3487320404452927852L;
                    for (_i = 8; _i > 0; --_i) {
                        share_lic_dir[16 - _i] = (byte)_xx;
                        share_lic_dir[8 - _i] = (byte)_yy;
                        _xx >>= 8;
                        _yy >>= 8;
                    }
                    String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
                    if (keypath != null && !keypath.equals("")) {
                        this.lic_file = new File(keypath);
                        if (!this.lic_file.exists()) {
                            this.lic_file = Utils.getLicFile((String)keypath);
                        }
                    }
                    if (this.lic_file == null || !this.lic_file.exists()) {
                        this.lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
                    }
                    if (this.lic_file == null || !this.lic_file.exists()) {
                        this.lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
                    }
                    this.lic_is = this.lic_file.exists() ? new FileInputStream(this.lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
                    String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
                    StringBuffer sb = new StringBuffer();
                    boolean isnew = false;
                    BufferedReader ps = null;
                    ps = new BufferedReader(new InputStreamReader(this.lic_is, fileCharset));
                    ps.mark(1024);
                    String line = ps.readLine();
                    if (line.trim().startsWith("{")) {
                        isnew = true;
                    }
                    if (isnew) {
                        while (line != null) {
                            sb.append(line);
                            line = ps.readLine();
                        }
                        Gson gson = new Gson();
                        Map map0 = gson.fromJson(sb.toString(), Map.class);
                        String sign = (String)map0.get("sign");
                        String data = (String)map0.get("license");
                        boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                        if (!baomiOK) {
                            throw new Exception("m");
                        }
                        this.lic_version = 1;
                        Map map = gson.fromJson(data, Map.class);
                        this.lic_licensee = (String)map.get("code");
                        this.lic_prodversion = (String)map.get("productVersion");
                        this.lic_datefrom = ((Double)map.get("createDate")).longValue();
                        this.lic_dateend = ((Double)map.get("expireDate")).longValue();
                        this.lic_addressStr = (String)map.get("deviceId");
                        Map groupMap = (Map)((List)map.get("groups")).get(0);
                        String connstr = (String)groupMap.get("count");
                        this.lic_connections = Integer.parseInt(connstr);
                        Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                        this.lic_licenses = ((Double)moduleMap.get("count")).intValue();
                        String extStr = (String)map.get("extraData");
                        Map extMap = gson.fromJson(extStr, Map.class);
                        this.lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                        this.lic_edition = this.lic_extraAttrs.get("specification");
                        this.lic_prodname = this.lic_extraAttrs.get("productEnName");
                        this.lic_aowedIPs = this.lic_extraAttrs.get("allowedIPs");
                        this.lic_port = Integer.parseInt(this.lic_extraAttrs.get("port") == null ? "-1" : this.lic_extraAttrs.get("port"));
                        this.lic_id = this.lic_extraAttrs.get("id");
                        this.lic_authAddStr = this.lic_extraAttrs.get("authAddress");
                        this.lic_center = Boolean.parseBoolean(this.lic_extraAttrs.get("AuthByCenter"));
                    }
                    if (isnew) break block35;
                    ps.reset();
                    InputSource is = new InputSource(ps);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element root = doc.getDocumentElement();
                    this.signature = root.getAttribute("signature");
                    Class<?> base64Class = null;
                    try {
                        base64Class = Class.forName("com.apusic.util.Base64");
                    }
                    catch (Throwable t) {
                        base64Class = Class.forName("com.apusic.license.util.Base64");
                    }
                    Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                    this.lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{this.signature.getBytes("UTF-8")});
                    byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                    int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                    int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                    byte[] _nbytes = new byte[_nlen];
                    byte[] _ebytes = new byte[_elen];
                    System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                    System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                    BigInteger _n = new BigInteger(1, _nbytes);
                    BigInteger _e = new BigInteger(1, _ebytes);
                    int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                    int _outputBlockSize = _keySize - 1;
                    int _outSize = (this.lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                    byte[] _output = new byte[_outSize];
                    int _inputOffset = 0;
                    int _outputOffset = 0;
                    while (_inputOffset < this.lic_input.length) {
                        byte[] _block = new byte[_inputBlockSize];
                        int _remainder = this.lic_input.length - _inputOffset;
                        if (_remainder > _inputBlockSize) {
                            System.arraycopy(this.lic_input, _inputOffset, _block, 0, _inputBlockSize);
                        } else {
                            System.arraycopy(this.lic_input, _inputOffset, _block, 0, _remainder);
                        }
                        BigInteger _x = new BigInteger(1, _block);
                        BigInteger _y = _x.modPow(_e, _n);
                        _block = _y.toByteArray();
                        if (_block.length <= _outputBlockSize) {
                            System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                        } else {
                            System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                        }
                        _inputOffset += _inputBlockSize;
                        _outputOffset += _outputBlockSize;
                    }
                    int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                    int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                    byte[] lic_data = new byte[lic_len];
                    for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                        lic_data[_i2] = _output[lic_off];
                        lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                    }
                    ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                    DataInputStream _in = new DataInputStream(_bis);
                    this.lic_version = _in.readShort();
                    this.lic_sn = _in.readUTF();
                    this.lic_cdkey = _in.readUTF();
                    this.lic_prodname = _in.readUTF();
                    if (this.lic_version >= 4) {
                        String lic_extraAttrsStr;
                        this.lic_edition = _in.readUTF();
                        this.lic_editionAlias = _in.readUTF();
                        this.lic_prodversion = _in.readUTF();
                        this.lic_licensee = _in.readUTF();
                        if (this.lic_version == 32 || this.lic_version > 49) {
                            this.lic_addressStr = _in.readUTF();
                        } else {
                            this.lic_address = _in.readInt();
                        }
                        this.lic_connections = _in.readInt();
                        this.lic_datefrom = _in.readLong();
                        this.lic_durationDays = _in.readInt();
                        this.lic_licenses = _in.readInt();
                        if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                            try {
                                Gson gson = new Gson();
                                this.lic_extraAttrs = gson.fromJson(lic_extraAttrsStr, Map.class);
                                this.lic_aowedIPs = this.lic_extraAttrs.get("allowedIPs");
                                this.lic_port = Integer.parseInt(this.lic_extraAttrs.get("port") == null ? "-1" : this.lic_extraAttrs.get("port"));
                                this.lic_id = this.lic_extraAttrs.get("id");
                                this.lic_authAddStr = this.lic_extraAttrs.get("authAddress");
                                this.lic_center = Boolean.parseBoolean(this.lic_extraAttrs.get("AuthByCenter"));
                            }
                            catch (Exception exception) {}
                        }
                    } else if (this.lic_version == 3) {
                        this.lic_licenses = _in.readInt();
                        this.lic_connections = _in.readInt();
                        this.lic_datefrom = _in.readLong();
                        this.lic_durationDays = _in.readInt();
                        this.lic_address = _in.readInt();
                        if (_in.available() != 0) {
                            this.lic_licensee = _in.readUTF();
                        }
                    } else {
                        String _cpus = _in.readUTF();
                        this.lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                        this.lic_datefrom = _in.readLong();
                        this.lic_address = _in.readInt();
                        if (this.lic_address == -1) {
                            this.lic_connections = 5;
                            this.lic_durationDays = 15;
                        } else {
                            this.lic_connections = 0;
                            this.lic_durationDays = 0;
                        }
                    }
                    this.lic_ip = (this.lic_address >>> 24 & 0xFF) + "." + (this.lic_address >>> 16 & 0xFF) + "." + (this.lic_address >>> 8 & 0xFF) + "." + (this.lic_address >>> 0 & 0xFF);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            boolean isNormal;
            Object in;
            boolean iscenter = this.lic_center;
            if ("Virtual Edition".equals(this.lic_edition) || iscenter) {
                try {
                    long _timediff;
                    block121: {
                        if (!"M".equals("I")) {
                            int len;
                            int respLen;
                            byte[] expectedResponse;
                            Mac mac;
                            String methodName;
                            String[] signMethods;
                            Serializable ipList;
                            SecureRandom rand;
                            FilterOutputStream out;
                            Socket socket;
                            String licVersion;
                            Object reqMsg;
                            String pathid;
                            InetAddress addr;
                            Enumeration<InetAddress> iparray;
                            NetworkInterface nw;
                            Enumeration<NetworkInterface> all;
                            Object hwmac;
                            if (this.lic_durationDays > 0) {
                                long _timediff2 = System.currentTimeMillis() - this.lic_datefrom;
                                if (_timediff2 >= 0L && _timediff2 < (long)this.lic_durationDays * 86400L * 1000L) {
                                    this.lic_granted = 0;
                                } else {
                                    this.lic_granted = 2130706434;
                                    Socket socket2 = null;
                                    FilterOutputStream out2 = null;
                                    BufferedInputStream in2 = null;
                                    SecureRandom rand2 = new SecureRandom();
                                    try {
                                        StringBuffer ipList2 = new StringBuffer();
                                        hwmac = null;
                                        all = NetworkInterface.getNetworkInterfaces();
                                        while (all.hasMoreElements()) {
                                            byte[] mac2;
                                            nw = all.nextElement();
                                            if (nw.isLoopback() || (mac2 = nw.getHardwareAddress()) == null) continue;
                                            iparray = nw.getInetAddresses();
                                            while (iparray.hasMoreElements()) {
                                                addr = iparray.nextElement();
                                                String testaddr = addr.getHostAddress();
                                                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                ipList2.append(testaddr);
                                                ipList2.append(",");
                                                if (hwmac != null) continue;
                                                StringBuffer sb = new StringBuffer();
                                                byte[] tmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                                for (int i = 0; i < tmac.length; ++i) {
                                                    String s;
                                                    if (i != 0) {
                                                        sb.append("-");
                                                    }
                                                    sb.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                                }
                                                hwmac = sb.toString().toUpperCase();
                                            }
                                        }
                                        if (ipList2.length() == 0) {
                                            throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                        }
                                        pathid = Utils.getServerRoot();
                                        long nonce = rand2.nextLong();
                                        String authIP = this.lic_addressStr != null && !this.lic_addressStr.equals("") ? this.lic_addressStr : this.lic_ip;
                                        int authPort = this.lic_port;
                                        BrokerMgrFac.setExtraAtts((String)this.lic_authAddStr, this.lic_extraAttrs);
                                        boolean usebroker = BrokerMgrFac.useBroker();
                                        if (usebroker) {
                                            String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(ipList2.toString());
                                            String[] ipPorts = ipPort.split(":");
                                            authIP = ipPorts[0];
                                            authPort = Integer.parseInt(ipPorts[1]);
                                        }
                                        StringBuilder reqData = new StringBuilder();
                                        reqData.append("version").append("=").append("2.0").append("&");
                                        reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                        reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                        reqData.append("actionFlag").append("=").append("M").append("&");
                                        reqData.append("id").append("=").append(this.lic_id).append("&");
                                        reqData.append("ipList").append("=").append(ipList2.toString()).append("&");
                                        reqData.append("mac").append("=").append((String)hwmac).append("&");
                                        reqData.append("signature").append("=").append(this.signature).append("&");
                                        reqData.append("pathID").append("=").append(pathid).append("&");
                                        reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                        String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                        reqMsg = new StringBuilder();
                                        ((StringBuilder)reqMsg).append("POST ").append("/update").append(" HTTP/1.1\r\n");
                                        ((StringBuilder)reqMsg).append("Cache-Control: no-cache\r\n");
                                        ((StringBuilder)reqMsg).append("Pragma: no-cache\r\n");
                                        ((StringBuilder)reqMsg).append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                        ((StringBuilder)reqMsg).append("Host: ").append(authIP).append("\r\n");
                                        ((StringBuilder)reqMsg).append("Accept: text/html\r\n");
                                        ((StringBuilder)reqMsg).append("Connection: close\r\n");
                                        ((StringBuilder)reqMsg).append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                        ((StringBuilder)reqMsg).append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                        ((StringBuilder)reqMsg).append("\r\n");
                                        ((StringBuilder)reqMsg).append(encry_reqData);
                                        socket2 = new Socket(authIP, authPort);
                                        out2 = new BufferedOutputStream(socket2.getOutputStream());
                                        in2 = new BufferedInputStream(socket2.getInputStream());
                                        out2.write(((StringBuilder)reqMsg).toString().getBytes());
                                        ((BufferedOutputStream)out2).flush();
                                        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                        byte[] buffer = new byte[1000];
                                        int len2 = -1;
                                        while ((len2 = in2.read(buffer)) != -1) {
                                            bytesOut.write(buffer, 0, len2);
                                        }
                                        byte[] response = bytesOut.toByteArray();
                                        byte[] respBuffer0 = Utils.analyseAgentResponse((byte[])response);
                                        byte[] respBuffer = CryptUtilAuthData.getDecryptByte((byte[])respBuffer0);
                                        String result = new String(respBuffer, 0, 5);
                                        if ("error".equals(result)) {
                                            System.out.println(result);
                                        } else if ("okkkk".equals(result)) {
                                            int _i;
                                            byte[] licname0 = new byte[16];
                                            byte[] licname1 = new byte[16];
                                            long _xx = 7105912L;
                                            long _yy = 3343205216377071980L;
                                            for (_i = 8; _i > 0; --_i) {
                                                licname1[16 - _i] = (byte)_xx;
                                                licname1[8 - _i] = (byte)_yy;
                                                _xx >>= 8;
                                                _yy >>= 8;
                                            }
                                            _xx = 28266723269176696L;
                                            _yy = 3343205216377071980L;
                                            for (_i = 8; _i > 0; --_i) {
                                                licname0[16 - _i] = (byte)_xx;
                                                licname0[8 - _i] = (byte)_yy;
                                                _xx >>= 8;
                                                _yy >>= 8;
                                            }
                                            File file0 = Utils.getLicFile((String)new String(licname0, 0, 0, 15));
                                            File file1 = Utils.getLicFile((String)new String(licname1, 0, 0, 11));
                                            if (file0.exists()) {
                                                file0.delete();
                                            }
                                            file1.renameTo(file0);
                                            FileOutputStream fw = new FileOutputStream(file1);
                                            fw.write(respBuffer, 5, respBuffer.length - 5);
                                            fw.close();
                                            if ("M".equals("M")) {
                                                this.lic_granted = 0;
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        throw ex;
                                    }
                                    finally {
                                        if (out2 != null) {
                                            try {
                                                out2.close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                        if (in2 != null) {
                                            try {
                                                in2.close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                        if (socket2 != null) {
                                            try {
                                                socket2.close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                }
                            }
                            if ("1.0".equals(licVersion = System.getProperty(new StringBuffer("com.a").append("pusic.licen").append("se.version").toString()))) {
                                socket = null;
                                out = null;
                                in = null;
                                rand = new SecureRandom();
                                try {
                                    int loopNum;
                                    ipList = new ArrayList();
                                    int ipLen = 0;
                                    hwmac = null;
                                    all = NetworkInterface.getNetworkInterfaces();
                                    while (all.hasMoreElements()) {
                                        byte[] mac3;
                                        nw = all.nextElement();
                                        if (nw.isLoopback() || !nw.isUp() || (mac3 = nw.getHardwareAddress()) == null) continue;
                                        iparray = nw.getInetAddresses();
                                        while (iparray.hasMoreElements()) {
                                            addr = iparray.nextElement();
                                            String testaddr = addr.getHostAddress();
                                            byte[] binAddr = addr.getAddress();
                                            if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                            ipLen += 4;
                                            ipList.add(binAddr);
                                            if (hwmac != null) continue;
                                            hwmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                        }
                                    }
                                    if (ipList.isEmpty()) {
                                        throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                    }
                                    pathid = Utils.getServerRoot();
                                    BrokerMgrFac.setExtraAtts((String)this.lic_authAddStr, this.lic_extraAttrs);
                                    boolean usebroker = BrokerMgrFac.useBroker();
                                    if (!usebroker) {
                                        socket = new Socket(this.lic_addressStr != null && !this.lic_addressStr.equals("") ? this.lic_addressStr : this.lic_ip, this.lic_port);
                                    } else {
                                        String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(new String((byte[])ipList.get(0)));
                                        String[] ipPorts = ipPort.split(":");
                                        socket = new Socket(ipPorts[0], Integer.parseInt(ipPorts[1]));
                                    }
                                    out = new BufferedOutputStream(socket.getOutputStream());
                                    byte[] pre = new byte[]{77, 85, 88, 32, 97, 99, 115, 99, 13, 10};
                                    byte[] OKReply = new byte[]{43, 79, 75, 13, 10};
                                    int waittime = Integer.getInteger(new StringBuffer("com.a").append("pusic.licen").append("se.wait").toString(), 300);
                                    ByteBuffer buff = ByteBuffer.allocate(8);
                                    out.write(pre);
                                    out.write("1.0".getBytes());
                                    long nonce = rand.nextLong();
                                    out.write(buff.putLong(nonce).array());
                                    buff.clear();
                                    out.write(buff.putLong(System.currentTimeMillis()).array());
                                    out.write("M".getBytes());
                                    out.write(this.lic_id.getBytes());
                                    buff.clear();
                                    out.write(buff.putLong(this.lic_input.length).array());
                                    out.write(this.lic_input);
                                    buff.clear();
                                    out.write(buff.putLong(ipLen).array());
                                    reqMsg = ipList.iterator();
                                    while (reqMsg.hasNext()) {
                                        byte[] ipAddr = (byte[])reqMsg.next();
                                        out.write(ipAddr);
                                    }
                                    buff.clear();
                                    out.write(buff.putLong(((byte[])hwmac).length).array());
                                    out.write((byte[])hwmac);
                                    buff.clear();
                                    out.write(buff.putLong(pathid.length()).array());
                                    out.write(pathid.getBytes());
                                    ((BufferedOutputStream)out).flush();
                                    signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                    methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                    mac = Mac.getInstance(methodName);
                                    mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                    expectedResponse = mac.doFinal(this.lic_licensee.getBytes(Charset.forName("UTF-8")));
                                    respLen = expectedResponse.length;
                                    byte[] response = new byte[respLen];
                                    byte[] resTmp = new byte[5];
                                    in = new BufferedInputStream(socket.getInputStream());
                                    int offset = len = ((FilterInputStream)in).read(resTmp);
                                    for (loopNum = 3; len < resTmp.length && loopNum > 0; --loopNum) {
                                        int count = ((BufferedInputStream)in).read(resTmp, offset, resTmp.length - offset);
                                        offset += count;
                                        Thread.sleep(waittime);
                                    }
                                    if (Arrays.equals(resTmp, OKReply)) {
                                        len = ((FilterInputStream)in).read(response);
                                    } else {
                                        System.arraycopy(resTmp, 0, response, 0, 5);
                                        len = ((BufferedInputStream)in).read(response, 5, respLen - 5);
                                        len += 5;
                                    }
                                    offset = len;
                                    for (loopNum = 3; len < respLen && loopNum > 0; --loopNum) {
                                        int count = ((BufferedInputStream)in).read(response, offset, respLen - offset);
                                        len += count;
                                        offset += count;
                                        Thread.sleep(waittime);
                                    }
                                    if (len == expectedResponse.length && Arrays.equals(response, expectedResponse)) {
                                        break block121;
                                    }
                                    throw new Exception(new String(response));
                                }
                                catch (IOException ex) {
                                    throw ex;
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (in != null) {
                                        try {
                                            ((BufferedInputStream)in).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (socket != null) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                            socket = null;
                            out = null;
                            in = null;
                            rand = new SecureRandom();
                            try {
                                ipList = new StringBuffer();
                                String hwmac2 = null;
                                Enumeration<NetworkInterface> all2 = NetworkInterface.getNetworkInterfaces();
                                while (all2.hasMoreElements()) {
                                    byte[] mac4;
                                    NetworkInterface nw2 = all2.nextElement();
                                    if (nw2.isLoopback() || !nw2.isUp() || (mac4 = nw2.getHardwareAddress()) == null) continue;
                                    Enumeration<InetAddress> iparray2 = nw2.getInetAddresses();
                                    while (iparray2.hasMoreElements()) {
                                        InetAddress addr2 = iparray2.nextElement();
                                        String testaddr = addr2.getHostAddress();
                                        if (addr2.isLoopbackAddress() || addr2.isAnyLocalAddress() || addr2.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                        ((StringBuffer)ipList).append(testaddr);
                                        ((StringBuffer)ipList).append(",");
                                        if (hwmac2 != null) continue;
                                        StringBuffer sb = new StringBuffer();
                                        byte[] tmac = NetworkInterface.getByInetAddress(addr2).getHardwareAddress();
                                        for (int i = 0; i < tmac.length; ++i) {
                                            String s;
                                            if (i != 0) {
                                                sb.append("-");
                                            }
                                            sb.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                        }
                                        hwmac2 = sb.toString().toUpperCase();
                                    }
                                }
                                if (((StringBuffer)ipList).length() == 0) {
                                    throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                }
                                String pathid2 = Utils.getServerRoot();
                                long nonce = rand.nextLong();
                                String authIP = this.lic_addressStr != null && !this.lic_addressStr.equals("") ? this.lic_addressStr : this.lic_ip;
                                int authPort = this.lic_port;
                                BrokerMgrFac.setExtraAtts((String)this.lic_authAddStr, this.lic_extraAttrs);
                                boolean usebroker = BrokerMgrFac.useBroker();
                                if (usebroker) {
                                    String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(((StringBuffer)ipList).toString());
                                    String[] ipPorts = ipPort.split(":");
                                    authIP = ipPorts[0];
                                    authPort = Integer.parseInt(ipPorts[1]);
                                }
                                StringBuilder reqData = new StringBuilder();
                                reqData.append("version").append("=").append("2.0").append("&");
                                reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                reqData.append("actionFlag").append("=").append("M").append("&");
                                reqData.append("id").append("=").append(this.lic_id).append("&");
                                reqData.append("ipList").append("=").append(((StringBuffer)ipList).toString()).append("&");
                                reqData.append("mac").append("=").append(hwmac2).append("&");
                                reqData.append("pathID").append("=").append(pathid2).append("&");
                                reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                StringBuilder reqMsg2 = new StringBuilder();
                                reqMsg2.append("POST ").append("/").append(" HTTP/1.1\r\n");
                                reqMsg2.append("Cache-Control: no-cache\r\n");
                                reqMsg2.append("Pragma: no-cache\r\n");
                                reqMsg2.append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                reqMsg2.append("Host: ").append(authIP).append("\r\n");
                                reqMsg2.append("Accept: text/html\r\n");
                                reqMsg2.append("Connection: close\r\n");
                                reqMsg2.append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                reqMsg2.append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                reqMsg2.append("\r\n");
                                reqMsg2.append(encry_reqData);
                                socket = new Socket(authIP, authPort);
                                out = new BufferedOutputStream(socket.getOutputStream());
                                in = new BufferedInputStream(socket.getInputStream());
                                out.write(reqMsg2.toString().getBytes());
                                ((BufferedOutputStream)out).flush();
                                signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                mac = Mac.getInstance(methodName);
                                mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                expectedResponse = mac.doFinal(this.lic_licensee.getBytes(Charset.forName("UTF-8")));
                                respLen = expectedResponse.length;
                                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                byte[] buffer = new byte[100];
                                len = -1;
                                while ((len = ((FilterInputStream)in).read(buffer)) != -1) {
                                    bytesOut.write(buffer, 0, len);
                                }
                                byte[] respBuffer = bytesOut.toByteArray();
                                byte[] response = Utils.analyseAgentResponse((byte[])respBuffer);
                                if (Arrays.equals(response, expectedResponse)) {
                                    break block121;
                                }
                                throw new Exception(new String(response));
                            }
                            catch (IOException ex) {
                                throw ex;
                            }
                            finally {
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (in != null) {
                                    try {
                                        ((BufferedInputStream)in).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (socket != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                    }
                    this.lic_granted = this.lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - this.lic_datefrom) >= 0L && _timediff < (long)this.lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0;
                    this.lic_address = -1;
                }
                catch (Throwable _ex) {
                    this.lic_granted = -1;
                    System.out.println(_ex.getMessage());
                    _ex.printStackTrace();
                }
            }
            boolean bl = isNormal = !this.lic_center;
            if (isNormal && !"Virtual Edition".equals(this.lic_edition)) {
                Throwable taddr = null;
                try {
                    this.lic_granted = 2130706435;
                    if (this.lic_version >= 2) {
                        boolean ck = false;
                        if (this.lic_aowedIPs != null && !"".equals(this.lic_aowedIPs)) {
                            in = this.lic_aowedIPs;
                            String regEx = new StringBuffer("^").append((String)in).append("\\.").append(".*$").toString();
                            Pattern p = Pattern.compile(regEx);
                            InetAddress lh = InetAddress.getLocalHost();
                            String ip = lh.getHostAddress();
                            byte[] adds = lh.getAddress();
                            if (p.matcher(ip).matches()) {
                                ck = true;
                            } else {
                                Enumeration<NetworkInterface> netInts = NetworkInterface.getNetworkInterfaces();
                                while (netInts.hasMoreElements() && !ck) {
                                    NetworkInterface networkInterface = netInts.nextElement();
                                    Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                                    while (ips.hasMoreElements() && !ck) {
                                        lh = ips.nextElement();
                                        adds = lh.getAddress();
                                        String tip = lh.getHostAddress();
                                        if (!p.matcher(tip).matches()) continue;
                                        ck = true;
                                    }
                                }
                            }
                            if (!ck) {
                                this.lic_address = ((adds[0] & 0xFF) << 24) + ((adds[1] & 0xFF) << 16) + ((adds[2] & 0xFF) << 8) + ((adds[3] & 0xFF) << 0);
                                throw new Exception("error");
                            }
                        }
                        if (this.lic_address != -1 && !this.lic_addressStr.equals("255.255.255.255")) {
                            this.lic_ip = this.lic_address == 0 ? this.lic_addressStr : this.lic_ip;
                            InetAddress _addr = InetAddress.getByName(this.lic_ip);
                            ServerSocket _ss = new ServerSocket(0, 1, _addr);
                            _ss.close();
                        }
                    }
                    if (this.lic_version == 1) {
                        boolean ck = false;
                        List ips = MacMain.getLocalIPs();
                        ips.add(new StringBuffer("255").append(".255").append(".255").append(".255").toString());
                        for (String ip : ips) {
                            if (!this.lic_addressStr.equals(MacMain.getSoftCode((String)ip))) continue;
                            ck = true;
                            break;
                        }
                        if (!"10.1.2".startsWith(this.lic_prodversion)) {
                            System.out.println("v");
                            ck = false;
                        }
                        if (!ck) {
                            throw new Exception("rror");
                        }
                    }
                }
                catch (Throwable _ex) {
                    taddr = _ex;
                }
                if (taddr == null) {
                    long _timediff;
                    this.lic_granted = this.lic_version == 1 ? (this.lic_dateend > 0L ? (System.currentTimeMillis() >= this.lic_datefrom && System.currentTimeMillis() <= this.lic_dateend ? 0 : 2130706434) : 0) : (this.lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - this.lic_datefrom) >= 0L && _timediff < (long)this.lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0);
                }
            }
            if (this.lic_granted != 0) {
                ++this.count;
                if (this.count > 2) {
                    System.err.println(new StringBuffer("no lice").append("nse ,ser").append("ver wil").append("l shu").append("tdown!").toString());
                }
            } else {
                this.count = 0;
            }
        }
    }
}

