/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.core;

import com.apusic.aas.util.res.StringManager;
import com.apusic.aas.util.threads.ThreadPoolExecutor;
import com.apusic.ams.ContainerEvent;
import com.apusic.ams.Context;
import com.apusic.ams.Engine;
import com.apusic.ams.Lifecycle;
import com.apusic.ams.LifecycleEvent;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.Server;
import com.apusic.ams.Service;
import com.apusic.ams.connector.Connector;
import com.apusic.ams.core.FrameworkListener;
import com.apusic.ams.core.StandardContext;
import com.apusic.ams.core.StandardThreadExecutor;
import com.apusic.connector.ProtocolHandler;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.util.concurrent.Executor;

public class ThreadLocalLeakPreventionListener
extends FrameworkListener {
    private static final Log log = LogFactory.getLog(ThreadLocalLeakPreventionListener.class);
    private volatile boolean serverStopping = false;
    protected static final StringManager sm = StringManager.getManager(ThreadLocalLeakPreventionListener.class);

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            super.lifecycleEvent(event);
            Lifecycle lifecycle = event.getLifecycle();
            if ("before_stop".equals(event.getType()) && lifecycle instanceof Server) {
                this.serverStopping = true;
            }
            if ("after_stop".equals(event.getType()) && lifecycle instanceof Context) {
                this.stopIdleThreads((Context)lifecycle);
            }
        }
        catch (Exception e) {
            String msg = sm.getString("threadLocalLeakPreventionListener.lifecycleEvent.error", event);
            log.error(msg, e);
        }
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        try {
            super.containerEvent(event);
        }
        catch (Exception e) {
            String msg = sm.getString("threadLocalLeakPreventionListener.containerEvent.error", event);
            log.error(msg, e);
        }
    }

    private void stopIdleThreads(Context context) {
        if (this.serverStopping) {
            return;
        }
        if (!(context instanceof StandardContext) || !((StandardContext)context).getRenewThreadsWhenStoppingContext()) {
            log.debug("Not renewing threads when the context is stopping. It is not configured to do it.");
            return;
        }
        Engine engine = (Engine)context.getParent().getParent();
        Service service = engine.getService();
        Connector[] connectors = service.findConnectors();
        if (connectors != null) {
            for (Connector connector : connectors) {
                ProtocolHandler handler = connector.getProtocolHandler();
                Executor executor = null;
                if (handler != null) {
                    executor = handler.getExecutor();
                }
                if (executor instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                    threadPoolExecutor.contextStopping();
                    continue;
                }
                if (!(executor instanceof StandardThreadExecutor)) continue;
                StandardThreadExecutor stdThreadExecutor = (StandardThreadExecutor)executor;
                stdThreadExecutor.contextStopping();
            }
        }
    }

    @Override
    protected LifecycleListener createLifecycleListener(Context context) {
        return this;
    }
}

