/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.filters;

import com.apusic.ams.filters.FilterBase;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class AddDefaultCharsetFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(AddDefaultCharsetFilter.class);
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private String encoding;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.encoding == null || this.encoding.length() == 0 || this.encoding.equalsIgnoreCase("default")) {
            this.encoding = DEFAULT_ENCODING;
        } else if (this.encoding.equalsIgnoreCase("system")) {
            this.encoding = Charset.defaultCharset().name();
        } else if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException(sm.getString("addDefaultCharset.unsupportedCharset", this.encoding));
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            ResponseWrapper wrapped = new ResponseWrapper((HttpServletResponse)response, this.encoding);
            chain.doFilter(request, wrapped);
        } else {
            chain.doFilter(request, response);
        }
    }

    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private String encoding;

        public ResponseWrapper(HttpServletResponse response, String encoding) {
            super(response);
            this.encoding = encoding;
        }

        @Override
        public void setContentType(String contentType) {
            if (contentType != null && contentType.startsWith("text/")) {
                if (!contentType.contains("charset=")) {
                    super.setContentType(contentType + ";charset=" + this.encoding);
                } else {
                    super.setContentType(contentType);
                    this.encoding = this.getCharacterEncoding();
                }
            } else {
                super.setContentType(contentType);
            }
        }

        @Override
        public void setHeader(String name, String value) {
            if (name.trim().equalsIgnoreCase("content-type")) {
                this.setContentType(value);
            } else {
                super.setHeader(name, value);
            }
        }

        @Override
        public void addHeader(String name, String value) {
            if (name.trim().equalsIgnoreCase("content-type")) {
                this.setContentType(value);
            } else {
                super.addHeader(name, value);
            }
        }

        @Override
        public void setCharacterEncoding(String charset) {
            super.setCharacterEncoding(charset);
            this.encoding = charset;
        }
    }
}

