/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.report;

import com.apusic.ams.report.AESUtils;
import com.apusic.ams.report.ReportEventType;
import com.apusic.ams.report.ReportRequestDTO;
import com.apusic.util.Utils;
import com.apusic.util.Version;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportEventMgr {
    private static final String REPORT_MODE_FULL = "full";
    private static final int REPORT_INTERVAL_MINUTES = 60;
    private static final int REPORT_TIMEOUT_SECONDS = 5;
    private static final String CONFIG_FILE_NAME = "reportServer";
    private static final String APUSIC_CONFIG_FILE = Utils.getServerRoot() + File.separator + "conf" + File.separator + "apusic.conf";
    private static final String HTTP_PORT_NAME = "businessPort";
    private static String http_port = "";
    private static final String HTTPS_PORT_NAME = "httpsBusinessPort";
    private static String https_port = "";
    private static String IP;
    private static int PORT;
    private static String URLCTX;
    private static String ID;
    private static String ENCRYPID;
    private static String REPORT_MODE;
    private static int REPORT_TIMEOUT;
    private static int REPORT_INTERVAL;
    private static long STARTTIME;
    private static boolean hasInit;
    private static String LICVERSION;
    private static boolean LICGET;
    private static SimpleDateFormat sdf;
    private static Properties pro;
    private static ScheduledExecutorService ses;
    private static ReportRequestDTO reportRequestVO;
    private static boolean debug;
    private static boolean FROMFILE;
    private static File PROFILE;

    public static boolean hasServer() {
        return hasInit;
    }

    public static void startReport() {
        if (!ReportEventMgr.hasServer()) {
            if (Version.getEdition().equals("Subscribe Edition")) {
                ReportEventMgr.error("no report IP");
                System.exit(1);
            } else {
                return;
            }
        }
        ReportEventMgr.initReportRequest();
        if (!ReportEventMgr.reportActive()) {
            ReportEventMgr.error("Active Error");
            System.exit(1);
        }
        ReportEventMgr.reportStartup();
        ReportEventMgr.reportHeartBeat();
    }

    public static void reportShutDown() {
        if (ReportEventMgr.hasServer()) {
            ReportEventMgr.reportEvent(ReportEventType.SHUTDOWN);
        }
        ses.shutdownNow();
    }

    public static boolean getLicense(boolean mustbenew, String licV, String edition, File file) {
        if (ReportEventMgr.hasServer() && (mustbenew || LICGET)) {
            if (LICVERSION == null && "0".equals(licV)) {
                ReportEventMgr.error("no LicenseVersion,please set LicenseVerion");
                return true;
            }
            ReportEventMgr.reportLicense(LICVERSION == null ? licV : LICVERSION, edition, file);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        String home = System.getProperty("apusic.home");
        File file = new File(home, CONFIG_FILE_NAME);
        if (!file.exists()) {
            file = new File(System.getProperty("user.dir"), CONFIG_FILE_NAME);
        }
        if (file.exists()) {
            PROFILE = file;
            FileInputStream inStream = null;
            try {
                String it;
                String to;
                inStream = new FileInputStream(file);
                pro.load(inStream);
                IP = pro.getProperty("Ip");
                PORT = Integer.parseInt(pro.getProperty("Port"));
                URLCTX = pro.getProperty("Url");
                ID = pro.getProperty("Id");
                ENCRYPID = pro.getProperty("EncrypID");
                String md = pro.getProperty("mode");
                if (md != null) {
                    REPORT_MODE = md;
                }
                if ((to = pro.getProperty("timeout")) != null) {
                    REPORT_TIMEOUT = Integer.parseInt(to);
                }
                if ((it = pro.getProperty("interval")) != null && ((REPORT_INTERVAL = Integer.parseInt(it)) > 720 || REPORT_INTERVAL < 10)) {
                    REPORT_INTERVAL = 720;
                }
                if (IP != null) {
                    hasInit = true;
                }
                LICVERSION = pro.getProperty("licVersion");
                String lg = pro.getProperty("licGet");
                LICGET = Boolean.parseBoolean(lg);
            }
            catch (Exception ex) {
                ReportEventMgr.error("init error:" + ex.getMessage());
            }
            finally {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException ex) {}
            }
        } else {
            String it;
            String to;
            IP = System.getenv("apusic_report_Ip");
            if (IP == null) {
                return;
            }
            PORT = Integer.parseInt(System.getenv("apusic_report_Port"));
            URLCTX = System.getenv("apusic_report_Url");
            ID = System.getenv("apusic_report_Id");
            ENCRYPID = System.getenv("apusic_report_EncrypID");
            String md = System.getenv("apusic_report_mode");
            if (md != null) {
                REPORT_MODE = md;
            }
            if ((to = System.getenv("apusic_report_timeout")) != null) {
                REPORT_TIMEOUT = Integer.parseInt(to);
            }
            if ((it = System.getenv("apusic_report_interval")) != null && ((REPORT_INTERVAL = Integer.parseInt(it)) > 720 || REPORT_INTERVAL < 10)) {
                REPORT_INTERVAL = 720;
            }
            if (IP != null) {
                hasInit = true;
            }
            LICVERSION = pro.getProperty("apusic_report_licVersion");
            String lg = pro.getProperty("apusic_report_licGet");
            LICGET = Boolean.parseBoolean(lg);
            FROMFILE = false;
        }
        if (new File(APUSIC_CONFIG_FILE).exists()) {
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(new File(APUSIC_CONFIG_FILE));
                Element root = document.getDocumentElement();
                NodeList nodeList = root.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    NodeList childNodeList = node.getChildNodes();
                    for (int j = 0; j < childNodeList.getLength(); ++j) {
                        Node protocol;
                        String elementName;
                        Node childNode = childNodeList.item(j);
                        if (childNode.getNodeType() != 1 || !(elementName = childNode.getNodeName()).equals("endpoint") || !(protocol = childNode.getAttributes().getNamedItem("protocol")).getNodeValue().trim().equals("HTTP/1.1")) continue;
                        Node sslEnabled = childNode.getAttributes().getNamedItem("SSLEnabled");
                        Node port = childNode.getAttributes().getNamedItem("port");
                        if (sslEnabled != null && sslEnabled.getNodeValue().trim().equalsIgnoreCase("true")) {
                            https_port = port.getNodeValue().trim();
                            continue;
                        }
                        http_port = port.getNodeValue().trim();
                    }
                }
            }
            catch (Exception e) {
                ReportEventMgr.error("parse config file " + APUSIC_CONFIG_FILE + " error \n message:" + e.getMessage());
            }
        }
    }

    private static void initReportRequest() {
        reportRequestVO = ReportRequestDTO.createInitInstance();
        reportRequestVO.setProductID(ID);
        reportRequestVO.setBusinessPort(http_port);
        reportRequestVO.setHttpsBusinessPort(https_port);
        reportRequestVO.setMonitorPort(http_port);
        reportRequestVO.setProductName("Apusic Application Server");
        reportRequestVO.setProductVersionNumber("10.1.2");
        reportRequestVO.setProductVersion(Version.getEdition());
        reportRequestVO.setProductBuildVersion("/202203231652");
        reportRequestVO.setProductDeployPath(System.getProperty("apusic.base").replace('\\', '/'));
        reportRequestVO.setLicenseUser(Version.getLicenseEE());
        reportRequestVO.setLicenseDateFrom(sdf.format(new Date(Version.getDateFrom())));
        reportRequestVO.setLicenseCPUs(Version.getCPUs());
        reportRequestVO.setLicenseVer(String.valueOf(Version.getLicVersion()));
        reportRequestVO.setLicenseConnection(Version.getConnections());
        reportRequestVO.setHostIP(ReportEventMgr.getIPs());
        if (Version.getDuration() != 0) {
            Long tmp = (long)Version.getDuration() * 86400L * 1000L + Version.getDateFrom();
            reportRequestVO.setLicenseExpiration(sdf.format(new Date(tmp)));
        }
    }

    private static void log(String mess) {
        System.out.println(mess);
    }

    private static void error(String mess) {
        System.err.println(mess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reportActive() {
        boolean needActive = true;
        try {
            AESUtils.decodeAesBase64ToString(ENCRYPID);
            needActive = false;
        }
        catch (Exception e) {
            needActive = true;
        }
        if (!needActive) {
            return true;
        }
        String result = ReportEventMgr.createReportRequest(ReportEventType.ACTIVE, true);
        OutputStream outStream = null;
        Socket socket = null;
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        String encrypID = null;
        try {
            String id;
            ReportEventMgr.log("activate starting...");
            if (debug) {
                ReportEventMgr.log("send=" + result);
            }
            socket = ReportEventMgr.buildSocket(REPORT_TIMEOUT);
            out = new BufferedOutputStream(socket.getOutputStream());
            in = new BufferedInputStream(socket.getInputStream());
            out.write(result.getBytes());
            ((BufferedOutputStream)out).flush();
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[1000];
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                bytesOut.write(buffer, 0, len);
            }
            byte[] response = bytesOut.toByteArray();
            byte[] respBuffer0 = ReportEventMgr.analyseAgentResponse(response);
            encrypID = new String(respBuffer0);
            if (debug) {
                ReportEventMgr.log(respBuffer0.length + "respBuffer0=" + respBuffer0);
                ReportEventMgr.log("encrypID=" + encrypID);
            }
            ID = id = AESUtils.decodeAesBase64ToString(encrypID);
            ENCRYPID = encrypID;
            if (FROMFILE && PROFILE != null) {
                outStream = new FileOutputStream(PROFILE);
                pro.setProperty("Id", id);
                pro.setProperty("EncrypID", encrypID);
                pro.store(outStream, "");
            }
            ReportEventMgr.log("activate finish...");
            boolean bl = true;
            return bl;
        }
        catch (IOException io) {
            ReportEventMgr.log("activate error...server maybe not started:" + IP + ":" + PORT + URLCTX);
            if (debug) {
                io.printStackTrace();
                ReportEventMgr.log("activate error...server maybe not started:" + FROMFILE + "-" + PROFILE);
            }
        }
        catch (Exception ex) {
            if (encrypID != null) {
                ReportEventMgr.error("activate error..." + encrypID);
            } else {
                ReportEventMgr.error("activate error..." + ex.getMessage());
            }
            if (debug) {
                ex.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException io) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException io) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException io) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException io) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reportLicense(String licV, String edition, File file) {
        String result = ReportEventMgr.createGetLicenseRequest(licV, edition, file);
        OutputStream outStream = null;
        Socket socket = null;
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            ReportEventMgr.log("getLicense starting...");
            if (debug) {
                ReportEventMgr.log(result);
            }
            socket = ReportEventMgr.buildSocket(REPORT_TIMEOUT);
            out = new BufferedOutputStream(socket.getOutputStream());
            in = new BufferedInputStream(socket.getInputStream());
            out.write(result.getBytes());
            ((BufferedOutputStream)out).flush();
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                bytesOut.write(buffer, 0, len);
            }
            byte[] response = bytesOut.toByteArray();
            byte[] respBuffer0 = ReportEventMgr.analyseAgentResponse(response);
            String licContent = new String(respBuffer0);
            String content = AESUtils.decodeAesBase64ToString(licContent);
            if (file == null || !file.exists()) {
                if (PROFILE != null) {
                    file = new File(PROFILE.getParentFile(), file == null ? "license.xml" : file.getName());
                } else if (file == null || !file.isAbsolute()) {
                    String home = System.getProperty("com.apusic.home");
                    file = new File(home, file == null ? "license.xml" : file.getName());
                }
            }
            outStream = new FileOutputStream(file);
            outStream.write(content.getBytes("UTF-8"));
            outStream.close();
            if (FROMFILE && PROFILE != null && LICGET) {
                outStream = new FileOutputStream(PROFILE);
                pro.setProperty("licGet", "false");
                pro.store(outStream, "");
            }
            ReportEventMgr.log("getLicense finish...");
            boolean bl = true;
            return bl;
        }
        catch (IOException io) {
            ReportEventMgr.log("getLicense error...server maybe not started:" + IP + ":" + PORT + URLCTX);
        }
        catch (Exception ex) {
            ReportEventMgr.error("getLicense error..." + ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException io) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException io) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException io) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException io) {}
            }
        }
        return false;
    }

    private static void reportStartup() {
    }

    private static void reportHeartBeat() {
        Runnable command = new Runnable(){
            boolean reportStart = true;

            @Override
            public void run() {
                if (this.reportStart) {
                    ReportEventMgr.reportEvent(ReportEventType.STARTUP);
                    this.reportStart = false;
                } else {
                    ReportEventMgr.reportEvent(ReportEventType.HEARTBEAT);
                }
            }
        };
        ses.scheduleAtFixedRate(command, 0L, REPORT_INTERVAL, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportEvent(ReportEventType eventType) {
        String result = ReportEventMgr.createReportRequest(eventType, false);
        Socket socket = null;
        FilterOutputStream out = null;
        try {
            if (debug) {
                ReportEventMgr.log(result);
            }
            socket = ReportEventMgr.buildSocket(REPORT_TIMEOUT);
            out = new BufferedOutputStream(socket.getOutputStream());
            out.write(result.getBytes());
            ((BufferedOutputStream)out).flush();
        }
        catch (Exception ex) {
            ReportEventMgr.error("reportEvent error:" + ex.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Socket buildSocket(int timeout) throws IOException {
        Socket socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(IP, PORT);
        socket.connect(address, timeout * 1000);
        socket.setSoTimeout(timeout * 1000);
        return socket;
    }

    private static String createGetLicenseRequest(String licV, String edition, File file) {
        String encry_reqData = "";
        try {
            encry_reqData = new StringBuffer("licenseVer=").append(AESUtils.encodeToAesBase64(licV)).append(edition != null ? "&edition=" + AESUtils.encodeToAesBase64(edition) : "").append(ENCRYPID != null ? "&EncrypID=" + AESUtils.encodeToAesBase64(ENCRYPID) : "").toString();
        }
        catch (Exception e) {
            ReportEventMgr.error(e.getMessage());
        }
        String result = ReportEventMgr.makeHttpMessage(ReportEventType.GETLICENSE.getURL(), encry_reqData, "x-www-form-urlencoded");
        return result;
    }

    private static String createReportRequest(ReportEventType eventType, boolean all) {
        reportRequestVO.setProductID(ID);
        reportRequestVO.setEventType(eventType.getName());
        reportRequestVO.setEventTime(System.currentTimeMillis());
        reportRequestVO.setSurvivalTime(System.currentTimeMillis() - STARTTIME);
        String reqData = "";
        reqData = REPORT_MODE.equals(REPORT_MODE_FULL) || all ? reportRequestVO.toJson() : reportRequestVO.toSimpleJson();
        String encry_reqData = "";
        try {
            encry_reqData = AESUtils.encodeToAesBase64(reqData);
        }
        catch (Exception e) {
            ReportEventMgr.error(e.getMessage());
        }
        String result = ReportEventMgr.makeHttpMessage(eventType.getURL(), "\"" + encry_reqData + "\"", "json");
        return result;
    }

    private static String makeHttpMessage(String action, String content, String contentType) {
        StringBuilder reqMsg = new StringBuilder();
        reqMsg.append("POST ").append(URLCTX + action).append(" HTTP/1.1\r\n");
        reqMsg.append("Cache-Control: no-cache\r\n");
        reqMsg.append("Pragma: no-cache\r\n");
        reqMsg.append("User-Agent: JavaSocket/Apusic").append("\r\n");
        reqMsg.append("Host: ").append(IP).append(":").append(PORT).append("\r\n");
        reqMsg.append("Accept: text/html\r\n");
        reqMsg.append("Connection: close\r\n");
        reqMsg.append("Content-Type: application/").append(contentType).append("; charset=").append("UTF-8").append("\r\n");
        reqMsg.append("Content-Length: ").append(content.getBytes().length).append("\r\n");
        reqMsg.append("\r\n");
        reqMsg.append(content);
        return reqMsg.toString();
    }

    private static byte[] analyseAgentResponse(byte[] buffers) {
        int pos = 0;
        int len = 0;
        int off = pos;
        int count = buffers.length;
        int resLen = 0;
        while (pos < count) {
            String str;
            if (buffers[pos] == 13) {
                if (pos + 1 < count && buffers[pos + 1] == 10) {
                    ++pos;
                }
                ++pos;
                str = new String(buffers, 0, off, len);
                if (str.indexOf("Content-Length:") > -1) {
                    resLen = Integer.parseInt(str.substring(15).trim());
                }
                off = pos;
                len = 0;
                if (!"".equals(str)) continue;
                break;
            }
            if (buffers[pos] == 10) {
                ++pos;
                str = new String(buffers, 0, off, len);
                if (str.indexOf("Content-Length:") > -1) {
                    resLen = Integer.parseInt(str.substring(15).trim());
                }
                off = pos;
                len = 0;
                if (!"".equals(str)) continue;
                break;
            }
            ++pos;
            ++len;
        }
        byte[] respBuffer = new byte[resLen];
        System.arraycopy(buffers, pos, respBuffer, 0, resLen);
        return respBuffer;
    }

    private static String getIPs() {
        StringBuffer ipList = new StringBuffer();
        try {
            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
            boolean first = true;
            while (all.hasMoreElements()) {
                byte[] mac;
                NetworkInterface nw = all.nextElement();
                if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                Enumeration<InetAddress> iparray = nw.getInetAddresses();
                while (iparray.hasMoreElements()) {
                    InetAddress addr = iparray.nextElement();
                    String testaddr = addr.getHostAddress();
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1") || !(addr instanceof Inet4Address)) continue;
                    if (!first) {
                        ipList.append(",");
                    } else {
                        first = false;
                    }
                    ipList.append(testaddr);
                }
            }
        }
        catch (SocketException e) {
            ReportEventMgr.error(e.getMessage());
        }
        return ipList.toString();
    }

    static {
        REPORT_MODE = REPORT_MODE_FULL;
        REPORT_TIMEOUT = 5;
        REPORT_INTERVAL = 60;
        STARTTIME = System.currentTimeMillis();
        hasInit = false;
        LICVERSION = null;
        LICGET = false;
        sdf = new SimpleDateFormat("yyyy-MM-dd");
        pro = new Properties();
        ses = Executors.newScheduledThreadPool(1);
        reportRequestVO = null;
        debug = Boolean.getBoolean("apusic.debug");
        FROMFILE = true;
        PROFILE = null;
        ReportEventMgr.init();
    }
}

