/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.session;

import com.apusic.ams.Manager;
import com.apusic.ams.session.InMemorySessionManager;
import com.apusic.ams.session.StandardSession;
import com.apusic.ams.util.ConcurrentDirectDeque;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class InMemorySession
extends StandardSession {
    private static volatile AtomicReferenceFieldUpdater<InMemorySession, Object> evictionTokenUpdater = AtomicReferenceFieldUpdater.newUpdater(InMemorySession.class, Object.class, "evictionToken");
    private volatile Object evictionToken;

    public InMemorySession(Manager manager) {
        super(manager);
    }

    void setEvictionToken(Object evictionToken) {
        this.evictionToken = evictionToken;
    }

    Object getEvictionToken() {
        return this.evictionToken;
    }

    @Override
    public void endAccess() {
        super.endAccess();
        this.updateEvictionToken();
    }

    synchronized void updateEvictionToken() {
        Object token;
        if (this.evictionToken != null && this.manager instanceof InMemorySessionManager && evictionTokenUpdater.compareAndSet(this, token = this.evictionToken, null)) {
            ConcurrentDirectDeque<String> evictionQueue = ((InMemorySessionManager)this.manager).getEvictionQueue();
            evictionQueue.removeToken(token);
            this.evictionToken = evictionQueue.offerLastAndReturnToken(this.getId());
        }
    }
}

