/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.startup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class AmsConfigBean
implements Serializable {
    public static final String CONTAINER = "container";
    public static final String SERVER = "server";
    public static final String REALM = "realm";
    public static final String SERVICE = "service";
    public static final String HOST = "host";
    public static final String VALVE = "valve";
    public static final String APPLICATION = "application";
    public static final String ENDPOINT = "endpoint";
    public static final String EXECUTOR = "executor";
    public static final String RESOURCE = "resource";
    public static final String LISTENER = "listener";
    public static final String CLUSTER = "Cluster";
    private String name;
    private String type;
    private AmsConfigBean parent;
    private List<AmsConfigBean> childrenList = new ArrayList<AmsConfigBean>();
    private Map<String, String> attributesMap = new HashMap<String, String>();

    public AmsConfigBean(String name, String type, AmsConfigBean parent) {
        this.name = name;
        this.type = type;
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        String oriName;
        if (null == obj || !(obj instanceof AmsConfigBean)) {
            return false;
        }
        AmsConfigBean bean = (AmsConfigBean)obj;
        String cmpName = bean.getName();
        if (null == cmpName || "".equals(cmpName)) {
            cmpName = bean.getType();
        }
        if (null == (oriName = this.getName()) || "".equals(oriName)) {
            oriName = this.getType();
        }
        return cmpName.equals(oriName);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AmsConfigBean getParent() {
        return this.parent;
    }

    public void setParent(AmsConfigBean parent) {
        this.parent = parent;
    }

    public void addAttribute(String name, String value) {
        this.attributesMap.put(name, value);
    }

    public Map<String, String> getAttributes() {
        return this.attributesMap;
    }

    public void addAmsConfigBean(AmsConfigBean bean) {
        this.childrenList.add(bean);
    }

    public List<AmsConfigBean> getChildrenList() {
        return this.childrenList;
    }

    public AmsConfigBean findByType(String type) {
        for (AmsConfigBean config : this.childrenList) {
            if (config.getType().equals(type)) {
                return config;
            }
            AmsConfigBean bean = this.findByType(config, type);
            if (null == bean) continue;
            return bean;
        }
        return null;
    }

    private AmsConfigBean findByType(AmsConfigBean bean, String type) {
        for (AmsConfigBean config : bean.getChildrenList()) {
            if (config.getType().equals(type)) {
                return config;
            }
            this.findByType(config, type);
        }
        return null;
    }
}

