/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.startup;

import com.apusic.aas.util.ExceptionUtils;
import com.apusic.aas.util.digester.Digester;
import com.apusic.aas.util.digester.Rule;
import com.apusic.aas.util.digester.RuleSet;
import com.apusic.aas.util.file.ConfigFileLoader;
import com.apusic.aas.util.file.ConfigurationSource;
import com.apusic.aas.util.res.StringManager;
import com.apusic.ams.Container;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.LifecycleState;
import com.apusic.ams.Server;
import com.apusic.ams.connector.Connector;
import com.apusic.ams.core.StandardContext;
import com.apusic.ams.security.SecurityConfig;
import com.apusic.ams.startup.AddPortOffsetRule;
import com.apusic.ams.startup.AmsConfigBean;
import com.apusic.ams.startup.ApusicBaseConfigurationSource;
import com.apusic.ams.startup.Bootstrap;
import com.apusic.ams.startup.CertificateCreateRule;
import com.apusic.ams.startup.ConnectorCreateRule;
import com.apusic.ams.startup.ContextRuleSet;
import com.apusic.ams.startup.EngineRuleSet;
import com.apusic.ams.startup.HostRuleSet;
import com.apusic.ams.startup.Item;
import com.apusic.ams.startup.ListenerCreateRule;
import com.apusic.ams.startup.NamingRuleSet;
import com.apusic.juli.ClassLoaderLogManager;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import com.apusic.juli.logging.LogPrintStream;
import com.apusic.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Apusic {
    public static final String APUSIC_EXECUTOR_MAX_THREADS = "apusic.executor.max_threads";
    public static final String APUSIC_EXECUTOR_MAX_MIN_SPARE_THREADS = "apusic.executor.min_spare_threads";
    public static final String APUSIC_EXECUTOR_MAX_QUEUE = "apusic.executor.max_queue_size";
    public static final String APUSIC_EXECUTOR_MAX_IDLE_TIME = "apusic.executor.max_idle_time";
    public static final String APUSIC_ENDPOINT_PORT = "apusic.endpoint.port";
    public static final String APUSIC_ENDPOINT_REDIRECT_PORT = "apusic.endpoint.redirect_port";
    public static final String APUSIC_ENDPOINT_MAX_POST_SIZE = "apusic.endpoint.max_post_size";
    public static final String APUSIC_ENDPOINT_URI_ENCODING = "apusic.endpoint.uri_encoding";
    public static final String APUSIC_ENDPOINT_MAX_PARAMETER_COUNT = "apusic.endpoint.max_parameter_count";
    public static final String APUSIC_ENDPOINT_MAX_COOKIE_COUNT = "apusic.endpoint.max_cookie_count";
    public static final String APUSIC_ENDPOINT_CONNECTION_TIMEOUT = "apusic.endpoint.connection_timeout";
    public static final String APUSIC_ENDPOINT_MAX_CONNECTIONS = "apusic.endpoint.max_connections";
    public static final String APUSIC_ENDPOINT_ACCEPT_COUNT = "apusic.endpoint.accept_count";
    public static final String APUSIC_ENDPOINT_MAX_HTTP_HEADER_SIZE = "apusic.endpoint.max_http_header_size";
    public static final String APUSIC_ENDPOINT_COMPRESSION = "apusic.endpoint.compression";
    public static final String APUSIC_ENDPOINT_COMPRESSION_MIN_SIZE = "apusic.endpoint.compression_min_size";
    public static final String APUSIC_ENDPOINT_DISABLE_UPLOAD_TIMEOUT = "apusic.endpoint.disable_upload_timeout";
    public static final String APUSIC_ENDPOINT_COMPRESSIBLE_MIME_TYPE = "apusic.endpoint.compressible_mime_type";
    public static final String APUSIC_ENDPOINT_MAX_KEEP_ALIVE_REQUESTS = "apusic.endpoint.max_keep_alive_requests";
    public static final String APUSIC_ENDPOINT_KEEP_ALIVE_TIMEOUT = "apusic.endpoint.keep_alive_timeout";
    public static final String APUSIC_CONTAINER_SHUTDOWN_PORT = "apusic.container.shutdown_port";
    private static final Map<String, Item<String, String, String>> CLOUD_CONFIG_ITEMS = new HashMap<String, Item<String, String, String>>(){
        {
            this.put(Apusic.APUSIC_EXECUTOR_MAX_THREADS, new Item<String, String, String>("executor", "maxThreads", "200"));
            this.put(Apusic.APUSIC_EXECUTOR_MAX_MIN_SPARE_THREADS, new Item<String, String, String>("executor", "minSpareThreads", "5"));
            this.put(Apusic.APUSIC_EXECUTOR_MAX_QUEUE, new Item<String, String, String>("executor", "maxQueueSize", "5000"));
            this.put(Apusic.APUSIC_EXECUTOR_MAX_IDLE_TIME, new Item<String, String, String>("executor", "maxIdleTime", "60000"));
            this.put(Apusic.APUSIC_ENDPOINT_PORT, new Item<String, String, String>("endpoint", "port", "6888"));
            this.put(Apusic.APUSIC_ENDPOINT_REDIRECT_PORT, new Item<String, String, String>("endpoint", "redirectPort", "6443"));
            this.put(Apusic.APUSIC_ENDPOINT_CONNECTION_TIMEOUT, new Item<String, String, String>("endpoint", "connectionTimeout", "20000"));
            this.put(Apusic.APUSIC_ENDPOINT_MAX_CONNECTIONS, new Item<String, String, String>("endpoint", "maxConnections", "10000"));
            this.put(Apusic.APUSIC_ENDPOINT_ACCEPT_COUNT, new Item<String, String, String>("endpoint", "acceptCount", "100"));
            this.put(Apusic.APUSIC_ENDPOINT_MAX_POST_SIZE, new Item<String, String, String>("endpoint", "maxPostSize", "104857600"));
            this.put(Apusic.APUSIC_ENDPOINT_MAX_HTTP_HEADER_SIZE, new Item<String, String, String>("endpoint", "maxHttpHeaderSize", "8192"));
            this.put(Apusic.APUSIC_ENDPOINT_COMPRESSION, new Item<String, String, String>("endpoint", "compression", "on"));
            this.put(Apusic.APUSIC_ENDPOINT_COMPRESSION_MIN_SIZE, new Item<String, String, String>("endpoint", "compressionMinSize", "2048"));
            this.put(Apusic.APUSIC_ENDPOINT_COMPRESSIBLE_MIME_TYPE, new Item<String, String, String>("endpoint", "compressibleMimeType", "text/html,text/xml,text/plain,text/css,text/javascript,application/javascript,application/json,application/xml,application/x-font-ttf,application/x-font-otf"));
            this.put(Apusic.APUSIC_ENDPOINT_URI_ENCODING, new Item<String, String, String>("endpoint", "URIEncoding", "utf-8"));
            this.put(Apusic.APUSIC_ENDPOINT_DISABLE_UPLOAD_TIMEOUT, new Item<String, String, String>("endpoint", "disableUploadTimeout", "true"));
            this.put(Apusic.APUSIC_ENDPOINT_MAX_PARAMETER_COUNT, new Item<String, String, String>("endpoint", "maxParameterCount", "10000"));
            this.put(Apusic.APUSIC_ENDPOINT_MAX_COOKIE_COUNT, new Item<String, String, String>("endpoint", "maxCookieCount", "200"));
            this.put(Apusic.APUSIC_ENDPOINT_MAX_KEEP_ALIVE_REQUESTS, new Item<String, String, String>("endpoint", "maxKeepAliveRequests", "100"));
            this.put(Apusic.APUSIC_ENDPOINT_KEEP_ALIVE_TIMEOUT, new Item<String, String, String>("endpoint", "keepAliveTimeout", "15000"));
            this.put(Apusic.APUSIC_CONTAINER_SHUTDOWN_PORT, new Item<String, String, String>("container", "port", "-1"));
        }
    };
    protected static final StringManager sm = StringManager.getManager("com.apusic.ams.startup");
    public static final String SERVER_XML = "conf/apusic.conf";
    public static final String SERVER_XML_TMP = "apusic.conf.tmp";
    private static final Logger SYSTEM_OUT_LOGGER = Logger.getLogger("System.out");
    private static final Logger SYSTEM_ERR_LOGGER = Logger.getLogger("System.err");
    protected boolean await = false;
    protected String configFile = "conf/apusic.conf";
    protected ClassLoader parentClassLoader = Apusic.class.getClassLoader();
    protected Server server = null;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    protected boolean useNaming = true;
    protected boolean loaded = false;
    private List<LifecycleListener> plugins = new CopyOnWriteArrayList<LifecycleListener>();
    protected boolean generateCode = false;
    protected File generatedCodeLocation = null;
    protected String generatedCodeLocationParameter = null;
    protected String generatedCodePackage = "apusicembedded";
    protected boolean useGeneratedCode = false;
    private static Set<String> cacheAmsTypesSet = new HashSet<String>(){
        {
            this.add("resource");
            this.add("container");
            this.add("service");
            this.add("server");
            this.add("valve");
            this.add("application");
            this.add("endpoint");
            this.add("executor");
            this.add("listener");
            this.add("host");
        }
    };
    private static final Log log = LogFactory.getLog(Apusic.class);

    public Apusic() {
        this.setSecurityProtection();
        ExceptionUtils.preload();
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public boolean getGenerateCode() {
        return this.generateCode;
    }

    public void setGenerateCode(boolean generateCode) {
        this.generateCode = generateCode;
    }

    public boolean getUseGeneratedCode() {
        return this.useGeneratedCode;
    }

    public void setUseGeneratedCode(boolean useGeneratedCode) {
        this.useGeneratedCode = useGeneratedCode;
    }

    public File getGeneratedCodeLocation() {
        return this.generatedCodeLocation;
    }

    public void setGeneratedCodeLocation(File generatedCodeLocation) {
        this.generatedCodeLocation = generatedCodeLocation;
    }

    public String getGeneratedCodePackage() {
        return this.generatedCodePackage;
    }

    public void setGeneratedCodePackage(String generatedCodePackage) {
        this.generatedCodePackage = generatedCodePackage;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public void setAwait(boolean b) {
        this.await = b;
    }

    public boolean isAwait() {
        return this.await;
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        boolean isGenerateCode = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (String arg : args) {
            if (isConfig) {
                this.configFile = arg;
                isConfig = false;
                continue;
            }
            if (arg.equals("-config")) {
                isConfig = true;
                continue;
            }
            if (arg.equals("-generateCode")) {
                this.setGenerateCode(true);
                isGenerateCode = true;
                continue;
            }
            if (arg.equals("-useGeneratedCode")) {
                this.setUseGeneratedCode(true);
                isGenerateCode = false;
                continue;
            }
            if (arg.equals("-nonaming")) {
                this.setUseNaming(false);
                isGenerateCode = false;
                continue;
            }
            if (arg.equals("-help")) {
                this.usage();
                return false;
            }
            if (arg.equals("start")) {
                isGenerateCode = false;
                continue;
            }
            if (arg.equals("configtest")) {
                isGenerateCode = false;
                continue;
            }
            if (arg.equals("stop")) {
                isGenerateCode = false;
                continue;
            }
            if (isGenerateCode) {
                this.generatedCodeLocationParameter = arg;
                isGenerateCode = false;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(Bootstrap.getApusicBase(), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> objectAttrs = new ArrayList<String>();
        objectAttrs.add("className");
        fakeAttributes.put(Object.class, objectAttrs);
        ArrayList<String> contextAttrs = new ArrayList<String>();
        contextAttrs.add("source");
        fakeAttributes.put(StandardContext.class, contextAttrs);
        ArrayList<String> connectorAttrs = new ArrayList<String>();
        connectorAttrs.add("portOffset");
        fakeAttributes.put(Connector.class, connectorAttrs);
        digester.setFakeAttributes(fakeAttributes);
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "com.apusic.ams.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "com.apusic.ams.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "com.apusic.ams.deploy.NamingResourcesImpl");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "com.apusic.ams.deploy.NamingResourcesImpl");
        digester.addRule("Server/Listener", new ListenerCreateRule(null, "className"));
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "com.apusic.ams.LifecycleListener");
        digester.addObjectCreate("Server/Service", "com.apusic.ams.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "com.apusic.ams.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "com.apusic.ams.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "com.apusic.ams.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "com.apusic.ams.Executor");
        digester.addRule("Server/Service/Connector", new ConnectorCreateRule());
        digester.addSetProperties("Server/Service/Connector", new String[]{"executor", "sslImplementationName", "protocol"});
        digester.addSetNext("Server/Service/Connector", "addConnector", "com.apusic.ams.connector.Connector");
        digester.addRule("Server/Service/Connector", new AddPortOffsetRule());
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig", "com.apusic.aas.util.net.SSLHostConfig");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig", "addSslHostConfig", "com.apusic.aas.util.net.SSLHostConfig");
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", new CertificateCreateRule());
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/Certificate", new String[]{"type"});
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/Certificate", "addCertificate", "com.apusic.aas.util.net.SSLHostConfigCertificate");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "com.apusic.aas.util.net.openssl.OpenSSLConf");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "setOpenSslConf", "com.apusic.aas.util.net.openssl.OpenSSLConf");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "com.apusic.aas.util.net.openssl.OpenSSLConfCmd");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "addCmd", "com.apusic.aas.util.net.openssl.OpenSSLConfCmd");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "com.apusic.ams.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector/UpgradeProtocol", null, "className");
        digester.addSetProperties("Server/Service/Connector/UpgradeProtocol");
        digester.addSetNext("Server/Service/Connector/UpgradeProtocol", "addUpgradeProtocol", "com.apusic.connector.UpgradeProtocol");
        digester.addRuleSet(new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet(new EngineRuleSet("Server/Service/"));
        digester.addRuleSet(new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Host/"));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Host/Cluster/");
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", new SetParentClassLoaderRule(this.parentClassLoader));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Cluster/");
        return digester;
    }

    private void addClusterRuleSet(Digester digester, String prefix) {
        block3: {
            Class<?> clazz = null;
            Constructor<?> constructor = null;
            try {
                clazz = Class.forName("com.apusic.ams.ha.ClusterRuleSet");
                constructor = clazz.getConstructor(String.class);
                RuleSet ruleSet = (RuleSet)constructor.newInstance(prefix);
                digester.addRuleSet(ruleSet);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("apusic.noCluster", e.getClass().getName() + ": " + e.getMessage()), e);
                }
                if (!log.isInfoEnabled()) break block3;
                log.info(sm.getString("apusic.noCluster", e.getClass().getName() + ": " + e.getMessage()));
            }
        }
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("config/containers/container", "com.apusic.ams.core.StandardServer", "className");
        digester.addSetProperties("config/containers/container");
        digester.addSetNext("config/containers/container", "setServer", "com.apusic.ams.Server");
        return digester;
    }

    protected void parseServerXml(boolean start) {
        block41: {
            ConfigFileLoader.setSource(new ApusicBaseConfigurationSource(Bootstrap.getApusicBaseFile(), this.getConfigFile()));
            File file = this.configFile();
            if (this.useGeneratedCode && !Digester.isGeneratedCodeLoaderSet()) {
                String loaderClassName = this.generatedCodePackage + ".DigesterGeneratedCodeLoader";
                try {
                    Digester.GeneratedCodeLoader loader = (Digester.GeneratedCodeLoader)Apusic.class.getClassLoader().loadClass(loaderClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Digester.setGeneratedCodeLoader(loader);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.info(sm.getString("apusic.noLoader", loaderClassName), e);
                    } else {
                        log.info(sm.getString("apusic.noLoader", loaderClassName));
                    }
                    this.useGeneratedCode = false;
                }
            }
            File serverXmlLocation = null;
            String xmlClassName = null;
            if (this.generateCode || this.useGeneratedCode) {
                String string = xmlClassName = start ? this.generatedCodePackage + ".ServerXml" : this.generatedCodePackage + ".ServerXmlStop";
            }
            if (this.generateCode) {
                if (this.generatedCodeLocationParameter != null) {
                    this.generatedCodeLocation = new File(this.generatedCodeLocationParameter);
                    if (!this.generatedCodeLocation.isAbsolute()) {
                        this.generatedCodeLocation = new File(Bootstrap.getApusicHomeFile(), this.generatedCodeLocationParameter);
                    }
                } else {
                    this.generatedCodeLocation = new File(Bootstrap.getApusicHomeFile(), "work");
                }
                if (!(serverXmlLocation = new File(this.generatedCodeLocation, this.generatedCodePackage)).isDirectory() && !serverXmlLocation.mkdirs()) {
                    log.warn(sm.getString("apusic.generatedCodeLocationError", this.generatedCodeLocation.getAbsolutePath()));
                    this.generateCode = false;
                }
            }
            ServerXml serverXml = null;
            if (this.useGeneratedCode) {
                serverXml = (ServerXml)Digester.loadGeneratedClass(xmlClassName);
            }
            if (serverXml != null) {
                serverXml.load(this);
            } else {
                try (ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getServerXml();){
                    Digester digester = start ? this.createStartDigester() : this.createStopDigester();
                    InputStream inputStream = Apusic.amsConfigToApusicConfig(file);
                    InputSource inputSource = new InputSource(resource.getURI().toURL().toString());
                    inputSource.setByteStream(inputStream);
                    digester.push(this);
                    if (this.generateCode) {
                        digester.startGeneratingCode();
                        this.generateClassHeader(digester, start);
                    }
                    digester.parse(inputSource);
                    if (!this.generateCode) break block41;
                    this.generateClassFooter(digester);
                    try (FileWriter writer = new FileWriter(new File(serverXmlLocation, start ? "ServerXml.java" : "ServerXmlStop.java"));){
                        writer.write(digester.getGeneratedCode().toString());
                    }
                    digester.endGeneratingCode();
                    Digester.addGeneratedClass(xmlClassName);
                }
                catch (Exception e) {
                    log.warn(sm.getString("apusic.configFail", file.getAbsolutePath()), e);
                    if (!file.exists() || file.canRead()) break block41;
                    log.warn(sm.getString("apusic.incorrectPermissions"));
                }
            }
        }
    }

    public void stopServer() {
        this.stopServer(null);
    }

    public void stopServer(String[] arguments) {
        Server s;
        if (arguments != null) {
            this.arguments(arguments);
        }
        if ((s = this.getServer()) == null) {
            this.parseServerXml(false);
            if (this.getServer() == null) {
                log.error(sm.getString("apusic.stopError"));
                System.exit(1);
            }
        } else {
            try {
                s.stop();
                s.destroy();
            }
            catch (LifecycleException e) {
                log.error(sm.getString("apusic.stopError"), e);
            }
            return;
        }
        s = this.getServer();
        if (s.getPortWithOffset() > 0) {
            try (Socket socket = new Socket(s.getAddress(), s.getPortWithOffset());
                 OutputStream stream = socket.getOutputStream();){
                String shutdown = s.getShutdown();
                for (int i = 0; i < shutdown.length(); ++i) {
                    stream.write(shutdown.charAt(i));
                }
                stream.flush();
            }
            catch (ConnectException ce) {
                log.error(sm.getString("apusic.stopServer.connectException", s.getAddress(), String.valueOf(s.getPortWithOffset()), String.valueOf(s.getPort()), String.valueOf(s.getPortOffset())));
                log.error(sm.getString("apusic.stopError"), ce);
                System.exit(1);
            }
            catch (IOException e) {
                log.error(sm.getString("apusic.stopError"), e);
                System.exit(1);
            }
        } else {
            log.error(sm.getString("apusic.stopServer"));
            System.exit(1);
        }
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        long t1 = System.nanoTime();
        this.initDirs();
        this.initNaming();
        this.loadApusicPlugins();
        this.addRedisSessionConfig();
        this.triggerApusicPluginListener();
        this.parseServerXml(true);
        Server s = this.getServer();
        if (s == null) {
            return;
        }
        this.getServer().setApusic(this);
        this.getServer().setApusicHome(Bootstrap.getApusicHomeFile());
        this.getServer().setApusicBase(Bootstrap.getApusicBaseFile());
        this.initStreams();
        try {
            this.getServer().init();
        }
        catch (LifecycleException e) {
            if (Boolean.getBoolean("com.apusic.ams.startup.EXIT_ON_INIT_FAILURE")) {
                throw new Error(e);
            }
            log.error(sm.getString("apusic.initError"), e);
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("apusic.init", Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t1))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRedisSessionConfig() {
        String redis_session_enable = System.getProperty("AAMS_SESSION_REDIS_ENABLE", System.getenv("AAMS_SESSION_REDIS_ENABLE"));
        if (redis_session_enable != null && redis_session_enable.length() > 0 && redis_session_enable.equalsIgnoreCase("true")) {
            boolean hasRedisSessionValve = false;
            String contextFilePath = Utils.getApusicHome() + File.separator + "conf/context.xml";
            File contextFile = new File(contextFilePath);
            FileOutputStream out = null;
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(contextFile);
                Element root = document.getDocumentElement();
                NodeList nodeList = root.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    if (node.getNodeName().equals("Valve") && ((Element)node).getAttribute("className").equals("com.apusic.ams.session.redissessions.RedisSessionHandlerValve")) {
                        hasRedisSessionValve = true;
                        continue;
                    }
                    if (!node.getNodeName().equals("Manager")) continue;
                    Node prevElem = node.getPreviousSibling();
                    if (prevElem != null && prevElem.getNodeType() == 3 && prevElem.getNodeValue().trim().length() == 0) {
                        node.getParentNode().removeChild(prevElem);
                    }
                    root.removeChild(node);
                }
                if (!hasRedisSessionValve) {
                    Element ValveNode = document.createElement("Valve");
                    ValveNode.setAttribute("className", "com.apusic.ams.session.redissessions.RedisSessionHandlerValve");
                    root.appendChild(ValveNode);
                }
                Element ManagerNode = document.createElement("Manager");
                ManagerNode.setAttribute("className", "com.apusic.ams.session.redissessions.RedisSessionManager");
                this.addManagerConfig(ManagerNode);
                root.appendChild(ManagerNode);
                out = new FileOutputStream(contextFilePath);
                DOMSource source = new DOMSource(document);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
                transformer.transform(source, new StreamResult(out));
            }
            catch (Exception e) {
                log.warn(sm.getString("apusic.configFail", contextFile.getAbsolutePath()), e);
                if (contextFile.exists() && !contextFile.canRead()) {
                    log.warn(sm.getString("apusic.incorrectPermissions"));
                }
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void addManagerConfig(Element managerNode) {
        Map<String, String> envProperty = System.getenv();
        for (String propertyName : envProperty.keySet()) {
            if (!propertyName.startsWith("AAMS_SESSION_REDIS_") || propertyName.equals("AAMS_SESSION_REDIS_ENABLE")) continue;
            String systemValue = System.getProperty(propertyName, System.getenv(propertyName));
            String param = propertyName.substring("AAMS_SESSION_REDIS_".length());
            managerNode.setAttribute(Utils.lineToHump((String)param), systemValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadApusicPlugins() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(false);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> objectAttrs = new ArrayList<String>();
        objectAttrs.add("className");
        fakeAttributes.put(Object.class, objectAttrs);
        digester.push(this);
        digester.setFakeAttributes(fakeAttributes);
        digester.setUseContextClassLoader(true);
        digester.addRule("config/plugins/plugin", new ListenerCreateRule(null, "className"));
        digester.addSetProperties("config/plugins/plugin");
        digester.addSetNext("config/plugins/plugin", "addApusicPluginListener", "com.apusic.ams.LifecycleListener");
        FileInputStream inputStream = null;
        File file = this.configFile();
        try {
            inputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(inputStream);
            digester.parse(inputSource);
        }
        catch (Exception e) {
            log.warn(sm.getString("apusic.configFail", file.getAbsolutePath()), e);
            if (file.exists() && !file.canRead()) {
                log.warn(sm.getString("apusic.incorrectPermissions"));
            }
            return;
        }
        finally {
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addApusicPluginListener(LifecycleListener listener) {
        this.plugins.add(listener);
    }

    public void triggerApusicPluginListener() {
        for (LifecycleListener listener : this.plugins) {
            listener.lifecycleEvent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream amsConfigToApusicConfig(File file) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Map<String, AmsConfigBean> all = Apusic.amsConfigToMap(file);
        Document newDocument = builder.newDocument();
        Apusic.createServerElement(all, newDocument);
        DOMSource source = new DOMSource(newDocument);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        File aasConfigFile = new File(file.getParentFile(), SERVER_XML_TMP);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(aasConfigFile);
            transformer.transform(source, new StreamResult(out));
        }
        catch (Exception e) {
            log.error("write file error!", e);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new ByteArrayInputStream(writer.getBuffer().toString().getBytes("UTF-8"));
    }

    public static Map<String, AmsConfigBean> amsConfigToMap(File file) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(file);
        Element root = document.getDocumentElement();
        NodeList nodeList = root.getChildNodes();
        HashMap<String, AmsConfigBean> all = new HashMap<String, AmsConfigBean>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NodeList childNodeList = node.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Node childNode = childNodeList.item(j);
                if (childNode.getNodeType() != 1 || !cacheAmsTypesSet.contains(childNode.getNodeName())) continue;
                Node name = childNode.getAttributes().getNamedItem("name");
                if (name == null || "".equals(name.getNodeValue().trim())) {
                    throw new IllegalArgumentException("parse apusic.conf error: element \"" + node.getNodeName() + "\" must has the name attribute");
                }
                if (all.containsKey(name.getNodeValue())) {
                    throw new IllegalArgumentException("parse apusic.conf error: element \"" + node.getNodeName() + "\"  the name attribute \"" + name.getNodeValue() + "\" must be unique!");
                }
                AmsConfigBean bean = null;
                String elementName = childNode.getNodeName();
                bean = elementName.equals("endpoint") ? Apusic.convertEndpointToBean(null, childNodeList.item(j), name.getNodeValue()) : (elementName.equals("service") ? Apusic.convertServiceToBean(null, childNodeList.item(j), name.getNodeValue()) : Apusic.nodeConvertToBean(null, childNodeList.item(j), name.getNodeValue()));
                all.put(bean.getName(), bean);
            }
        }
        return all;
    }

    public String getJMXPort() {
        try {
            Map<String, AmsConfigBean> map = Apusic.amsConfigToMap(new File(Utils.getServerRoot(), SERVER_XML));
            AmsConfigBean bean = map.get("ams-jmx");
            if (bean != null) {
                return bean.getAttributes().get("port");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getHTTPPort() {
        try {
            Map<String, AmsConfigBean> map = Apusic.amsConfigToMap(new File(Utils.getServerRoot(), SERVER_XML));
            AmsConfigBean bean = map.get("ams-http");
            if (bean != null) {
                return bean.getAttributes().get("port");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static AmsConfigBean convertServiceToBean(AmsConfigBean parent, Node node, String name) {
        AmsConfigBean bean = Apusic.nodeConvertToBean(parent, node, name);
        NodeList childNodeList = node.getChildNodes();
        for (int j = 0; j < childNodeList.getLength(); ++j) {
            Node childNode = childNodeList.item(j);
            if (childNode.getNodeType() != 1) continue;
            if ("host".equals(childNode.getNodeName())) {
                bean.addAmsConfigBean(Apusic.convertHostToBean(bean, childNode, childNode.getNodeName()));
                continue;
            }
            if ("realm".equals(childNode.getNodeName())) {
                bean.addAmsConfigBean(Apusic.convertRealmToBean(bean, childNode, childNode.getNodeName()));
                continue;
            }
            if (!"Cluster".equals(childNode.getNodeName())) continue;
            bean.addAmsConfigBean(Apusic.convertHostToBean(bean, childNode, childNode.getNodeName()));
        }
        return bean;
    }

    private static AmsConfigBean convertRealmToBean(AmsConfigBean parent, Node node, String name) {
        AmsConfigBean bean = Apusic.nodeConvertToBean(parent, node, name);
        NodeList childNodeList = node.getChildNodes();
        for (int j = 0; j < childNodeList.getLength(); ++j) {
            Node childNode = childNodeList.item(j);
            if (childNode.getNodeType() != 1) continue;
            bean.addAmsConfigBean(Apusic.nodeConvertToBean(bean, childNode, childNode.getNodeName()));
        }
        return bean;
    }

    private static AmsConfigBean convertHostToBean(AmsConfigBean parent, Node node, String name) {
        AmsConfigBean bean = Apusic.nodeConvertToBean(parent, node, name);
        NodeList childNodeList = node.getChildNodes();
        for (int j = 0; j < childNodeList.getLength(); ++j) {
            AmsConfigBean amsBean;
            Node childNode = childNodeList.item(j);
            if (childNode.getNodeType() == 1 && !"Cluster".equals(childNode.getNodeName())) {
                amsBean = Apusic.nodeConvertToBean(bean, childNode, childNode.getNodeName());
                bean.addAmsConfigBean(amsBean);
                Apusic.recursiveConvertNodeToBean(amsBean, childNode);
                continue;
            }
            if (childNode.getNodeType() != 1 || !"Cluster".equals(childNode.getNodeName())) continue;
            amsBean = Apusic.nodeConvertToBean(bean, childNode, childNode.getNodeName());
            bean.addAmsConfigBean(amsBean);
            Apusic.recursiveConvertNodeToBean(amsBean, childNode);
        }
        return bean;
    }

    private static void recursiveConvertNodeToBean(AmsConfigBean parent, Node node) {
        NodeList childNodeList = node.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            AmsConfigBean bean = Apusic.nodeConvertToBean(parent, childNode, childNode.getNodeName());
            parent.addAmsConfigBean(bean);
            Apusic.recursiveConvertNodeToBean(bean, childNode);
        }
    }

    private static AmsConfigBean convertEndpointToBean(AmsConfigBean parent, Node node, String name) {
        AmsConfigBean bean = Apusic.nodeConvertToBean(parent, node, name);
        Apusic.recursiveConvertNodeToBean(bean, node);
        return bean;
    }

    private static void createServerElement(Map<String, AmsConfigBean> map, Document document) {
        AmsConfigBean bean = Apusic.getAmsBeanByType(map, "container");
        Element element = document.createElement("Server");
        Apusic.fillAttributes(bean, element, "servers,name,listeners,resources");
        String reference = bean.getAttributes().get("listeners");
        Apusic.createListenElement(element, map, document, reference);
        reference = bean.getAttributes().get("resources");
        Apusic.createGlobalNamingResourcesElement(element, map, document, reference);
        reference = bean.getAttributes().get("servers");
        Apusic.createServiceElement(element, map, document, reference);
        document.appendChild(element);
    }

    private static void createListenElement(Element parent, Map<String, AmsConfigBean> map, Document document, String reference) {
        if (null != reference) {
            for (String name : reference.split(",")) {
                AmsConfigBean bean = map.get(name);
                if (null == bean) {
                    throw new IllegalArgumentException("parse apusic.conf error: could not found listener \"" + name + "\"");
                }
                Element element = document.createElement("Listener");
                Apusic.fillAttributes(bean, element, "name");
                parent.appendChild(element);
            }
        }
    }

    private static void createServiceElement(Element parent, Map<String, AmsConfigBean> map, Document document, String reference) {
        if (null != reference) {
            for (String name : reference.split(",")) {
                AmsConfigBean bean = map.get(name);
                if (null == bean) {
                    throw new IllegalArgumentException("parse apusic.conf error: could not found server \"" + name + "\"");
                }
                Element element = document.createElement("Service");
                Apusic.fillAttributes(bean, element, "services,endpoints,executors,listeners");
                parent.appendChild(element);
                String ref = bean.getAttributes().get("executors");
                Apusic.createExecutorElement(element, map, document, ref);
                ref = bean.getAttributes().get("endpoints");
                Apusic.createConnectorElement(element, map, document, ref);
                ref = bean.getAttributes().get("services");
                Apusic.createEngineElement(element, map, document, ref);
                ref = bean.getAttributes().get("listeners");
                Apusic.createListenElement(element, map, document, ref);
            }
        }
    }

    private static void createEngineElement(Element parent, Map<String, AmsConfigBean> map, Document document, String reference) {
        if (null != reference) {
            for (String name : reference.split(",")) {
                AmsConfigBean bean = map.get(name);
                if (null == bean) {
                    throw new IllegalArgumentException("parse apusic.conf error: could not found service \"" + name + "\"");
                }
                Element element = document.createElement("Engine");
                Apusic.fillAttributes(bean, element, null);
                parent.appendChild(element);
                Apusic.createRealmElement(element, bean, document);
                Apusic.createHostElement(element, bean, document);
                Apusic.createClusterElement(element, bean, document);
            }
        }
    }

    private static void createRealmElement(Element parent, AmsConfigBean bean, Document document) {
        if (null != bean) {
            for (AmsConfigBean ams : bean.getChildrenList()) {
                if (!"realm".equals(ams.getType())) continue;
                Element element = document.createElement("Realm");
                Apusic.fillAttributes(ams, element, null);
                parent.appendChild(element);
                for (AmsConfigBean ab : ams.getChildrenList()) {
                    if (!"realm".equals(ab.getType())) continue;
                    Element ele = document.createElement("Realm");
                    Apusic.fillAttributes(ab, ele, null);
                    element.appendChild(ele);
                }
            }
        }
    }

    private static void createHostElement(Element parent, AmsConfigBean bean, Document document) {
        if (null != bean) {
            for (AmsConfigBean ams : bean.getChildrenList()) {
                if (!"host".equals(ams.getType())) continue;
                Element element = document.createElement("Host");
                Apusic.fillAttributes(ams, element, null);
                parent.appendChild(element);
                Apusic.createValveElement(element, ams, document);
                Apusic.createContextElement(element, ams, document);
                Apusic.createClusterElement(element, ams, document);
            }
        }
    }

    private static void createContextElement(Element parent, AmsConfigBean bean, Document document) {
        if (null != bean) {
            for (AmsConfigBean child : bean.getChildrenList()) {
                if (!"application".equals(child.getType())) continue;
                Element element = document.createElement("Context");
                Apusic.fillAttributes(child, element, null);
                parent.appendChild(element);
                Apusic.recursiveConvertBeanToNode(element, child, document);
            }
        }
    }

    private static void createClusterElement(Element parent, AmsConfigBean bean, Document document) {
        if (null != bean) {
            for (AmsConfigBean child : bean.getChildrenList()) {
                if (!"Cluster".equals(child.getType())) continue;
                Element element = document.createElement("Cluster");
                Apusic.fillAttributes(child, element, null);
                parent.appendChild(element);
                Apusic.recursiveConvertBeanToNode(element, child, document);
            }
        }
    }

    private static void recursiveConvertBeanToNode(Element parent, AmsConfigBean bean, Document document) {
        List<AmsConfigBean> list = bean.getChildrenList();
        for (int i = 0; i < list.size(); ++i) {
            AmsConfigBean ab = list.get(i);
            Element element = document.createElement(ab.getType());
            Apusic.fillAttributes(ab, element, null);
            parent.appendChild(element);
            Apusic.recursiveConvertBeanToNode(element, ab, document);
        }
    }

    private static void createValveElement(Element parent, AmsConfigBean bean, Document document) {
        if (null != bean) {
            for (AmsConfigBean child : bean.getChildrenList()) {
                if (!"valve".equalsIgnoreCase(child.getType())) continue;
                Element element = document.createElement("Valve");
                Apusic.fillAttributes(child, element, null);
                parent.appendChild(element);
            }
        }
    }

    private static void createConnectorElement(Element parent, Map<String, AmsConfigBean> map, Document document, String reference) {
        if (null != reference) {
            for (String name : reference.split(",")) {
                AmsConfigBean bean = map.get(name);
                if (null == bean) {
                    throw new IllegalArgumentException("parse apusic.conf error: could not found endpoint \"" + name + "\"");
                }
                Element element = document.createElement("Connector");
                Apusic.fillAttributes(bean, element, null);
                parent.appendChild(element);
                String ref = bean.getAttributes().get("listeners");
                Apusic.createListenElement(element, map, document, ref);
                Apusic.recursiveConvertBeanToNode(element, bean, document);
            }
        }
    }

    private static void createExecutorElement(Element parent, Map<String, AmsConfigBean> map, Document document, String reference) {
        if (null != reference) {
            for (String name : reference.split(",")) {
                AmsConfigBean bean = map.get(name);
                if (null == bean) {
                    throw new IllegalArgumentException("parse apusic.conf error: could not found excutor \"" + name + "\"");
                }
                Element element = document.createElement("Executor");
                Apusic.fillAttributes(bean, element, null);
                parent.appendChild(element);
            }
        }
    }

    private static void createGlobalNamingResourcesElement(Element parent, Map<String, AmsConfigBean> map, Document document, String reference) {
        if (null != reference) {
            Element globalNamingResources = document.createElement("GlobalNamingResources");
            parent.appendChild(globalNamingResources);
            for (String name : reference.split(",")) {
                AmsConfigBean bean = map.get(name);
                if (null == bean) {
                    throw new IllegalArgumentException("parse apusic.conf error: could not found server \"" + name + "\"");
                }
                Element element = document.createElement("Resource");
                Apusic.fillAttributes(bean, element, null);
                globalNamingResources.appendChild(element);
            }
        }
    }

    private static void fillAttributes(AmsConfigBean bean, Element element, String excludes) {
        for (String key : bean.getAttributes().keySet()) {
            if (null != excludes) {
                if (excludes.contains(",")) {
                    boolean exclude = false;
                    for (String data : excludes.split(",")) {
                        if (!data.trim().equals(key)) continue;
                        exclude = true;
                        break;
                    }
                    if (exclude) {
                        continue;
                    }
                } else if (excludes.equals(key)) continue;
            }
            element.setAttribute(key, bean.getAttributes().get(key));
        }
    }

    private static AmsConfigBean getAmsBeanByType(Map<String, AmsConfigBean> map, String type) {
        for (Map.Entry<String, AmsConfigBean> entry : map.entrySet()) {
            if (!entry.getValue().getType().equals(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static AmsConfigBean nodeConvertToBean(AmsConfigBean parent, Node node, String name) {
        AmsConfigBean bean = new AmsConfigBean(name, node.getNodeName(), parent);
        NamedNodeMap nodeMap = node.getAttributes();
        if (null != nodeMap && nodeMap.getLength() > 0) {
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node attribute = nodeMap.item(i);
                bean.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        return bean;
    }

    private static AmsConfigBean getApusicConfigurationBean(File file) throws Exception {
        AmsConfigBean bean = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(file);
            Element root = document.getDocumentElement();
            bean = new AmsConfigBean("config", "config", null);
            Apusic.recursiveConvertNodeToBean(bean, root);
        }
        catch (Exception e) {
            log.error("parse file error!", e);
            throw e;
        }
        return bean;
    }

    private static void saveApusicConfigurationBean(AmsConfigBean bean, File file) throws Exception {
        FileOutputStream out = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element parent = document.createElement("config");
            Apusic.fillAttributes(bean, parent, null);
            Apusic.recursiveConvertBeanToNode(parent, bean, document);
            document.appendChild(parent);
            DOMSource source = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            out = new FileOutputStream(file);
            transformer.transform(source, new StreamResult(out));
        }
        catch (Exception e) {
            log.error("write file error!", e);
            throw e;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void updateApusicConfiguration(Map<String, String> params, File file) {
        try {
            if (null != params) {
                AmsConfigBean root = Apusic.getApusicConfigurationBean(file);
                for (String key : params.keySet()) {
                    AmsConfigBean config;
                    if (!CLOUD_CONFIG_ITEMS.containsKey(key)) continue;
                    String value = params.get(key);
                    Item<String, String, String> item = CLOUD_CONFIG_ITEMS.get(key);
                    if (value == null) {
                        value = item.getValue();
                    }
                    if (null == (config = root.findByType(item.getType()))) continue;
                    config.getAttributes().put(item.getKey(), value);
                }
                Apusic.saveApusicConfigurationBean(root, file);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void load(String[] args) {
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.getServer() == null) {
            this.load();
        }
        if (this.getServer() == null) {
            log.fatal(sm.getString("apusic.noServer"));
            return;
        }
        long t1 = System.nanoTime();
        try {
            this.getServer().start();
        }
        catch (LifecycleException e) {
            log.fatal(sm.getString("apusic.serverStartFail"), e);
            try {
                this.getServer().destroy();
            }
            catch (LifecycleException e1) {
                log.debug("destroy() failed for failed Server ", e1);
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("apusic.startup", Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t1))));
        }
        if (this.generateCode) {
            this.generateLoader();
        }
        if (this.useShutdownHook) {
            if (this.shutdownHook == null) {
                this.shutdownHook = new ApusicShutdownHook();
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof ClassLoaderLogManager) {
                ((ClassLoaderLogManager)logManager).setUseShutdownHook(false);
            }
        }
        if (this.await) {
            this.await();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                Callable<Boolean> ft = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        Apusic.this.stop();
                        return true;
                    }
                };
                Future<Boolean> f = executor.submit(ft);
                f.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).setUseShutdownHook(true);
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        try {
            Server s = this.getServer();
            LifecycleState state = s.getState();
            if (LifecycleState.STOPPING_PREP.compareTo(state) > 0 || LifecycleState.DESTROYED.compareTo(state) < 0) {
                s.stop();
                s.destroy();
            }
        }
        catch (LifecycleException e) {
            log.error(sm.getString("apusic.stopError"), e);
        }
    }

    public void await() {
        this.getServer().await();
    }

    protected void usage() {
        System.out.println(sm.getString("apusic.usage"));
    }

    @Deprecated
    protected void initDirs() {
    }

    protected void initStreams() {
        System.setOut(new LogPrintStream(SYSTEM_OUT_LOGGER, Level.INFO));
        System.setErr(new LogPrintStream(SYSTEM_ERR_LOGGER, Level.SEVERE));
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.info(sm.getString("apusic.noNaming"));
            System.setProperty("apusic.useNaming", "false");
        } else {
            System.setProperty("apusic.useNaming", "true");
            String value = "com.apusic.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                value = value + ":" + oldValue;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            if (log.isDebugEnabled()) {
                log.debug("Setting naming prefix=" + value);
            }
            if ((value = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "com.apusic.naming.java.javaURLContextFactory");
            } else {
                log.debug("INITIAL_CONTEXT_FACTORY already set " + value);
            }
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }

    protected void generateLoader() {
        String loaderClassName = "DigesterGeneratedCodeLoader";
        StringBuilder code = new StringBuilder();
        code.append("package ").append(this.generatedCodePackage).append(";").append(System.lineSeparator());
        code.append("public class ").append(loaderClassName);
        code.append(" implements com.apusic.aas.util.digester.Digester.GeneratedCodeLoader {").append(System.lineSeparator());
        code.append("public Object loadGeneratedCode(String className) {").append(System.lineSeparator());
        code.append("switch (className) {").append(System.lineSeparator());
        for (String generatedClassName : Digester.getGeneratedClasses()) {
            code.append("case \"").append(generatedClassName).append("\" : return new ").append(generatedClassName);
            code.append("();").append(System.lineSeparator());
        }
        code.append("default: return null; }").append(System.lineSeparator());
        code.append("}}").append(System.lineSeparator());
        File loaderLocation = new File(this.generatedCodeLocation, this.generatedCodePackage);
        try (FileWriter writer = new FileWriter(new File(loaderLocation, loaderClassName + ".java"));){
            writer.write(code.toString());
        }
        catch (IOException e) {
            log.debug("Error writing code loader", e);
        }
    }

    protected void generateClassHeader(Digester digester, boolean start) {
        StringBuilder code = digester.getGeneratedCode();
        code.append("package ").append(this.generatedCodePackage).append(";").append(System.lineSeparator());
        code.append("public class ServerXml");
        if (!start) {
            code.append("Stop");
        }
        code.append(" implements ");
        code.append(ServerXml.class.getName().replace('$', '.')).append(" {").append(System.lineSeparator());
        code.append("public void load(").append(Apusic.class.getName());
        code.append(' ').append(digester.toVariableName(this)).append(") {").append(System.lineSeparator());
    }

    protected void generateClassFooter(Digester digester) {
        StringBuilder code = digester.getGeneratedCode();
        code.append('}').append(System.lineSeparator());
        code.append('}').append(System.lineSeparator());
    }

    final class SetParentClassLoaderRule
    extends Rule {
        ClassLoader parentClassLoader = null;

        public SetParentClassLoaderRule(ClassLoader parentClassLoader) {
            this.parentClassLoader = parentClassLoader;
        }

        @Override
        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            if (this.digester.getLogger().isDebugEnabled()) {
                this.digester.getLogger().debug("Setting parent class loader");
            }
            Container top = (Container)this.digester.peek();
            top.setParentClassLoader(this.parentClassLoader);
            StringBuilder code = this.digester.getGeneratedCode();
            if (code != null) {
                code.append(this.digester.toVariableName(top)).append(".setParentClassLoader(");
                code.append(this.digester.toVariableName(Apusic.this)).append(".getParentClassLoader());");
                code.append(System.lineSeparator());
            }
        }
    }

    protected class ApusicShutdownHook
    extends Thread {
        protected ApusicShutdownHook() {
        }

        @Override
        public void run() {
            try {
                if (Apusic.this.getServer() != null) {
                    Apusic.this.stop();
                }
            }
            catch (Throwable ex) {
                ExceptionUtils.handleThrowable(ex);
                log.error(sm.getString("apusic.shutdownHookFail"), ex);
            }
            finally {
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).shutdown();
                }
            }
        }
    }

    public static interface ServerXml {
        public void load(Apusic var1);
    }
}

