/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.startup;

import com.apusic.ams.startup.Bootstrap;
import com.apusic.juli.logging.Log;
import com.apusic.juli.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class ApusicProperties {
    private static final Log log = LogFactory.getLog(ApusicProperties.class);
    private static Properties properties = null;

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        InputStream is = null;
        String fileName = "apusic.properties";
        try {
            String configUrl = System.getProperty("apusic.config");
            if (configUrl != null) {
                if (configUrl.indexOf(47) == -1) {
                    fileName = configUrl;
                } else {
                    is = new URL(configUrl).openStream();
                }
            }
        }
        catch (Throwable t) {
            ApusicProperties.handleThrowable(t);
        }
        if (is == null) {
            try {
                File home = new File(Bootstrap.getApusicBase());
                File conf = new File(home, "conf");
                File propsFile = new File(conf, fileName);
                is = new FileInputStream(propsFile);
            }
            catch (Throwable t) {
                ApusicProperties.handleThrowable(t);
            }
        }
        if (is == null) {
            try {
                is = ApusicProperties.class.getResourceAsStream("/com/apusic/ams/startup/apusic.properties");
            }
            catch (Throwable t) {
                ApusicProperties.handleThrowable(t);
            }
        }
        if (is != null) {
            try {
                properties = new Properties();
                properties.load(is);
            }
            catch (Throwable t) {
                ApusicProperties.handleThrowable(t);
                log.warn(t);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    log.warn("Could not close apusic properties file", ioe);
                }
            }
        }
        if (is == null) {
            log.warn("Failed to load apusic properties file");
            properties = new Properties();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            System.setProperty(name, value);
        }
    }

    private static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }

    static {
        ApusicProperties.loadProperties();
    }
}

