/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.users;

import com.apusic.aas.util.buf.StringUtils;
import com.apusic.aas.util.security.Escape;
import com.apusic.ams.users.GenericUser;
import com.apusic.ams.users.MemoryUserDatabase;

public class MemoryUser
extends GenericUser<MemoryUserDatabase> {
    MemoryUser(MemoryUserDatabase database, String username, String password, String fullName) {
        super(database, username, password, fullName, null, null);
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder("<user username=\"");
        sb.append(Escape.xml(this.username));
        sb.append("\" password=\"");
        sb.append(Escape.xml(this.password));
        sb.append("\"");
        if (this.fullName != null) {
            sb.append(" fullName=\"");
            sb.append(Escape.xml(this.fullName));
            sb.append("\"");
        }
        sb.append(" groups=\"");
        StringUtils.join(this.groups, ',', x -> Escape.xml(x.getGroupname()), sb);
        sb.append("\"");
        sb.append(" roles=\"");
        StringUtils.join(this.roles, ',', x -> Escape.xml(x.getRolename()), sb);
        sb.append("\"");
        sb.append("/>");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("User username=\"");
        sb.append(Escape.xml(this.username));
        sb.append("\"");
        if (this.fullName != null) {
            sb.append(", fullName=\"");
            sb.append(Escape.xml(this.fullName));
            sb.append("\"");
        }
        sb.append(", groups=\"");
        StringUtils.join(this.groups, ',', x -> Escape.xml(x.getGroupname()), sb);
        sb.append("\"");
        sb.append(", roles=\"");
        StringUtils.join(this.roles, ',', x -> Escape.xml(x.getRolename()), sb);
        sb.append("\"");
        return sb.toString();
    }
}

