/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.util;

import com.apusic.aas.util.ExceptionUtils;
import com.apusic.aas.util.compat.JreCompat;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class CharsetMapper {
    public static final String DEFAULT_RESOURCE = "/com/apusic/ams/util/CharsetMapperDefault.properties";
    private Properties map = new Properties();

    public CharsetMapper() {
        this(DEFAULT_RESOURCE);
    }

    public CharsetMapper(String name) {
        if (JreCompat.isGraalAvailable()) {
            this.map.put("en", "ISO-8859-1");
        } else {
            try (InputStream stream = this.getClass().getResourceAsStream(name);){
                this.map.load(stream);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                throw new IllegalArgumentException(t);
            }
        }
    }

    public String getCharset(Locale locale) {
        String charset = this.map.getProperty(locale.toString());
        if (charset == null && (charset = this.map.getProperty(locale.getLanguage() + "_" + locale.getCountry())) == null) {
            charset = this.map.getProperty(locale.getLanguage());
        }
        return charset;
    }

    public void addCharsetMappingFromDeploymentDescriptor(String locale, String charset) {
        this.map.put(locale, charset);
    }
}

