/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.ams.valves;

import com.apusic.aas.util.buf.MessageBytes;
import com.apusic.ams.Container;
import com.apusic.ams.Context;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.connector.Request;
import com.apusic.ams.connector.Response;
import com.apusic.ams.util.LifecycleBase;
import com.apusic.ams.valves.ValveBase;
import java.io.IOException;
import javax.servlet.ServletException;

public class HealthCheckValve
extends ValveBase {
    private static final String UP = "{\n  \"status\": \"UP\",\n  \"checks\": []\n}";
    private static final String DOWN = "{\n  \"status\": \"DOWN\",\n  \"checks\": []\n}";
    private String path = "/health";
    protected boolean context = false;
    protected boolean checkContainersAvailable = true;

    public HealthCheckValve() {
        super(true);
    }

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        this.path = path;
    }

    public boolean getCheckContainersAvailable() {
        return this.checkContainersAvailable;
    }

    public void setCheckContainersAvailable(boolean checkContainersAvailable) {
        this.checkContainersAvailable = checkContainersAvailable;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        this.context = this.getContainer() instanceof Context;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        MessageBytes urlMB;
        MessageBytes messageBytes = urlMB = this.context ? request.getRequestPathMB() : request.getDecodedRequestURIMB();
        if (urlMB.equals(this.path)) {
            response.setContentType("application/json");
            if (!this.checkContainersAvailable || this.isAvailable(this.getContainer())) {
                response.getOutputStream().print(UP);
            } else {
                response.setStatus(503);
                response.getOutputStream().print(DOWN);
            }
        } else {
            this.getNext().invoke(request, response);
        }
    }

    protected boolean isAvailable(Container container) {
        for (Container child : container.findChildren()) {
            if (this.isAvailable(child)) continue;
            return false;
        }
        if (container instanceof LifecycleBase) {
            return ((LifecycleBase)((Object)container)).getState().isAvailable();
        }
        return true;
    }
}

