/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.connector.ajp;

import com.apusic.aas.util.net.AbstractEndpoint;
import com.apusic.aas.util.net.SSLHostConfig;
import com.apusic.aas.util.net.SocketWrapperBase;
import com.apusic.aas.util.res.StringManager;
import com.apusic.connector.AbstractProtocol;
import com.apusic.connector.Processor;
import com.apusic.connector.UpgradeProtocol;
import com.apusic.connector.UpgradeToken;
import com.apusic.connector.ajp.AjpProcessor;
import java.net.InetAddress;
import java.util.regex.Pattern;

public abstract class AbstractAjpProtocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractAjpProtocol.class);
    private boolean ajpFlush = true;
    private boolean aasAuthentication = true;
    private boolean aasAuthorization = false;
    private String secret = null;
    private boolean secretRequired = true;
    private Pattern allowedRequestAttributesPattern;
    private int packetSize = 8192;

    public AbstractAjpProtocol(AbstractEndpoint<S, ?> endpoint) {
        super(endpoint);
        this.setConnectionTimeout(-1);
        this.getEndpoint().setUseSendfile(false);
        this.getEndpoint().setAddress(InetAddress.getLoopbackAddress());
        AbstractProtocol.ConnectionHandler cHandler = new AbstractProtocol.ConnectionHandler(this);
        this.setHandler(cHandler);
        this.getEndpoint().setHandler(cHandler);
    }

    @Override
    protected String getProtocolName() {
        return "Ajp";
    }

    @Override
    protected AbstractEndpoint<S, ?> getEndpoint() {
        return super.getEndpoint();
    }

    @Override
    protected UpgradeProtocol getNegotiatedProtocol(String name) {
        return null;
    }

    @Override
    protected UpgradeProtocol getUpgradeProtocol(String name) {
        return null;
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean ajpFlush) {
        this.ajpFlush = ajpFlush;
    }

    public boolean getAasAuthentication() {
        return this.aasAuthentication;
    }

    public void setAasAuthentication(boolean aasAuthentication) {
        this.aasAuthentication = aasAuthentication;
    }

    public boolean getAasAuthorization() {
        return this.aasAuthorization;
    }

    public void setAasAuthorization(boolean aasAuthorization) {
        this.aasAuthorization = aasAuthorization;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    protected String getSecret() {
        return this.secret;
    }

    @Deprecated
    public void setRequiredSecret(String requiredSecret) {
        this.setSecret(requiredSecret);
    }

    @Deprecated
    protected String getRequiredSecret() {
        return this.getSecret();
    }

    public void setSecretRequired(boolean secretRequired) {
        this.secretRequired = secretRequired;
    }

    public boolean getSecretRequired() {
        return this.secretRequired;
    }

    public void setAllowedRequestAttributesPattern(String allowedRequestAttributesPattern) {
        this.allowedRequestAttributesPattern = Pattern.compile(allowedRequestAttributesPattern);
    }

    public String getAllowedRequestAttributesPattern() {
        return this.allowedRequestAttributesPattern.pattern();
    }

    protected Pattern getAllowedRequestAttributesPatternInternal() {
        return this.allowedRequestAttributesPattern;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize < 8192 ? 8192 : packetSize;
    }

    @Override
    public int getDesiredBufferSize() {
        return this.getPacketSize() - 8;
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        this.getLog().warn(sm.getString("ajpprotocol.noSSL", sslHostConfig.getHostName()));
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return new SSLHostConfig[0];
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.getLog().warn(sm.getString("ajpprotocol.noUpgrade", upgradeProtocol.getClass().getName()));
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return new UpgradeProtocol[0];
    }

    @Override
    protected Processor createProcessor() {
        AjpProcessor processor = new AjpProcessor(this, this.getAdapter());
        return processor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socket, UpgradeToken upgradeToken) {
        throw new IllegalStateException(sm.getString("ajpprotocol.noUpgradeHandler", upgradeToken.getHttpUpgradeHandler().getClass().getName()));
    }

    @Override
    public void start() throws Exception {
        String secret;
        if (this.getSecretRequired() && ((secret = this.getSecret()) == null || secret.length() == 0)) {
            throw new IllegalArgumentException(sm.getString("ajpprotocol.noSecret"));
        }
        super.start();
    }
}

