/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.connector.http11;

import com.apusic.aas.util.buf.StringUtils;
import com.apusic.aas.util.modeler.Registry;
import com.apusic.aas.util.modeler.Util;
import com.apusic.aas.util.net.AbstractEndpoint;
import com.apusic.aas.util.net.SSLHostConfig;
import com.apusic.aas.util.net.SocketWrapperBase;
import com.apusic.aas.util.res.StringManager;
import com.apusic.com.google.gson.Gson;
import com.apusic.connector.AbstractProtocol;
import com.apusic.connector.CompressionConfig;
import com.apusic.connector.ContinueResponseTiming;
import com.apusic.connector.Processor;
import com.apusic.connector.Request;
import com.apusic.connector.Response;
import com.apusic.connector.UpgradeProtocol;
import com.apusic.connector.UpgradeToken;
import com.apusic.connector.http11.Http11Processor;
import com.apusic.connector.http11.upgrade.InternalHttpUpgradeHandler;
import com.apusic.connector.http11.upgrade.UpgradeGroupInfo;
import com.apusic.connector.http11.upgrade.UpgradeProcessorExternal;
import com.apusic.connector.http11.upgrade.UpgradeProcessorInternal;
import com.apusic.util.CryptUtilAuthData;
import com.apusic.util.MacMain;
import com.apusic.util.RSAUtil;
import com.apusic.util.Utils;
import com.apusic.util.broker.BrokerMgrFac;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpUpgradeHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class AbstractHttp11Protocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractHttp11Protocol.class);
    private final CompressionConfig compressionConfig = new CompressionConfig();
    private ContinueResponseTiming continueResponseTiming = ContinueResponseTiming.IMMEDIATELY;
    private boolean useKeepAliveResponseHeader = true;
    private String relaxedPathChars = null;
    private String relaxedQueryChars = null;
    private boolean allowHostHeaderMismatch = false;
    private boolean rejectIllegalHeader = true;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private int connectionUploadTimeout = 300000;
    private boolean disableUploadTimeout = true;
    private Pattern restrictedUserAgents = null;
    private String server;
    private boolean serverRemoveAppProvidedValues = false;
    private int maxTrailerSize = 8192;
    private int maxExtensionSize = 8192;
    private int maxSwallowSize = 0x200000;
    private boolean secure;
    private Set<String> allowedTrailerHeaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<UpgradeProtocol> upgradeProtocols = new ArrayList<UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> httpUpgradeProtocols = new HashMap<String, UpgradeProtocol>();
    private final Map<String, UpgradeProtocol> negotiatedProtocols = new HashMap<String, UpgradeProtocol>();
    private final Map<String, UpgradeGroupInfo> upgradeProtocolGroupInfos = new ConcurrentHashMap<String, UpgradeGroupInfo>();
    private SSLHostConfig defaultSSLHostConfig = null;

    public AbstractHttp11Protocol(AbstractEndpoint<S, ?> endpoint) {
        super(endpoint);
        this.setConnectionTimeout(60000);
        AbstractProtocol.ConnectionHandler cHandler = new AbstractProtocol.ConnectionHandler(this);
        this.setHandler(cHandler);
        this.getEndpoint().setHandler(cHandler);
    }

    @Override
    public void init() throws Exception {
        for (UpgradeProtocol upgradeProtocol : this.upgradeProtocols) {
            this.configureUpgradeProtocol(upgradeProtocol);
        }
        this.init0();
        super.init();
        for (UpgradeProtocol upgradeProtocol : this.upgradeProtocols) {
            upgradeProtocol.setHttp11Protocol(this);
        }
    }

    @Override
    public void destroy() throws Exception {
        ObjectName rgOname = this.getGlobalRequestProcessorMBeanName();
        if (rgOname != null) {
            Registry registry = Registry.getRegistry(null, null);
            ObjectName query = new ObjectName(rgOname.getCanonicalName() + ",Upgrade=*");
            Set<ObjectInstance> upgrades = registry.getMBeanServer().queryMBeans(query, null);
            for (ObjectInstance upgrade : upgrades) {
                registry.unregisterComponent(upgrade.getObjectName());
            }
        }
        super.destroy();
    }

    @Override
    protected String getProtocolName() {
        return "Http";
    }

    @Override
    protected AbstractEndpoint<S, ?> getEndpoint() {
        return super.getEndpoint();
    }

    public String getContinueResponseTiming() {
        return this.continueResponseTiming.toString();
    }

    public void setContinueResponseTiming(String continueResponseTiming) {
        this.continueResponseTiming = ContinueResponseTiming.fromString(continueResponseTiming);
    }

    public ContinueResponseTiming getContinueResponseTimingInternal() {
        return this.continueResponseTiming;
    }

    public boolean getUseKeepAliveResponseHeader() {
        return this.useKeepAliveResponseHeader;
    }

    public void setUseKeepAliveResponseHeader(boolean useKeepAliveResponseHeader) {
        this.useKeepAliveResponseHeader = useKeepAliveResponseHeader;
    }

    public String getRelaxedPathChars() {
        return this.relaxedPathChars;
    }

    public void setRelaxedPathChars(String relaxedPathChars) {
        this.relaxedPathChars = relaxedPathChars;
    }

    public String getRelaxedQueryChars() {
        return this.relaxedQueryChars;
    }

    public void setRelaxedQueryChars(String relaxedQueryChars) {
        this.relaxedQueryChars = relaxedQueryChars;
    }

    public boolean getAllowHostHeaderMismatch() {
        return this.allowHostHeaderMismatch;
    }

    public void setAllowHostHeaderMismatch(boolean allowHostHeaderMismatch) {
        this.allowHostHeaderMismatch = allowHostHeaderMismatch;
    }

    public boolean getRejectIllegalHeader() {
        return this.rejectIllegalHeader;
    }

    public void setRejectIllegalHeader(boolean rejectIllegalHeader) {
        this.rejectIllegalHeader = rejectIllegalHeader;
    }

    @Deprecated
    public boolean getRejectIllegalHeaderName() {
        return this.rejectIllegalHeader;
    }

    @Deprecated
    public void setRejectIllegalHeaderName(boolean rejectIllegalHeaderName) {
        this.rejectIllegalHeader = rejectIllegalHeaderName;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int timeout) {
        this.connectionUploadTimeout = timeout;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public void setCompression(String compression) {
        this.compressionConfig.setCompression(compression);
    }

    public String getCompression() {
        return this.compressionConfig.getCompression();
    }

    protected int getCompressionLevel() {
        return this.compressionConfig.getCompressionLevel();
    }

    public String getNoCompressionUserAgents() {
        return this.compressionConfig.getNoCompressionUserAgents();
    }

    protected Pattern getNoCompressionUserAgentsPattern() {
        return this.compressionConfig.getNoCompressionUserAgentsPattern();
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.compressionConfig.setNoCompressionUserAgents(noCompressionUserAgents);
    }

    public String getCompressibleMimeType() {
        return this.compressionConfig.getCompressibleMimeType();
    }

    public void setCompressibleMimeType(String valueS) {
        this.compressionConfig.setCompressibleMimeType(valueS);
    }

    public String[] getCompressibleMimeTypes() {
        return this.compressionConfig.getCompressibleMimeTypes();
    }

    public int getCompressionMinSize() {
        return this.compressionConfig.getCompressionMinSize();
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionConfig.setCompressionMinSize(compressionMinSize);
    }

    @Deprecated
    public boolean getNoCompressionStrongETag() {
        return this.compressionConfig.getNoCompressionStrongETag();
    }

    @Deprecated
    public void setNoCompressionStrongETag(boolean noCompressionStrongETag) {
        this.compressionConfig.setNoCompressionStrongETag(noCompressionStrongETag);
    }

    public boolean useCompression(Request request, Response response) {
        return this.compressionConfig.useCompression(request, response);
    }

    public String getRestrictedUserAgents() {
        if (this.restrictedUserAgents == null) {
            return null;
        }
        return this.restrictedUserAgents.toString();
    }

    protected Pattern getRestrictedUserAgentsPattern() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents == null || restrictedUserAgents.length() == 0 ? null : Pattern.compile(restrictedUserAgents);
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean getServerRemoveAppProvidedValues() {
        return this.serverRemoveAppProvidedValues;
    }

    public void setServerRemoveAppProvidedValues(boolean serverRemoveAppProvidedValues) {
        this.serverRemoveAppProvidedValues = serverRemoveAppProvidedValues;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int maxTrailerSize) {
        this.maxTrailerSize = maxTrailerSize;
    }

    public int getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    public void setMaxExtensionSize(int maxExtensionSize) {
        this.maxExtensionSize = maxExtensionSize;
    }

    public int getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(int maxSwallowSize) {
        this.maxSwallowSize = maxSwallowSize;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public void setAllowedTrailerHeaders(String commaSeparatedHeaders) {
        HashSet<String> toRemove = new HashSet<String>(this.allowedTrailerHeaders);
        if (commaSeparatedHeaders != null) {
            String[] headers;
            for (String header : headers = commaSeparatedHeaders.split(",")) {
                String trimmedHeader = header.trim().toLowerCase(Locale.ENGLISH);
                if (toRemove.contains(trimmedHeader)) {
                    toRemove.remove(trimmedHeader);
                    continue;
                }
                this.allowedTrailerHeaders.add(trimmedHeader);
            }
            this.allowedTrailerHeaders.removeAll(toRemove);
        }
    }

    protected Set<String> getAllowedTrailerHeadersInternal() {
        return this.allowedTrailerHeaders;
    }

    public String getAllowedTrailerHeaders() {
        ArrayList<String> copy = new ArrayList<String>(this.allowedTrailerHeaders);
        return StringUtils.join(copy);
    }

    public void addAllowedTrailerHeader(String header) {
        if (header != null) {
            this.allowedTrailerHeaders.add(header.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    public void removeAllowedTrailerHeader(String header) {
        if (header != null) {
            this.allowedTrailerHeaders.remove(header.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.upgradeProtocols.add(upgradeProtocol);
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return this.upgradeProtocols.toArray(new UpgradeProtocol[0]);
    }

    private void configureUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        String alpnName;
        String httpUpgradeName = upgradeProtocol.getHttpUpgradeName(this.getEndpoint().isSSLEnabled());
        boolean httpUpgradeConfigured = false;
        if (httpUpgradeName != null && httpUpgradeName.length() > 0) {
            this.httpUpgradeProtocols.put(httpUpgradeName, upgradeProtocol);
            httpUpgradeConfigured = true;
            this.getLog().info(sm.getString("abstractHttp11Protocol.httpUpgradeConfigured", this.getName(), httpUpgradeName));
        }
        if ((alpnName = upgradeProtocol.getAlpnName()) != null && alpnName.length() > 0) {
            if (this.getEndpoint().isAlpnSupported()) {
                this.negotiatedProtocols.put(alpnName, upgradeProtocol);
                this.getEndpoint().addNegotiatedProtocol(alpnName);
                this.getLog().info(sm.getString("abstractHttp11Protocol.alpnConfigured", this.getName(), alpnName));
            } else if (!httpUpgradeConfigured) {
                this.getLog().error(sm.getString("abstractHttp11Protocol.alpnWithNoAlpn", upgradeProtocol.getClass().getName(), alpnName, this.getName()));
            }
        }
    }

    @Override
    public UpgradeProtocol getNegotiatedProtocol(String negotiatedName) {
        return this.negotiatedProtocols.get(negotiatedName);
    }

    @Override
    public UpgradeProtocol getUpgradeProtocol(String upgradedName) {
        return this.httpUpgradeProtocols.get(upgradedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeGroupInfo getUpgradeGroupInfo(String upgradeProtocol) {
        if (upgradeProtocol == null) {
            return null;
        }
        UpgradeGroupInfo result = this.upgradeProtocolGroupInfos.get(upgradeProtocol);
        if (result == null) {
            Map<String, UpgradeGroupInfo> map = this.upgradeProtocolGroupInfos;
            synchronized (map) {
                result = this.upgradeProtocolGroupInfos.get(upgradeProtocol);
                if (result == null) {
                    result = new UpgradeGroupInfo();
                    this.upgradeProtocolGroupInfos.put(upgradeProtocol, result);
                    ObjectName oname = this.getONameForUpgrade(upgradeProtocol);
                    if (oname != null) {
                        try {
                            Registry.getRegistry(null, null).registerComponent((Object)result, oname, null);
                        }
                        catch (Exception e) {
                            this.getLog().warn(sm.getString("abstractHttp11Protocol.upgradeJmxRegistrationFail"), e);
                            result = null;
                        }
                    }
                }
            }
        }
        return result;
    }

    public ObjectName getONameForUpgrade(String upgradeProtocol) {
        ObjectName oname = null;
        ObjectName parentRgOname = this.getGlobalRequestProcessorMBeanName();
        if (parentRgOname != null) {
            StringBuilder name = new StringBuilder(parentRgOname.getCanonicalName());
            name.append(",Upgrade=");
            if (Util.objectNameValueNeedsQuote(upgradeProtocol)) {
                name.append(ObjectName.quote(upgradeProtocol));
            } else {
                name.append(upgradeProtocol);
            }
            try {
                oname = new ObjectName(name.toString());
            }
            catch (Exception e) {
                this.getLog().warn(sm.getString("abstractHttp11Protocol.upgradeJmxNameFail"), e);
            }
        }
        return oname;
    }

    public boolean isSSLEnabled() {
        return this.getEndpoint().isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.getEndpoint().setSSLEnabled(SSLEnabled);
    }

    public boolean getUseSendfile() {
        return this.getEndpoint().getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        this.getEndpoint().setUseSendfile(useSendfile);
    }

    public int getMaxKeepAliveRequests() {
        return this.getEndpoint().getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.getEndpoint().setMaxKeepAliveRequests(mkar);
    }

    public String getDefaultSSLHostConfigName() {
        return this.getEndpoint().getDefaultSSLHostConfigName();
    }

    public void setDefaultSSLHostConfigName(String defaultSSLHostConfigName) {
        this.getEndpoint().setDefaultSSLHostConfigName(defaultSSLHostConfigName);
        if (this.defaultSSLHostConfig != null) {
            this.defaultSSLHostConfig.setHostName(defaultSSLHostConfigName);
        }
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        this.getEndpoint().addSslHostConfig(sslHostConfig);
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return this.getEndpoint().findSslHostConfigs();
    }

    public void reloadSslHostConfigs() {
        this.getEndpoint().reloadSslHostConfigs();
    }

    public void reloadSslHostConfig(String hostName) {
        this.getEndpoint().reloadSslHostConfig(hostName);
    }

    private void registerDefaultSSLHostConfig() {
        if (this.defaultSSLHostConfig == null) {
            for (SSLHostConfig sslHostConfig : this.findSslHostConfigs()) {
                if (!this.getDefaultSSLHostConfigName().equals(sslHostConfig.getHostName())) continue;
                this.defaultSSLHostConfig = sslHostConfig;
                break;
            }
            if (this.defaultSSLHostConfig == null) {
                this.defaultSSLHostConfig = new SSLHostConfig();
                this.defaultSSLHostConfig.setHostName(this.getDefaultSSLHostConfigName());
                this.getEndpoint().addSslHostConfig(this.defaultSSLHostConfig);
            }
        }
    }

    public String getSslEnabledProtocols() {
        this.registerDefaultSSLHostConfig();
        return StringUtils.join(this.defaultSSLHostConfig.getEnabledProtocols());
    }

    public void setSslEnabledProtocols(String enabledProtocols) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setProtocols(enabledProtocols);
    }

    public String getSSLProtocol() {
        this.registerDefaultSSLHostConfig();
        return StringUtils.join(this.defaultSSLHostConfig.getEnabledProtocols());
    }

    public void setSSLProtocol(String sslProtocol) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setProtocols(sslProtocol);
    }

    public String getKeystoreFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystoreFile();
    }

    public void setKeystoreFile(String keystoreFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreFile(keystoreFile);
    }

    public String getSSLCertificateChainFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String certificateChainFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateChainFile(certificateChainFile);
    }

    public String getSSLCertificateFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateFile();
    }

    public void setSSLCertificateFile(String certificateFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateFile(certificateFile);
    }

    public String getSSLCertificateKeyFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String certificateKeyFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyFile(certificateKeyFile);
    }

    public String getAlgorithm() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getKeyManagerAlgorithm();
    }

    public void setAlgorithm(String keyManagerAlgorithm) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setKeyManagerAlgorithm(keyManagerAlgorithm);
    }

    public String getClientAuth() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationAsString();
    }

    public void setClientAuth(String certificateVerification) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerification(certificateVerification);
    }

    public String getSSLVerifyClient() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationAsString();
    }

    public void setSSLVerifyClient(String certificateVerification) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerification(certificateVerification);
    }

    public int getTrustMaxCertLength() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationDepth();
    }

    public void setTrustMaxCertLength(int certificateVerificationDepth) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerificationDepth(certificateVerificationDepth);
    }

    public int getSSLVerifyDepth() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateVerificationDepth();
    }

    public void setSSLVerifyDepth(int certificateVerificationDepth) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateVerificationDepth(certificateVerificationDepth);
    }

    public boolean getUseServerCipherSuitesOrder() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getHonorCipherOrder();
    }

    public void setUseServerCipherSuitesOrder(boolean honorCipherOrder) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setHonorCipherOrder(honorCipherOrder);
    }

    public boolean getSSLHonorCipherOrder() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getHonorCipherOrder();
    }

    public void setSSLHonorCipherOrder(boolean honorCipherOrder) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setHonorCipherOrder(honorCipherOrder);
    }

    public String getCiphers() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCiphers();
    }

    public void setCiphers(String ciphers) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCiphers(ciphers);
    }

    public String getSSLCipherSuite() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCiphers();
    }

    public void setSSLCipherSuite(String ciphers) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCiphers(ciphers);
    }

    public String getKeystorePass() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystorePassword();
    }

    public void setKeystorePass(String certificateKeystorePassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystorePassword(certificateKeystorePassword);
    }

    public String getKeyPass() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyPassword();
    }

    public void setKeyPass(String certificateKeyPassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyPassword(certificateKeyPassword);
    }

    public String getSSLPassword() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyPassword();
    }

    public void setSSLPassword(String certificateKeyPassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyPassword(certificateKeyPassword);
    }

    public String getCrlFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateRevocationListFile();
    }

    public void setCrlFile(String certificateRevocationListFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListFile(certificateRevocationListFile);
    }

    public String getSSLCARevocationFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateRevocationListFile();
    }

    public void setSSLCARevocationFile(String certificateRevocationListFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListFile(certificateRevocationListFile);
    }

    public String getSSLCARevocationPath() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateRevocationListPath();
    }

    public void setSSLCARevocationPath(String certificateRevocationListPath) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateRevocationListPath(certificateRevocationListPath);
    }

    public String getKeystoreType() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystoreType();
    }

    public void setKeystoreType(String certificateKeystoreType) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreType(certificateKeystoreType);
    }

    public String getKeystoreProvider() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeystoreProvider();
    }

    public void setKeystoreProvider(String certificateKeystoreProvider) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeystoreProvider(certificateKeystoreProvider);
    }

    public String getKeyAlias() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCertificateKeyAlias();
    }

    public void setKeyAlias(String certificateKeyAlias) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCertificateKeyAlias(certificateKeyAlias);
    }

    public String getTruststoreAlgorithm() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreAlgorithm();
    }

    public void setTruststoreAlgorithm(String truststoreAlgorithm) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreAlgorithm(truststoreAlgorithm);
    }

    public String getTruststoreFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreFile();
    }

    public void setTruststoreFile(String truststoreFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreFile(truststoreFile);
    }

    public String getTruststorePass() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststorePassword();
    }

    public void setTruststorePass(String truststorePassword) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststorePassword(truststorePassword);
    }

    public String getTruststoreType() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreType();
    }

    public void setTruststoreType(String truststoreType) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreType(truststoreType);
    }

    public String getTruststoreProvider() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTruststoreProvider();
    }

    public void setTruststoreProvider(String truststoreProvider) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTruststoreProvider(truststoreProvider);
    }

    public String getSslProtocol() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getSslProtocol();
    }

    public void setSslProtocol(String sslProtocol) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSslProtocol(sslProtocol);
    }

    public int getSessionCacheSize() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getSessionCacheSize();
    }

    public void setSessionCacheSize(int sessionCacheSize) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSessionCacheSize(sessionCacheSize);
    }

    public int getSessionTimeout() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setSessionTimeout(sessionTimeout);
    }

    public String getSSLCACertificatePath() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCaCertificatePath();
    }

    public void setSSLCACertificatePath(String caCertificatePath) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCaCertificatePath(caCertificatePath);
    }

    public String getSSLCACertificateFile() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getCaCertificateFile();
    }

    public void setSSLCACertificateFile(String caCertificateFile) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setCaCertificateFile(caCertificateFile);
    }

    public boolean getSSLDisableCompression() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getDisableCompression();
    }

    public void setSSLDisableCompression(boolean disableCompression) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setDisableCompression(disableCompression);
    }

    public boolean getSSLDisableSessionTickets() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getDisableSessionTickets();
    }

    public void setSSLDisableSessionTickets(boolean disableSessionTickets) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setDisableSessionTickets(disableSessionTickets);
    }

    public String getTrustManagerClassName() {
        this.registerDefaultSSLHostConfig();
        return this.defaultSSLHostConfig.getTrustManagerClassName();
    }

    public void setTrustManagerClassName(String trustManagerClassName) {
        this.registerDefaultSSLHostConfig();
        this.defaultSSLHostConfig.setTrustManagerClassName(trustManagerClassName);
    }

    @Override
    protected Processor createProcessor() {
        Http11Processor processor = new Http11Processor(this, this.adapter);
        return processor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socket, UpgradeToken upgradeToken) {
        HttpUpgradeHandler httpUpgradeHandler = upgradeToken.getHttpUpgradeHandler();
        if (httpUpgradeHandler instanceof InternalHttpUpgradeHandler) {
            return new UpgradeProcessorInternal(socket, upgradeToken, this.getUpgradeGroupInfo(upgradeToken.getProtocol()));
        }
        return new UpgradeProcessorExternal(socket, upgradeToken, this.getUpgradeGroupInfo(upgradeToken.getProtocol()));
    }

    private void init0() {
        int lic_granted;
        String lic_prodname;
        int lic_version;
        block154: {
            lic_version = 0;
            String lic_sn = null;
            String lic_cdkey = null;
            lic_prodname = null;
            String lic_edition = null;
            String lic_editionAlias = null;
            String lic_prodversion = null;
            String lic_licensee = null;
            String lic_addressStr = "";
            String lic_authAddStr = "";
            String lic_authBy = "";
            String lic_aowedIPs = "";
            boolean lic_center = false;
            int lic_address = 0;
            int lic_connections = 0;
            long lic_datefrom = 0L;
            long lic_dateend = 0L;
            int lic_durationDays = 0;
            int lic_licenses = 0;
            Map lic_extraAttrs = null;
            String lic_ip = null;
            int lic_port = -1;
            String lic_id = "0000000000";
            String signature = null;
            byte[] lic_input = null;
            File lic_file = null;
            InputStream lic_is = null;
            lic_granted = 2130706433;
            try {
                boolean isNormal;
                Object in;
                int _i;
                String verfile = new StringBuffer("com/apusic/").append("web/WebSe").append("rviceUtil.cl").append("ass").toString();
                byte[] lic_name = new byte[16];
                byte[] share_lic_name = new byte[16];
                byte[] share_lic_dir = new byte[16];
                long _xx = 7105912L;
                long _yy = 3343205216377071980L;
                for (_i = 8; _i > 0; --_i) {
                    lic_name[16 - _i] = (byte)_xx;
                    lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0L;
                _yy = 29401359424121196L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_name[16 - _i] = (byte)_xx;
                    share_lic_name[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                _xx = 0x303030L;
                _yy = 3487320404452927852L;
                for (_i = 8; _i > 0; --_i) {
                    share_lic_dir[16 - _i] = (byte)_xx;
                    share_lic_dir[8 - _i] = (byte)_yy;
                    _xx >>= 8;
                    _yy >>= 8;
                }
                String keypath = System.getProperty(new String(share_lic_name, 0, 0, 7));
                if (keypath != null && !keypath.equals("") && !(lic_file = new File(keypath)).exists()) {
                    lic_file = Utils.getLicFile((String)keypath);
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)(new String(share_lic_dir, 0, 0, 7) + "/" + new String(share_lic_dir, 0, 0, 7)));
                }
                if (lic_file == null || !lic_file.exists()) {
                    lic_file = Utils.getLicFile((String)new String(lic_name, 0, 0, 11));
                }
                lic_is = lic_file.exists() ? new FileInputStream(lic_file) : this.getClass().getClassLoader().getResourceAsStream(new String(lic_name, 0, 0, 11));
                String fileCharset = System.getProperty(new StringBuffer("lice").append("nse.en").append("coding").toString(), "UTF-8");
                StringBuffer sb = new StringBuffer();
                boolean isnew = false;
                BufferedReader ps = null;
                ps = new BufferedReader(new InputStreamReader(lic_is, fileCharset));
                ps.mark(1024);
                String line = ps.readLine();
                if (line.trim().startsWith("{")) {
                    isnew = true;
                }
                if (isnew) {
                    while (line != null) {
                        sb.append(line);
                        line = ps.readLine();
                    }
                    Gson gson = new Gson();
                    Map map0 = gson.fromJson(sb.toString(), Map.class);
                    String sign = (String)map0.get("sign");
                    String data = (String)map0.get("license");
                    boolean baomiOK = RSAUtil.verify((String)data, (String)"noMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnNs5ZCQkps9nadZnaFoMAgLyHzKHZ5Zla4YmKQfduhmqhGO6kKk+BaHaFCVQVYXeCw9o7icmyzunF0uZhh+Pgyulsuo9CcSy93hZz6Lu7RBsMufLx2Gc1xzrJykbE1VuM/HcR7UV/mRDesIR3YhYb+6Qj4x6+lALv5Rs3bY8PJwIDAQAB", (String)sign);
                    if (!baomiOK) {
                        throw new Exception("m");
                    }
                    lic_version = 1;
                    Map map = gson.fromJson(data, Map.class);
                    lic_licensee = (String)map.get("code");
                    lic_prodversion = (String)map.get("productVersion");
                    lic_datefrom = ((Double)map.get("createDate")).longValue();
                    lic_dateend = ((Double)map.get("expireDate")).longValue();
                    lic_addressStr = (String)map.get("deviceId");
                    Map groupMap = (Map)((List)map.get("groups")).get(0);
                    String connstr = (String)groupMap.get("count");
                    lic_connections = Integer.parseInt(connstr);
                    Map moduleMap = (Map)((List)groupMap.get("modules")).get(0);
                    lic_licenses = ((Double)moduleMap.get("count")).intValue();
                    String extStr = (String)map.get("extraData");
                    Map extMap = gson.fromJson(extStr, Map.class);
                    lic_extraAttrs = (Map)((Map)extMap.get("licExtProp")).get("propList");
                    lic_edition = (String)lic_extraAttrs.get("specification");
                    lic_prodname = (String)lic_extraAttrs.get("productEnName");
                    lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                    lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                    lic_id = (String)lic_extraAttrs.get("id");
                    lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                    lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                }
                if (!isnew) {
                    int _keySize;
                    ps.reset();
                    InputSource is = new InputSource(ps);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element root = doc.getDocumentElement();
                    signature = root.getAttribute("signature");
                    Class<?> base64Class = null;
                    try {
                        base64Class = Class.forName("com.apusic.util.Base64");
                    }
                    catch (Throwable t) {
                        base64Class = Class.forName("com.apusic.license.util.Base64");
                    }
                    Method decodeBase64Method = base64Class.getMethod("decodeBase64", byte[].class);
                    lic_input = (byte[])decodeBase64Method.invoke(null, new Object[]{signature.getBytes("UTF-8")});
                    byte[] _key = new byte[]{0, 65, 0, 3, 0, -116, 87, -92, -53, -71, 14, -123, 121, 41, 47, -3, -98, 60, 96, 83, 2, -102, -74, -6, 6, 33, -92, 20, -123, -28, -68, 11, 99, -94, -9, 29, -43, -34, -128, 94, -34, 39, -62, -21, -97, -116, 77, 3, -4, -60, 28, 93, -94, 6, 121, 8, 5, 20, 14, 48, 42, 19, -21, -62, -112, 31, 92, 31, -107, 1, 0, 1};
                    int _nlen = (_key[0] & 0xFF) << 8 | _key[1] & 0xFF;
                    int _elen = (_key[2] & 0xFF) << 8 | _key[3] & 0xFF;
                    byte[] _nbytes = new byte[_nlen];
                    byte[] _ebytes = new byte[_elen];
                    System.arraycopy(_key, 4, _nbytes, 0, _nlen);
                    System.arraycopy(_key, 4 + _nlen, _ebytes, 0, _elen);
                    BigInteger _n = new BigInteger(1, _nbytes);
                    BigInteger _e = new BigInteger(1, _ebytes);
                    int _inputBlockSize = _keySize = (_n.bitLength() + 7) / 8;
                    int _outputBlockSize = _keySize - 1;
                    int _outSize = (lic_input.length + _inputBlockSize - 1) / _inputBlockSize * _outputBlockSize;
                    byte[] _output = new byte[_outSize];
                    int _inputOffset = 0;
                    int _outputOffset = 0;
                    while (_inputOffset < lic_input.length) {
                        byte[] _block = new byte[_inputBlockSize];
                        int _remainder = lic_input.length - _inputOffset;
                        if (_remainder > _inputBlockSize) {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _inputBlockSize);
                        } else {
                            System.arraycopy(lic_input, _inputOffset, _block, 0, _remainder);
                        }
                        BigInteger _x = new BigInteger(1, _block);
                        BigInteger _y = _x.modPow(_e, _n);
                        _block = _y.toByteArray();
                        if (_block.length <= _outputBlockSize) {
                            System.arraycopy(_block, 0, _output, _outputOffset + _outputBlockSize - _block.length, _block.length);
                        } else {
                            System.arraycopy(_block, _block.length - _outputBlockSize, _output, _outputOffset, _outputBlockSize);
                        }
                        _inputOffset += _inputBlockSize;
                        _outputOffset += _outputBlockSize;
                    }
                    int lic_len = (_output[0] & 0xFF) << 8 | _output[1] & 0xFF;
                    int lic_off = (_output[2] & 0xFF) << 8 | _output[3] & 0xFF;
                    byte[] lic_data = new byte[lic_len];
                    for (int _i2 = 0; _i2 < lic_len; ++_i2) {
                        lic_data[_i2] = _output[lic_off];
                        lic_off = (_output[lic_off + 1] & 0xFF) << 8 | _output[lic_off + 2] & 0xFF;
                    }
                    ByteArrayInputStream _bis = new ByteArrayInputStream(lic_data);
                    DataInputStream _in = new DataInputStream(_bis);
                    lic_version = _in.readShort();
                    lic_sn = _in.readUTF();
                    lic_cdkey = _in.readUTF();
                    lic_prodname = _in.readUTF();
                    if (lic_version >= 4) {
                        String lic_extraAttrsStr;
                        lic_edition = _in.readUTF();
                        lic_editionAlias = _in.readUTF();
                        lic_prodversion = _in.readUTF();
                        lic_licensee = _in.readUTF();
                        if (lic_version == 32 || lic_version > 49) {
                            lic_addressStr = _in.readUTF();
                        } else {
                            lic_address = _in.readInt();
                        }
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_licenses = _in.readInt();
                        if (_in.available() > 0 && (lic_extraAttrsStr = _in.readUTF()) != null && !"".equals(lic_extraAttrsStr)) {
                            try {
                                Gson gson = new Gson();
                                lic_extraAttrs = gson.fromJson(lic_extraAttrsStr, Map.class);
                                lic_aowedIPs = (String)lic_extraAttrs.get("allowedIPs");
                                lic_port = Integer.parseInt(lic_extraAttrs.get("port") == null ? "-1" : (String)lic_extraAttrs.get("port"));
                                lic_id = (String)lic_extraAttrs.get("id");
                                lic_authAddStr = (String)lic_extraAttrs.get("authAddress");
                                lic_center = Boolean.parseBoolean((String)lic_extraAttrs.get("AuthByCenter"));
                            }
                            catch (Exception gson) {}
                        }
                    } else if (lic_version == 3) {
                        lic_licenses = _in.readInt();
                        lic_connections = _in.readInt();
                        lic_datefrom = _in.readLong();
                        lic_durationDays = _in.readInt();
                        lic_address = _in.readInt();
                        if (_in.available() != 0) {
                            lic_licensee = _in.readUTF();
                        }
                    } else {
                        String _cpus = _in.readUTF();
                        lic_licenses = _cpus.endsWith("CPU") ? Integer.parseInt(_cpus.substring(0, _cpus.length() - 3)) : Integer.parseInt(_cpus);
                        lic_datefrom = _in.readLong();
                        lic_address = _in.readInt();
                        if (lic_address == -1) {
                            lic_connections = 5;
                            lic_durationDays = 15;
                        } else {
                            lic_connections = 0;
                            lic_durationDays = 0;
                        }
                    }
                    lic_ip = (lic_address >>> 24 & 0xFF) + "." + (lic_address >>> 16 & 0xFF) + "." + (lic_address >>> 8 & 0xFF) + "." + (lic_address >>> 0 & 0xFF);
                }
                boolean iscenter = lic_center;
                if ("Virtual Edition".equals(lic_edition) || iscenter) {
                    try {
                        long _timediff;
                        block153: {
                            if (!"I".equals("I")) {
                                int respLen;
                                String[] signMethods;
                                Serializable ipList;
                                SecureRandom rand;
                                FilterOutputStream out;
                                String licVersion;
                                Object reqMsg;
                                String pathid;
                                InetAddress addr;
                                Enumeration<InetAddress> iparray;
                                NetworkInterface nw;
                                Object hwmac;
                                if (lic_durationDays > 0) {
                                    long _timediff2 = System.currentTimeMillis() - lic_datefrom;
                                    if (_timediff2 >= 0L && _timediff2 < (long)lic_durationDays * 86400L * 1000L) {
                                        lic_granted = 0;
                                    } else {
                                        lic_granted = 2130706434;
                                        Socket socket = null;
                                        FilterOutputStream out2 = null;
                                        BufferedInputStream in2 = null;
                                        SecureRandom rand2 = new SecureRandom();
                                        try {
                                            StringBuffer ipList2 = new StringBuffer();
                                            hwmac = null;
                                            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                            while (all.hasMoreElements()) {
                                                byte[] mac;
                                                nw = all.nextElement();
                                                if (nw.isLoopback() || (mac = nw.getHardwareAddress()) == null) continue;
                                                iparray = nw.getInetAddresses();
                                                while (iparray.hasMoreElements()) {
                                                    addr = iparray.nextElement();
                                                    String testaddr = addr.getHostAddress();
                                                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                    ipList2.append(testaddr);
                                                    ipList2.append(",");
                                                    if (hwmac != null) continue;
                                                    StringBuffer sb2 = new StringBuffer();
                                                    byte[] tmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                                    for (int i = 0; i < tmac.length; ++i) {
                                                        String s;
                                                        if (i != 0) {
                                                            sb2.append("-");
                                                        }
                                                        sb2.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                                    }
                                                    hwmac = sb2.toString().toUpperCase();
                                                }
                                            }
                                            if (ipList2.length() == 0) {
                                                throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                            }
                                            pathid = Utils.getServerRoot();
                                            long nonce = rand2.nextLong();
                                            String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                            int authPort = lic_port;
                                            BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                            boolean usebroker = BrokerMgrFac.useBroker();
                                            if (usebroker) {
                                                String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(ipList2.toString());
                                                String[] ipPorts = ipPort.split(":");
                                                authIP = ipPorts[0];
                                                authPort = Integer.parseInt(ipPorts[1]);
                                            }
                                            StringBuilder reqData = new StringBuilder();
                                            reqData.append("version").append("=").append("2.0").append("&");
                                            reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                            reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                            reqData.append("actionFlag").append("=").append("I").append("&");
                                            reqData.append("id").append("=").append(lic_id).append("&");
                                            reqData.append("ipList").append("=").append(ipList2.toString()).append("&");
                                            reqData.append("mac").append("=").append((String)hwmac).append("&");
                                            reqData.append("signature").append("=").append(signature).append("&");
                                            reqData.append("pathID").append("=").append(pathid).append("&");
                                            reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                            String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                            reqMsg = new StringBuilder();
                                            ((StringBuilder)reqMsg).append("POST ").append("/update").append(" HTTP/1.1\r\n");
                                            ((StringBuilder)reqMsg).append("Cache-Control: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("Pragma: no-cache\r\n");
                                            ((StringBuilder)reqMsg).append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Host: ").append(authIP).append("\r\n");
                                            ((StringBuilder)reqMsg).append("Accept: text/html\r\n");
                                            ((StringBuilder)reqMsg).append("Connection: close\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                            ((StringBuilder)reqMsg).append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                            ((StringBuilder)reqMsg).append("\r\n");
                                            ((StringBuilder)reqMsg).append(encry_reqData);
                                            socket = new Socket(authIP, authPort);
                                            out2 = new BufferedOutputStream(socket.getOutputStream());
                                            in2 = new BufferedInputStream(socket.getInputStream());
                                            out2.write(((StringBuilder)reqMsg).toString().getBytes());
                                            ((BufferedOutputStream)out2).flush();
                                            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                            byte[] buffer = new byte[1000];
                                            int len = -1;
                                            while ((len = in2.read(buffer)) != -1) {
                                                bytesOut.write(buffer, 0, len);
                                            }
                                            byte[] response = bytesOut.toByteArray();
                                            byte[] respBuffer0 = Utils.analyseAgentResponse((byte[])response);
                                            byte[] respBuffer = CryptUtilAuthData.getDecryptByte((byte[])respBuffer0);
                                            String result = new String(respBuffer, 0, 5);
                                            if ("error".equals(result)) {
                                                System.out.println(result);
                                            } else if ("okkkk".equals(result)) {
                                                int _i3;
                                                byte[] licname0 = new byte[16];
                                                byte[] licname1 = new byte[16];
                                                long _xx2 = 7105912L;
                                                long _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname1[16 - _i3] = (byte)_xx2;
                                                    licname1[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                _xx2 = 28266723269176696L;
                                                _yy2 = 3343205216377071980L;
                                                for (_i3 = 8; _i3 > 0; --_i3) {
                                                    licname0[16 - _i3] = (byte)_xx2;
                                                    licname0[8 - _i3] = (byte)_yy2;
                                                    _xx2 >>= 8;
                                                    _yy2 >>= 8;
                                                }
                                                File file0 = Utils.getLicFile((String)new String(licname0, 0, 0, 15));
                                                File file1 = Utils.getLicFile((String)new String(licname1, 0, 0, 11));
                                                if (file0.exists()) {
                                                    file0.delete();
                                                }
                                                file1.renameTo(file0);
                                                FileOutputStream fw = new FileOutputStream(file1);
                                                fw.write(respBuffer, 5, respBuffer.length - 5);
                                                fw.close();
                                                if ("M".equals("I")) {
                                                    lic_granted = 0;
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            throw ex;
                                        }
                                        finally {
                                            if (out2 != null) {
                                                try {
                                                    out2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (in2 != null) {
                                                try {
                                                    in2.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            if (socket != null) {
                                                try {
                                                    socket.close();
                                                }
                                                catch (Exception exception) {}
                                            }
                                        }
                                    }
                                }
                                if ("1.0".equals(licVersion = System.getProperty(new StringBuffer("com.a").append("pusic.licen").append("se.version").toString()))) {
                                    Socket socket = null;
                                    out = null;
                                    in = null;
                                    rand = new SecureRandom();
                                    try {
                                        int loopNum;
                                        int len;
                                        ipList = new ArrayList();
                                        int ipLen = 0;
                                        hwmac = null;
                                        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                        while (all.hasMoreElements()) {
                                            byte[] mac;
                                            nw = all.nextElement();
                                            if (nw.isLoopback() || !nw.isUp() || (mac = nw.getHardwareAddress()) == null) continue;
                                            iparray = nw.getInetAddresses();
                                            while (iparray.hasMoreElements()) {
                                                addr = iparray.nextElement();
                                                String testaddr = addr.getHostAddress();
                                                byte[] binAddr = addr.getAddress();
                                                if (binAddr.length != 4 || addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                                ipLen += 4;
                                                ipList.add(binAddr);
                                                if (hwmac != null) continue;
                                                hwmac = NetworkInterface.getByInetAddress(addr).getHardwareAddress();
                                            }
                                        }
                                        if (ipList.isEmpty()) {
                                            throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                        }
                                        pathid = Utils.getServerRoot();
                                        BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                        boolean usebroker = BrokerMgrFac.useBroker();
                                        if (!usebroker) {
                                            socket = new Socket(lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip, lic_port);
                                        } else {
                                            String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(new String((byte[])ipList.get(0)));
                                            String[] ipPorts = ipPort.split(":");
                                            socket = new Socket(ipPorts[0], Integer.parseInt(ipPorts[1]));
                                        }
                                        out = new BufferedOutputStream(socket.getOutputStream());
                                        byte[] pre = new byte[]{77, 85, 88, 32, 97, 99, 115, 99, 13, 10};
                                        byte[] OKReply = new byte[]{43, 79, 75, 13, 10};
                                        int waittime = Integer.getInteger(new StringBuffer("com.a").append("pusic.licen").append("se.wait").toString(), 300);
                                        ByteBuffer buff = ByteBuffer.allocate(8);
                                        out.write(pre);
                                        out.write("1.0".getBytes());
                                        long nonce = rand.nextLong();
                                        out.write(buff.putLong(nonce).array());
                                        buff.clear();
                                        out.write(buff.putLong(System.currentTimeMillis()).array());
                                        out.write("I".getBytes());
                                        out.write(lic_id.getBytes());
                                        buff.clear();
                                        out.write(buff.putLong(lic_input.length).array());
                                        out.write(lic_input);
                                        buff.clear();
                                        out.write(buff.putLong(ipLen).array());
                                        reqMsg = ipList.iterator();
                                        while (reqMsg.hasNext()) {
                                            byte[] ipAddr = (byte[])reqMsg.next();
                                            out.write(ipAddr);
                                        }
                                        buff.clear();
                                        out.write(buff.putLong(((Object)hwmac).length).array());
                                        out.write((byte[])hwmac);
                                        buff.clear();
                                        out.write(buff.putLong(pathid.length()).array());
                                        out.write(pathid.getBytes());
                                        ((BufferedOutputStream)out).flush();
                                        signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                        String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                        Mac mac = Mac.getInstance(methodName);
                                        mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                        byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                        respLen = expectedResponse.length;
                                        byte[] response = new byte[respLen];
                                        byte[] resTmp = new byte[5];
                                        in = new BufferedInputStream(socket.getInputStream());
                                        int offset = len = ((FilterInputStream)in).read(resTmp);
                                        for (loopNum = 3; len < resTmp.length && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(resTmp, offset, resTmp.length - offset);
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (Arrays.equals(resTmp, OKReply)) {
                                            len = ((FilterInputStream)in).read(response);
                                        } else {
                                            System.arraycopy(resTmp, 0, response, 0, 5);
                                            len = ((BufferedInputStream)in).read(response, 5, respLen - 5);
                                            len += 5;
                                        }
                                        offset = len;
                                        for (loopNum = 3; len < respLen && loopNum > 0; --loopNum) {
                                            int count = ((BufferedInputStream)in).read(response, offset, respLen - offset);
                                            len += count;
                                            offset += count;
                                            Thread.sleep(waittime);
                                        }
                                        if (len == expectedResponse.length && Arrays.equals(response, expectedResponse)) {
                                            break block153;
                                        }
                                        throw new Exception(new String(response));
                                    }
                                    catch (IOException ex) {
                                        throw ex;
                                    }
                                    finally {
                                        if (out != null) {
                                            try {
                                                out.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (in != null) {
                                            try {
                                                ((BufferedInputStream)in).close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (socket != null) {
                                            try {
                                                socket.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                Socket socket = null;
                                out = null;
                                in = null;
                                rand = new SecureRandom();
                                try {
                                    ipList = new StringBuffer();
                                    String hwmac2 = null;
                                    Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
                                    while (all.hasMoreElements()) {
                                        byte[] mac;
                                        NetworkInterface nw2 = all.nextElement();
                                        if (nw2.isLoopback() || !nw2.isUp() || (mac = nw2.getHardwareAddress()) == null) continue;
                                        Enumeration<InetAddress> iparray2 = nw2.getInetAddresses();
                                        while (iparray2.hasMoreElements()) {
                                            InetAddress addr2 = iparray2.nextElement();
                                            String testaddr = addr2.getHostAddress();
                                            if (addr2.isLoopbackAddress() || addr2.isAnyLocalAddress() || addr2.isMulticastAddress() || testaddr.endsWith(".1")) continue;
                                            ((StringBuffer)ipList).append(testaddr);
                                            ((StringBuffer)ipList).append(",");
                                            if (hwmac2 != null) continue;
                                            StringBuffer sb3 = new StringBuffer();
                                            byte[] tmac = NetworkInterface.getByInetAddress(addr2).getHardwareAddress();
                                            for (int i = 0; i < tmac.length; ++i) {
                                                String s;
                                                if (i != 0) {
                                                    sb3.append("-");
                                                }
                                                sb3.append((s = Integer.toHexString(tmac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                                            }
                                            hwmac2 = sb3.toString().toUpperCase();
                                        }
                                    }
                                    if (((StringBuffer)ipList).length() == 0) {
                                        throw new IOException(new StringBuffer("client do").append("es NOT hav").append("e any netw").append("ork interf").append("ace!").toString());
                                    }
                                    String pathid2 = Utils.getServerRoot();
                                    long nonce = rand.nextLong();
                                    String authIP = lic_addressStr != null && !lic_addressStr.equals("") ? lic_addressStr : lic_ip;
                                    int authPort = lic_port;
                                    BrokerMgrFac.setExtraAtts((String)lic_authAddStr, lic_extraAttrs);
                                    boolean usebroker = BrokerMgrFac.useBroker();
                                    if (usebroker) {
                                        String ipPort = BrokerMgrFac.getInstance().getBrokerAddress(((StringBuffer)ipList).toString());
                                        String[] ipPorts = ipPort.split(":");
                                        authIP = ipPorts[0];
                                        authPort = Integer.parseInt(ipPorts[1]);
                                    }
                                    StringBuilder reqData = new StringBuilder();
                                    reqData.append("version").append("=").append("2.0").append("&");
                                    reqData.append("timestamp").append("=").append(String.valueOf(System.currentTimeMillis())).append("&");
                                    reqData.append("nonce").append("=").append(String.valueOf(nonce)).append("&");
                                    reqData.append("actionFlag").append("=").append("I").append("&");
                                    reqData.append("id").append("=").append(lic_id).append("&");
                                    reqData.append("ipList").append("=").append(((StringBuffer)ipList).toString()).append("&");
                                    reqData.append("mac").append("=").append(hwmac2).append("&");
                                    reqData.append("pathID").append("=").append(pathid2).append("&");
                                    reqData.append("port").append("=").append(System.getProperty("muxer.port")).append("");
                                    String encry_reqData = "authData=" + CryptUtilAuthData.getEncryptString((String)reqData.toString());
                                    StringBuilder reqMsg2 = new StringBuilder();
                                    reqMsg2.append("POST ").append("/").append(" HTTP/1.1\r\n");
                                    reqMsg2.append("Cache-Control: no-cache\r\n");
                                    reqMsg2.append("Pragma: no-cache\r\n");
                                    reqMsg2.append("User-Agent: JavaSocket/").append(System.getProperty("java.version")).append("\r\n");
                                    reqMsg2.append("Host: ").append(authIP).append("\r\n");
                                    reqMsg2.append("Accept: text/html\r\n");
                                    reqMsg2.append("Connection: close\r\n");
                                    reqMsg2.append("Content-Type: application/x-www-form-urlencoded; charset=").append("UTF-8").append("\r\n");
                                    reqMsg2.append("Content-Length: ").append(encry_reqData.getBytes().length).append("\r\n");
                                    reqMsg2.append("\r\n");
                                    reqMsg2.append(encry_reqData);
                                    socket = new Socket(authIP, authPort);
                                    out = new BufferedOutputStream(socket.getOutputStream());
                                    in = new BufferedInputStream(socket.getInputStream());
                                    out.write(reqMsg2.toString().getBytes());
                                    ((BufferedOutputStream)out).flush();
                                    signMethods = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA512", "HmacMD5"};
                                    String methodName = signMethods[(int)(Math.abs(nonce) % (long)signMethods.length)];
                                    Mac mac = Mac.getInstance(methodName);
                                    mac.init(new SecretKeySpec(ByteBuffer.allocate(8).putLong(nonce).array(), methodName));
                                    byte[] expectedResponse = mac.doFinal(lic_licensee.getBytes(Charset.forName("UTF-8")));
                                    respLen = expectedResponse.length;
                                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                                    byte[] buffer = new byte[100];
                                    int len = -1;
                                    while ((len = ((FilterInputStream)in).read(buffer)) != -1) {
                                        bytesOut.write(buffer, 0, len);
                                    }
                                    byte[] respBuffer = bytesOut.toByteArray();
                                    byte[] response = Utils.analyseAgentResponse((byte[])respBuffer);
                                    if (Arrays.equals(response, expectedResponse)) {
                                        break block153;
                                    }
                                    throw new Exception(new String(response));
                                }
                                catch (IOException ex) {
                                    throw ex;
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (in != null) {
                                        try {
                                            ((BufferedInputStream)in).close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (socket != null) {
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                        }
                        lic_granted = lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0;
                        lic_address = -1;
                    }
                    catch (Throwable _ex) {
                        lic_granted = -1;
                        System.out.println(_ex.getMessage());
                        _ex.printStackTrace();
                    }
                }
                boolean bl = isNormal = !lic_center;
                if (!isNormal || "Virtual Edition".equals(lic_edition)) break block154;
                Throwable taddr = null;
                try {
                    lic_granted = 2130706435;
                    if (lic_version >= 2) {
                        boolean ck = false;
                        if (lic_aowedIPs != null && !"".equals(lic_aowedIPs)) {
                            in = lic_aowedIPs;
                            String regEx = new StringBuffer("^").append((String)in).append("\\.").append(".*$").toString();
                            Pattern p = Pattern.compile(regEx);
                            InetAddress lh = InetAddress.getLocalHost();
                            String ip = lh.getHostAddress();
                            byte[] adds = lh.getAddress();
                            if (p.matcher(ip).matches()) {
                                ck = true;
                            } else {
                                Enumeration<NetworkInterface> netInts = NetworkInterface.getNetworkInterfaces();
                                while (netInts.hasMoreElements() && !ck) {
                                    NetworkInterface networkInterface = netInts.nextElement();
                                    Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                                    while (ips.hasMoreElements() && !ck) {
                                        lh = ips.nextElement();
                                        adds = lh.getAddress();
                                        String tip = lh.getHostAddress();
                                        if (!p.matcher(tip).matches()) continue;
                                        ck = true;
                                    }
                                }
                            }
                            if (!ck) {
                                lic_address = ((adds[0] & 0xFF) << 24) + ((adds[1] & 0xFF) << 16) + ((adds[2] & 0xFF) << 8) + ((adds[3] & 0xFF) << 0);
                                throw new Exception("error");
                            }
                        }
                        if (lic_address != -1 && !lic_addressStr.equals("255.255.255.255")) {
                            lic_ip = lic_address == 0 ? lic_addressStr : lic_ip;
                            InetAddress _addr = InetAddress.getByName(lic_ip);
                            ServerSocket _ss = new ServerSocket(0, 1, _addr);
                            _ss.close();
                        }
                    }
                    if (lic_version == 1) {
                        boolean ck = false;
                        List ips = MacMain.getLocalIPs();
                        ips.add(new StringBuffer("255").append(".255").append(".255").append(".255").toString());
                        for (String ip : ips) {
                            if (!lic_addressStr.equals(MacMain.getSoftCode((String)ip))) continue;
                            ck = true;
                            break;
                        }
                        if (!"10.1.2".startsWith(lic_prodversion)) {
                            System.out.println("v");
                            ck = false;
                        }
                        if (!ck) {
                            throw new Exception("rror");
                        }
                    }
                }
                catch (Throwable _ex) {
                    taddr = _ex;
                }
                if (taddr == null) {
                    long _timediff;
                    lic_granted = lic_version == 1 ? (lic_dateend > 0L ? (System.currentTimeMillis() >= lic_datefrom && System.currentTimeMillis() <= lic_dateend ? 0 : 2130706434) : 0) : (lic_durationDays > 0 ? ((_timediff = System.currentTimeMillis() - lic_datefrom) >= 0L && _timediff < (long)lic_durationDays * 86400L * 1000L ? 0 : 2130706434) : 0);
                }
            }
            catch (Throwable _ex0) {
                System.out.println(_ex0.getMessage());
            }
        }
        if (lic_version != 50 && !"Apusic Application Server".equals(lic_prodname) || lic_granted != 0) {
            System.err.println(new StringBuffer("lice").append("nse is in").append("valid.").toString());
            System.exit(1);
        }
    }
}

