/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.connector.http2;

import com.apusic.connector.Response;
import com.apusic.connector.http11.HttpOutputBuffer;
import com.apusic.connector.http11.OutputFilter;
import com.apusic.connector.http2.Stream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Http2OutputBuffer
implements HttpOutputBuffer {
    private final Response connectorResponse;
    private HttpOutputBuffer next;

    public void addFilter(OutputFilter filter) {
        filter.setBuffer(this.next);
        this.next = filter;
    }

    public Http2OutputBuffer(Response connectorResponse, Stream.StreamOutputBuffer streamOutputBuffer) {
        this.connectorResponse = connectorResponse;
        this.next = streamOutputBuffer;
    }

    @Override
    public int doWrite(ByteBuffer chunk) throws IOException {
        if (!this.connectorResponse.isCommitted()) {
            this.connectorResponse.sendHeaders();
        }
        return this.next.doWrite(chunk);
    }

    @Override
    public long getBytesWritten() {
        return this.next.getBytesWritten();
    }

    @Override
    public void end() throws IOException {
        this.next.end();
    }

    @Override
    public void flush() throws IOException {
        this.next.flush();
    }
}

