/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.boot.web.embedded.ams;

import com.apusic.ams.Valve;
import com.apusic.ams.valves.AccessLogValve;
import com.apusic.ams.valves.ErrorReportValve;
import com.apusic.ams.valves.RemoteIpValve;
import com.apusic.boot.web.embedded.ams.AasServletWebServerFactory;
import com.apusic.boot.web.embedded.ams.ConfigurableAasWebServerFactory;
import com.apusic.boot.web.embedded.ams.ServerProperties;
import com.apusic.connector.AbstractProtocol;
import com.apusic.connector.ProtocolHandler;
import com.apusic.connector.http11.AbstractHttp11Protocol;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class AASWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableAasWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public AASWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableAasWebServerFactory factory) {
        ServerProperties properties = this.serverProperties;
        ServerProperties.AAS aasProperties = properties.getAAS();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(aasProperties::getBasedir).whenNonNull().to(factory::setBaseDirectory);
        propertyMapper.from(aasProperties::getBackgroundProcessorDelay).whenNonNull().as(Duration::getSeconds).as(Long::intValue).to(factory::setBackgroundProcessorDelay);
        this.customizeRemoteIpValve(factory);
        propertyMapper.from(aasProperties::getMaxThreads).when(this::isPositive).to(maxThreads -> this.customizeMaxThreads(factory, aasProperties.getMaxThreads()));
        propertyMapper.from(aasProperties::getMinSpareThreads).when(this::isPositive).to(minSpareThreads -> this.customizeMinThreads(factory, (int)minSpareThreads));
        propertyMapper.from(this::determineMaxHttpHeaderSize).when(this::isPositive).to(maxHttpHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (int)maxHttpHeaderSize));
        propertyMapper.from(aasProperties::getMaxSwallowSize).to(maxSwallowSize -> this.customizeMaxSwallowSize(factory, (int)maxSwallowSize));
        propertyMapper.from(aasProperties::getMaxHttpPostSize).when(maxHttpPostSize -> maxHttpPostSize != 0).to(maxHttpPostSize -> this.customizeMaxHttpPostSize(factory, (int)maxHttpPostSize));
        propertyMapper.from(aasProperties::getAccesslog).when(ServerProperties.AAS.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(factory));
        propertyMapper.from(aasProperties::getUriEncoding).whenNonNull().to(factory::setUriEncoding);
        propertyMapper.from(properties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        propertyMapper.from(aasProperties::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(factory, (int)maxConnections));
        propertyMapper.from(aasProperties::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory, (int)acceptCount));
        this.customizeStaticResources(factory);
        this.customizeErrorReportValve(properties.getError(), factory);
        if (null != aasProperties.getRelaxedPathChars()) {
            this.customizeRelaxedPathChars(factory, aasProperties.getRelaxedPathChars());
        }
        if (null != aasProperties.getRelaxedQueryChars()) {
            this.customizeRelaxedQueryChars(factory, aasProperties.getRelaxedQueryChars());
        }
        if (aasProperties.getLicensePath() != null) {
            System.setProperty("licpath", aasProperties.getLicensePath());
        }
        propertyMapper.from(aasProperties::getMaxKeepaliveTimeout).when(this::isPositive).to(maxKeepaliveTimeout -> this.customizeMaxKeepaliveTimeout(factory, (int)maxKeepaliveTimeout));
        propertyMapper.from(aasProperties::isEnableLookups).to(enableLookups -> this.customizeEnableLookups(factory, (boolean)enableLookups));
        propertyMapper.from(aasProperties::getMaxKeepaliveRequests).to(maxKeepaliveRequests -> this.customizeMaxKeepaliveRequests(factory, (int)maxKeepaliveRequests));
        this.customizeCompression(factory, aasProperties.isCompression(), aasProperties.getCompressableMimeType(), aasProperties.getCompressionMinSize());
        this.customizeDisableUploadTimeout(factory, aasProperties.isDisableUploadTimeout());
        this.customizeUseSendfile(factory, aasProperties.isUseSendfile());
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    private Integer determineMaxHttpHeaderSize() {
        return this.serverProperties.getAAS().getMaxHttpHeaderSize() > 0 ? this.serverProperties.getAAS().getMaxHttpHeaderSize() : this.serverProperties.getMaxHttpHeaderSize();
    }

    private void customizeAcceptCount(ConfigurableAasWebServerFactory factory, int acceptCount) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setAcceptCount(acceptCount);
            }
        });
    }

    private void customizeMaxConnections(ConfigurableAasWebServerFactory factory, int maxConnections) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxConnections(maxConnections);
            }
        });
    }

    private void customizeConnectionTimeout(ConfigurableAasWebServerFactory factory, Duration connectionTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setConnectionTimeout((int)connectionTimeout.toMillis());
            }
        });
    }

    private void customizeRemoteIpValve(ConfigurableAasWebServerFactory factory) {
        ServerProperties.AAS aasProperties = this.serverProperties.getAAS();
        String protocolHeader = aasProperties.getProtocolHeader();
        String remoteIpHeader = aasProperties.getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setInternalProxies(aasProperties.getInternalProxies());
            valve.setPortHeader(aasProperties.getPortHeader());
            valve.setProtocolHeaderHttpsValue(aasProperties.getProtocolHeaderHttpsValue());
            factory.addEngineValves(new Valve[]{valve});
        }
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.isUseForwardHeaders() != null) {
            return this.serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
        return platform != null && platform.isUsingForwardHeaders();
    }

    private void customizeMaxThreads(ConfigurableAasWebServerFactory factory, int maxThreads) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxThreads(maxThreads);
            }
        });
    }

    private void customizeMinThreads(ConfigurableAasWebServerFactory factory, int minSpareThreads) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMinSpareThreads(minSpareThreads);
            }
        });
    }

    private void customizeMaxHttpHeaderSize(ConfigurableAasWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        });
    }

    private void customizeMaxSwallowSize(ConfigurableAasWebServerFactory factory, int maxSwallowSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxSwallowSize(maxSwallowSize);
            }
        });
    }

    private void customizeMaxHttpPostSize(ConfigurableAasWebServerFactory factory, int maxHttpPostSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpPostSize));
    }

    private void customizeAccessLog(ConfigurableAasWebServerFactory factory) {
        ServerProperties.AAS aasProperties = this.serverProperties.getAAS();
        AccessLogValve valve = new AccessLogValve();
        valve.setPattern(aasProperties.getAccesslog().getPattern());
        valve.setDirectory(aasProperties.getAccesslog().getDirectory());
        valve.setPrefix(aasProperties.getAccesslog().getPrefix());
        valve.setSuffix(aasProperties.getAccesslog().getSuffix());
        valve.setRenameOnRotate(aasProperties.getAccesslog().isRenameOnRotate());
        valve.setFileDateFormat(aasProperties.getAccesslog().getFileDateFormat());
        valve.setRequestAttributesEnabled(aasProperties.getAccesslog().isRequestAttributesEnabled());
        valve.setRotatable(aasProperties.getAccesslog().isRotate());
        valve.setBuffered(aasProperties.getAccesslog().isBuffered());
        factory.addEngineValves(new Valve[]{valve});
    }

    private void customizeStaticResources(ConfigurableAasWebServerFactory factory) {
        ServerProperties.AAS.Resource resource = this.serverProperties.getAAS().getResource();
        factory.addContextCustomizers(context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                context.getResources().setCachingAllowed(resource.isAllowCaching());
                if (resource.getCacheTtl() != null) {
                    long ttl = resource.getCacheTtl().toMillis();
                    context.getResources().setCacheTtl(ttl);
                }
            }
        }));
    }

    private void customizeErrorReportValve(ErrorProperties error, ConfigurableAasWebServerFactory factory) {
        Object includeStacktrace = null;
        Method getIncludeStacktraceMethod = null;
        Object getIncludeStacktrace = null;
        try {
            Field field = error.getClass().getDeclaredField("includeStacktrace");
            field.setAccessible(true);
            includeStacktrace = field.get(error);
            getIncludeStacktraceMethod = error.getClass().getDeclaredMethod("getIncludeStacktrace", new Class[0]);
            getIncludeStacktrace = getIncludeStacktraceMethod.invoke((Object)error, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (getIncludeStacktrace == includeStacktrace) {
            factory.addContextCustomizers(context -> {
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowServerInfo(false);
                valve.setShowReport(false);
                context.getParent().getPipeline().addValve((Valve)valve);
            });
        }
    }

    private void customizeMaxKeepaliveRequests(ConfigurableAasWebServerFactory factory, int maxKeepaliveRequests) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxKeepAliveRequests(maxKeepaliveRequests);
            }
        });
    }

    private void customizeMaxKeepaliveTimeout(ConfigurableAasWebServerFactory factory, int keepaliveTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setKeepAliveTimeout(keepaliveTimeout);
            }
        });
    }

    private void customizeEnableLookups(ConfigurableAasWebServerFactory factory, boolean enableLookups) {
        factory.addConnectorCustomizers(connector -> connector.setEnableLookups(enableLookups));
    }

    private void customizeCompression(ConfigurableAasWebServerFactory factory, boolean compress, String compressableMimeType, int compressionMinSize) {
        Compression compression = new Compression();
        compression.setEnabled(compress);
        if (null != compressableMimeType) {
            compression.setMimeTypes(compressableMimeType.split(","));
        }
        if (compressionMinSize >= 0) {
            boolean newVersion = false;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("org.springframework.util.unit.DataSize");
                compression.getClass().getDeclaredMethod("setMinResponseSize", clazz);
                newVersion = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (newVersion) {
                    Method method = compression.getClass().getDeclaredMethod("setMinResponseSize", clazz);
                    Method staticMethod = clazz.getMethod("ofBytes", Long.TYPE);
                    method.invoke((Object)compression, staticMethod.invoke(null, compressionMinSize));
                } else {
                    Method method = compression.getClass().getDeclaredMethod("setMinResponseSize", Integer.TYPE);
                    method.invoke((Object)compression, compressionMinSize);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (factory instanceof AasServletWebServerFactory) {
            ((AasServletWebServerFactory)factory).setCustomCompression(compression);
        }
        this.serverProperties.setCompression(compression);
    }

    private void customizeDisableUploadTimeout(ConfigurableAasWebServerFactory factory, boolean disableUploadTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setDisableUploadTimeout(disableUploadTimeout);
            }
        });
    }

    private void customizeRelaxedPathChars(ConfigurableAasWebServerFactory factory, String relaxedPathChars) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setRelaxedPathChars(relaxedPathChars);
            }
        });
    }

    private void customizeRelaxedQueryChars(ConfigurableAasWebServerFactory factory, String relaxedQueryChars) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setRelaxedQueryChars(relaxedQueryChars);
            }
        });
    }

    private void customizeUseSendfile(ConfigurableAasWebServerFactory factory, boolean useSendfile) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setUseSendfile(useSendfile);
            }
        });
    }
}

