/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.boot.web.embedded.ams;

import com.apusic.ams.Container;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.Manager;
import com.apusic.ams.SessionIdGenerator;
import com.apusic.ams.Wrapper;
import com.apusic.ams.core.StandardContext;
import com.apusic.ams.core.StandardWrapper;
import com.apusic.ams.session.ManagerBase;
import com.apusic.boot.web.embedded.ams.AasStarter;
import com.apusic.boot.web.embedded.ams.LazySessionIdGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ClassUtils;

class AasEmbeddedContext
extends StandardContext {
    private AasStarter starter;

    AasEmbeddedContext() {
    }

    public boolean loadOnStartup(Container[] children) {
        return true;
    }

    public void setManager(Manager manager) {
        if (manager instanceof ManagerBase) {
            ((ManagerBase)manager).setSessionIdGenerator((SessionIdGenerator)new LazySessionIdGenerator());
        }
        super.setManager(manager);
    }

    public void deferredLoadOnStartup() throws LifecycleException {
        this.doWithThreadContextClassLoader(this.getLoader().getClassLoader(), () -> this.getLoadOnStartupWrappers(this.findChildren()).forEach(this::load));
    }

    private Stream<Wrapper> getLoadOnStartupWrappers(Container[] children) {
        TreeMap<Integer, List> grouped = new TreeMap<Integer, List>();
        for (Container child : children) {
            Wrapper wrapper = (Wrapper)child;
            int order = wrapper.getLoadOnStartup();
            if (order < 0) continue;
            grouped.computeIfAbsent(order, ArrayList::new);
            ((List)grouped.get(order)).add(wrapper);
        }
        return grouped.values().stream().flatMap(Collection::stream);
    }

    private void load(Wrapper wrapper) {
        try {
            wrapper.load();
        }
        catch (ServletException ex) {
            String message = sm.getString("standardContext.loadOnStartup.loadException", new Object[]{this.getName(), wrapper.getName()});
            if (this.getComputedFailCtxIfServletStartFails()) {
                throw new WebServerException(message, (Throwable)ex);
            }
            this.getLogger().error((Object)message, StandardWrapper.getRootCause((ServletException)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithThreadContextClassLoader(ClassLoader classLoader, Runnable code) {
        ClassLoader existingLoader = classLoader != null ? ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader) : null;
        try {
            code.run();
        }
        finally {
            if (existingLoader != null) {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)existingLoader);
            }
        }
    }

    public void setStarter(AasStarter starter) {
        this.starter = starter;
    }

    public AasStarter getStarter() {
        return this.starter;
    }
}

