/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.boot.web.embedded.ams;

import com.apusic.aas.JarScanFilter;
import com.apusic.aas.util.scan.StandardJarScanFilter;
import com.apusic.ams.Container;
import com.apusic.ams.Context;
import com.apusic.ams.Engine;
import com.apusic.ams.Host;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.Loader;
import com.apusic.ams.Valve;
import com.apusic.ams.connector.Connector;
import com.apusic.ams.core.AprLifecycleListener;
import com.apusic.ams.loader.WebappLoader;
import com.apusic.ams.startup.Aas;
import com.apusic.boot.web.embedded.ams.AasConnectorCustomizer;
import com.apusic.boot.web.embedded.ams.AasContextCustomizer;
import com.apusic.boot.web.embedded.ams.AasEmbeddedContext;
import com.apusic.boot.web.embedded.ams.AasEmbeddedWebappClassLoader;
import com.apusic.boot.web.embedded.ams.AasWebServer;
import com.apusic.boot.web.embedded.ams.CompressionConnectorCustomizer;
import com.apusic.boot.web.embedded.ams.ConfigurableAasWebServerFactory;
import com.apusic.boot.web.embedded.ams.DisableReferenceClearingContextCustomizer;
import com.apusic.boot.web.embedded.ams.SslConnectorCustomizer;
import com.apusic.connector.AbstractProtocol;
import com.apusic.connector.UpgradeProtocol;
import com.apusic.connector.http2.Http2Protocol;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.servlet.Servlet;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.AasHttpHandlerAdapter;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import sun.security.action.GetPropertyAction;

public class AasReactiveWebServerFactory
extends AbstractReactiveWebServerFactory
implements ConfigurableAasWebServerFactory {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_PROTOCOL = "com.apusic.connector.http11.Http11Nio2Protocol";
    private File baseDirectory;
    private List<Valve> engineValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = AasReactiveWebServerFactory.getDefaultLifecycleListeners();
    private List<AasContextCustomizer> aasContextCustomizers = new ArrayList<AasContextCustomizer>();
    private List<AasConnectorCustomizer> aasConnectorCustomizers = new ArrayList<AasConnectorCustomizer>();
    private String protocol = "com.apusic.connector.http11.Http11Nio2Protocol";
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;

    public AasReactiveWebServerFactory() {
    }

    public AasReactiveWebServerFactory(int port) {
        super(port);
    }

    private static List<LifecycleListener> getDefaultLifecycleListeners() {
        AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable() ? new ArrayList<AprLifecycleListener>(Arrays.asList(aprLifecycleListener)) : new ArrayList();
    }

    private File createAasTempDir(String prefix) {
        try {
            File tmpDir = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
            prefix = prefix + ".";
            String suffix = "." + this.getPort();
            String rpath = "apusic001";
            if (prefix.length() < 3) {
                throw new IllegalArgumentException("Prefix string too short");
            }
            if (suffix == null) {
                suffix = ".tmp";
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(tmpDir.getAbsolutePath().getBytes());
            rpath = new String(Base64.getUrlEncoder().encode(digest));
            String name = prefix + rpath + suffix;
            File tempDirFile = new File(tmpDir, name);
            tempDirFile.delete();
            tempDirFile.mkdir();
            tempDirFile.deleteOnExit();
            return tempDirFile;
        }
        catch (Exception e) {
            throw new WebServerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), (Throwable)e);
        }
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        Aas aas = new Aas();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createAasTempDir("aas");
        aas.setBaseDir(baseDir.getAbsolutePath());
        Connector connector = new Connector(this.protocol);
        aas.getService().addConnector(connector);
        this.customizeConnector(connector);
        aas.setConnector(connector);
        aas.getHost().setAutoDeploy(false);
        this.configureEngine(aas.getEngine());
        AasHttpHandlerAdapter servlet = new AasHttpHandlerAdapter(httpHandler);
        this.prepareContext(aas.getHost(), servlet);
        return this.getAasWebServer(aas);
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void prepareContext(Host host, AasHttpHandlerAdapter servlet) {
        File docBase = this.createAasTempDir("aas-docbase");
        AasEmbeddedContext context = new AasEmbeddedContext();
        context.setPath("");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new Aas.FixContextListener());
        context.setParentClassLoader(ClassUtils.getDefaultClassLoader());
        this.skipAllTldScanning(context);
        WebappLoader loader = new WebappLoader(context.getParentClassLoader());
        loader.setLoaderClass(AasEmbeddedWebappClassLoader.class.getName());
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        Aas.addServlet((Context)context, (String)"httpHandlerServlet", (Servlet)servlet).setAsyncSupported(true);
        context.addServletMappingDecoded("/", "httpHandlerServlet");
        host.addChild((Container)context);
        this.configureContext((Context)context);
    }

    private void skipAllTldScanning(AasEmbeddedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip("*.jar");
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    protected void configureContext(Context context) {
        this.contextLifecycleListeners.forEach(arg_0 -> ((Context)context).addLifecycleListener(arg_0));
        new DisableReferenceClearingContextCustomizer().customize(context);
        this.aasContextCustomizers.forEach(customizer -> customizer.customize(context));
    }

    protected void customizeConnector(Connector connector) {
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setAttribute("server", (Object)this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.getCompression());
        compression.customize(connector);
        for (AasConnectorCustomizer customizer : this.aasConnectorCustomizers) {
            customizer.customize(connector);
        }
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void customizeSsl(Connector connector) {
        new SslConnectorCustomizer(this.getSsl(), this.getSslStoreProvider()).customize(connector);
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    public void setAasContextCustomizers(Collection<? extends AasContextCustomizer> aasContextCustomizers) {
        Assert.notNull(aasContextCustomizers, (String)"AasContextCustomizers must not be null");
        this.aasContextCustomizers = new ArrayList<AasContextCustomizer>(aasContextCustomizers);
    }

    public Collection<AasContextCustomizer> getAasContextCustomizers() {
        return this.aasContextCustomizers;
    }

    @Override
    public void addContextCustomizers(AasContextCustomizer ... aasContextCustomizers) {
        Assert.notNull((Object)aasContextCustomizers, (String)"AasContextCustomizers must not be null");
        this.aasContextCustomizers.addAll(Arrays.asList(aasContextCustomizers));
    }

    public void setAasConnectorCustomizers(Collection<? extends AasConnectorCustomizer> aasConnectorCustomizers) {
        Assert.notNull(aasConnectorCustomizers, (String)"AasConnectorCustomizers must not be null");
        this.aasConnectorCustomizers = new ArrayList<AasConnectorCustomizer>(aasConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(AasConnectorCustomizer ... aasConnectorCustomizers) {
        Assert.notNull((Object)aasConnectorCustomizers, (String)"AasConnectorCustomizers must not be null");
        this.aasConnectorCustomizers.addAll(Arrays.asList(aasConnectorCustomizers));
    }

    public Collection<AasConnectorCustomizer> getAasConnectorCustomizers() {
        return this.aasConnectorCustomizers;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public List<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    protected AasWebServer getAasWebServer(Aas aas) {
        return new AasWebServer(aas, this.getPort() >= 0);
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }
}

