/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.boot.web.embedded.ams;

import com.apusic.aas.JarScanFilter;
import com.apusic.aas.util.scan.StandardJarScanFilter;
import com.apusic.ams.Container;
import com.apusic.ams.Context;
import com.apusic.ams.Engine;
import com.apusic.ams.Host;
import com.apusic.ams.LifecycleEvent;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleListener;
import com.apusic.ams.Loader;
import com.apusic.ams.Manager;
import com.apusic.ams.Valve;
import com.apusic.ams.WebResource;
import com.apusic.ams.WebResourceRoot;
import com.apusic.ams.WebResourceSet;
import com.apusic.ams.Wrapper;
import com.apusic.ams.connector.Connector;
import com.apusic.ams.core.AprLifecycleListener;
import com.apusic.ams.loader.WebappLoader;
import com.apusic.ams.session.StandardManager;
import com.apusic.ams.startup.Aas;
import com.apusic.ams.util.LifecycleBase;
import com.apusic.ams.webresources.AbstractResourceSet;
import com.apusic.ams.webresources.EmptyResource;
import com.apusic.ams.webresources.StandardRoot;
import com.apusic.boot.web.embedded.ams.AasConnectorCustomizer;
import com.apusic.boot.web.embedded.ams.AasContextCustomizer;
import com.apusic.boot.web.embedded.ams.AasEmbeddedContext;
import com.apusic.boot.web.embedded.ams.AasEmbeddedWebappClassLoader;
import com.apusic.boot.web.embedded.ams.AasErrorPage;
import com.apusic.boot.web.embedded.ams.AasStarter;
import com.apusic.boot.web.embedded.ams.AasWebServer;
import com.apusic.boot.web.embedded.ams.CompressionConnectorCustomizer;
import com.apusic.boot.web.embedded.ams.ConfigurableAasWebServerFactory;
import com.apusic.boot.web.embedded.ams.DisableReferenceClearingContextCustomizer;
import com.apusic.boot.web.embedded.ams.SslConnectorCustomizer;
import com.apusic.boot.web.embedded.ams.TldSkipPatterns;
import com.apusic.connector.AbstractProtocol;
import com.apusic.connector.UpgradeProtocol;
import com.apusic.connector.http2.Http2Protocol;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContainerInitializer;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import sun.security.action.GetPropertyAction;

public class AasServletWebServerFactory
extends AbstractServletWebServerFactory
implements ConfigurableAasWebServerFactory,
ResourceLoaderAware {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    public static final String DEFAULT_PROTOCOL = "com.apusic.connector.http11.Http11NioProtocol";
    private File baseDirectory;
    private List<Valve> engineValves = new ArrayList<Valve>();
    private List<Valve> contextValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = AasServletWebServerFactory.getDefaultLifecycleListeners();
    private List<AasContextCustomizer> aasContextCustomizers = new ArrayList<AasContextCustomizer>();
    private List<AasConnectorCustomizer> aasConnectorCustomizers = new ArrayList<AasConnectorCustomizer>();
    private List<Connector> additionalAasConnectors = new ArrayList<Connector>();
    private ResourceLoader resourceLoader;
    private String protocol = "com.apusic.connector.http11.Http11NioProtocol";
    private Set<String> tldSkipPatterns = new LinkedHashSet<String>(TldSkipPatterns.DEFAULT);
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;

    public AasServletWebServerFactory() {
    }

    public AasServletWebServerFactory(int port) {
        super(port);
    }

    public AasServletWebServerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    private static List<LifecycleListener> getDefaultLifecycleListeners() {
        AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable() ? new ArrayList<AprLifecycleListener>(Arrays.asList(aprLifecycleListener)) : new ArrayList();
    }

    private File createAasTempDir(String prefix) {
        try {
            File tmpDir = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
            prefix = prefix + ".";
            String suffix = "." + this.getPort();
            String rpath = "apusic001";
            if (prefix.length() < 3) {
                throw new IllegalArgumentException("Prefix string too short");
            }
            if (suffix == null) {
                suffix = ".tmp";
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(tmpDir.getAbsolutePath().getBytes());
            rpath = new String(Base64.getUrlEncoder().encode(digest));
            String name = prefix + rpath + suffix;
            File tempDirFile = new File(tmpDir, name);
            tempDirFile.delete();
            tempDirFile.mkdir();
            tempDirFile.deleteOnExit();
            return tempDirFile;
        }
        catch (Exception e) {
            throw new WebServerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), (Throwable)e);
        }
    }

    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        Aas aas = new Aas();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createAasTempDir("aas");
        aas.setBaseDir(baseDir.getAbsolutePath());
        Connector connector = new Connector(this.protocol);
        aas.getService().addConnector(connector);
        this.customizeConnector(connector);
        aas.setConnector(connector);
        aas.getHost().setAutoDeploy(false);
        this.configureEngine(aas.getEngine());
        for (Connector additionalConnector : this.additionalAasConnectors) {
            aas.getService().addConnector(additionalConnector);
        }
        this.prepareContext(aas.getHost(), initializers);
        return this.getAasWebServer(aas);
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        File documentRoot = this.getValidDocumentRoot();
        AasEmbeddedContext context = new AasEmbeddedContext();
        if (documentRoot != null) {
            context.setResources((WebResourceRoot)new LoaderHidingResourceRoot(context));
        }
        context.setName(this.getContextPath());
        context.setDisplayName(this.getDisplayName());
        context.setPath(this.getContextPath());
        File docBase = documentRoot != null ? documentRoot : this.createAasTempDir("aas-docbase");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new Aas.FixContextListener());
        context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
        this.resetDefaultLocaleMapping(context);
        this.addLocaleMappings(context);
        context.setUseRelativeRedirects(false);
        try {
            context.setCreateUploadTargets(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.configureTldSkipPatterns(context);
        WebappLoader loader = new WebappLoader(context.getParentClassLoader());
        loader.setLoaderClass(AasEmbeddedWebappClassLoader.class.getName());
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet((Context)context);
        }
        if (null != this.getJsp()) {
            this.getJsp().setClassName("com.apusic.jasper.servlet.JspServlet");
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet((Context)context);
            this.addJasperInitializer(context);
        }
        context.addLifecycleListener(new StaticResourceConfigurer((Context)context));
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        host.addChild((Container)context);
        this.configureContext((Context)context, initializersToUse);
        this.postProcessContext((Context)context);
    }

    private void resetDefaultLocaleMapping(AasEmbeddedContext context) {
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), DEFAULT_CHARSET.displayName());
    }

    private void addLocaleMappings(AasEmbeddedContext context) {
        this.getLocaleCharsetMappings().forEach((locale, charset) -> context.addLocaleEncodingMappingParameter(locale.toString(), charset.toString()));
    }

    private void configureTldSkipPatterns(AasEmbeddedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(this.tldSkipPatterns));
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("com.apusic.ams.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)defaultServlet);
        context.addServletMappingDecoded("/", "default");
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.getJsp().getClassName());
        jspServlet.addInitParameter("fork", "false");
        this.getJsp().getInitParameters().forEach((arg_0, arg_1) -> ((Wrapper)jspServlet).addInitParameter(arg_0, arg_1));
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)jspServlet);
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
    }

    private void addJasperInitializer(AasEmbeddedContext context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"com.apusic.jasper.servlet.JasperInitializer", null).newInstance();
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void customizeConnector(Connector connector) {
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setAttribute("server", (Object)this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.getCompression());
        compression.customize(connector);
        for (AasConnectorCustomizer customizer : this.aasConnectorCustomizers) {
            customizer.customize(connector);
        }
    }

    public void setCompression(Compression compression) {
    }

    public void setCustomCompression(Compression compression) {
        super.setCompression(compression);
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void customizeSsl(Connector connector) {
        new SslConnectorCustomizer(this.getSsl(), this.getSslStoreProvider()).customize(connector);
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
    }

    protected void configureContext(Context context, ServletContextInitializer[] initializers) {
        AasStarter starter = new AasStarter(initializers);
        if (context instanceof AasEmbeddedContext) {
            AasEmbeddedContext embeddedContext = (AasEmbeddedContext)context;
            embeddedContext.setStarter(starter);
            embeddedContext.setFailCtxIfServletStartFails(true);
        }
        context.addServletContainerInitializer((ServletContainerInitializer)starter, NO_CLASSES);
        for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : this.contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            new AasErrorPage(errorPage).addToContext(context);
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        this.configureSession(context);
        new DisableReferenceClearingContextCustomizer().customize(context);
        for (AasContextCustomizer customizer : this.aasContextCustomizers) {
            customizer.customize(context);
        }
    }

    private void configureSession(Context context) {
        long sessionTimeout = this.getSessionTimeoutInMinutes();
        context.setSessionTimeout((int)sessionTimeout);
        Boolean httpOnly = this.getSession().getCookie().getHttpOnly();
        if (httpOnly != null) {
            context.setUseHttpOnly(httpOnly.booleanValue());
        }
        if (this.getSession().isPersistent()) {
            Manager manager = context.getManager();
            if (manager == null) {
                manager = new StandardManager();
                context.setManager(manager);
            }
            this.configurePersistSession(manager);
        } else {
            context.addLifecycleListener((LifecycleListener)new DisablePersistSessionListener());
        }
    }

    private void configurePersistSession(Manager manager) {
        Assert.state((boolean)(manager instanceof StandardManager), () -> "Unable to persist HTTP session state using manager type " + manager.getClass().getName());
        File dir = this.getValidSessionStoreDir();
        File file = new File(dir, "SESSIONS.ser");
        ((StandardManager)manager).setPathname(file.getAbsolutePath());
    }

    private long getSessionTimeoutInMinutes() {
        Duration sessionTimeout = this.getSession().getTimeout();
        if (this.isZeroOrLess(sessionTimeout)) {
            return 0L;
        }
        return Math.max(sessionTimeout.toMinutes(), 1L);
    }

    private boolean isZeroOrLess(Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative() || sessionTimeout.isZero();
    }

    protected void postProcessContext(Context context) {
    }

    protected AasWebServer getAasWebServer(Aas aas) {
        return new AasWebServer(aas, this.getPort() >= 0);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public Set<String> getTldSkipPatterns() {
        return this.tldSkipPatterns;
    }

    public void setTldSkipPatterns(Collection<String> patterns) {
        Assert.notNull(patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns = new LinkedHashSet<String>(patterns);
    }

    public void addTldSkipPatterns(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns.addAll(Arrays.asList(patterns));
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }

    public void setEngineValves(Collection<? extends Valve> engineValves) {
        Assert.notNull(engineValves, (String)"Valves must not be null");
        this.engineValves = new ArrayList<Valve>(engineValves);
    }

    public Collection<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public void setContextValves(Collection<? extends Valve> contextValves) {
        Assert.notNull(contextValves, (String)"Valves must not be null");
        this.contextValves = new ArrayList<Valve>(contextValves);
    }

    public Collection<Valve> getContextValves() {
        return this.contextValves;
    }

    public void addContextValves(Valve ... contextValves) {
        Assert.notNull((Object)contextValves, (String)"Valves must not be null");
        this.contextValves.addAll(Arrays.asList(contextValves));
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    public void setAasContextCustomizers(Collection<? extends AasContextCustomizer> aasContextCustomizers) {
        Assert.notNull(aasContextCustomizers, (String)"AasContextCustomizers must not be null");
        this.aasContextCustomizers = new ArrayList<AasContextCustomizer>(aasContextCustomizers);
    }

    public Collection<AasContextCustomizer> getAasContextCustomizers() {
        return this.aasContextCustomizers;
    }

    @Override
    public void addContextCustomizers(AasContextCustomizer ... aasContextCustomizers) {
        Assert.notNull((Object)aasContextCustomizers, (String)"AasContextCustomizers must not be null");
        this.aasContextCustomizers.addAll(Arrays.asList(aasContextCustomizers));
    }

    public void setAasConnectorCustomizers(Collection<? extends AasConnectorCustomizer> aasConnectorCustomizers) {
        Assert.notNull(aasConnectorCustomizers, (String)"AasConnectorCustomizers must not be null");
        this.aasConnectorCustomizers = new ArrayList<AasConnectorCustomizer>(aasConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(AasConnectorCustomizer ... aasConnectorCustomizers) {
        Assert.notNull((Object)aasConnectorCustomizers, (String)"AasConnectorCustomizers must not be null");
        this.aasConnectorCustomizers.addAll(Arrays.asList(aasConnectorCustomizers));
    }

    public Collection<AasConnectorCustomizer> getAasConnectorCustomizers() {
        return this.aasConnectorCustomizers;
    }

    public void addAdditionalAasConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, (String)"Connectors must not be null");
        this.additionalAasConnectors.addAll(Arrays.asList(connectors));
    }

    public List<Connector> getAdditionalAasConnectors() {
        return this.additionalAasConnectors;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    private static final class LoaderHidingWebResourceSet
    extends AbstractResourceSet {
        private final WebResourceSet delegate;
        private final Method initInternal;

        private LoaderHidingWebResourceSet(WebResourceSet delegate) {
            this.delegate = delegate;
            try {
                this.initInternal = LifecycleBase.class.getDeclaredMethod("initInternal", new Class[0]);
                this.initInternal.setAccessible(true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        public WebResource getResource(String path) {
            if (path.startsWith("/org/springframework/boot")) {
                return new EmptyResource(this.getRoot(), path);
            }
            return this.delegate.getResource(path);
        }

        public String[] list(String path) {
            return this.delegate.list(path);
        }

        public Set<String> listWebAppPaths(String path) {
            return this.delegate.listWebAppPaths(path).stream().filter(webAppPath -> !webAppPath.startsWith("/org/springframework/boot")).collect(Collectors.toSet());
        }

        public boolean mkdir(String path) {
            return this.delegate.mkdir(path);
        }

        public boolean write(String path, InputStream is, boolean overwrite) {
            return this.delegate.write(path, is, overwrite);
        }

        public URL getBaseUrl() {
            return this.delegate.getBaseUrl();
        }

        public void setReadOnly(boolean readOnly) {
            this.delegate.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        public void gc() {
            this.delegate.gc();
        }

        protected void initInternal() throws LifecycleException {
            if (this.delegate instanceof LifecycleBase) {
                try {
                    ReflectionUtils.invokeMethod((Method)this.initInternal, (Object)this.delegate);
                }
                catch (Exception ex) {
                    throw new LifecycleException((Throwable)ex);
                }
            }
        }
    }

    private static final class LoaderHidingResourceRoot
    extends StandardRoot {
        private LoaderHidingResourceRoot(AasEmbeddedContext context) {
            super((Context)context);
        }

        protected WebResourceSet createMainResourceSet() {
            return new LoaderHidingWebResourceSet(super.createMainResourceSet());
        }
    }

    private final class StaticResourceConfigurer
    implements LifecycleListener {
        private final Context context;

        private StaticResourceConfigurer(Context context) {
            this.context = context;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                this.addResourceJars(AasServletWebServerFactory.this.getUrlsOfJarsWithMetaInfResources());
            }
        }

        private void addResourceJars(List<URL> resourceJarUrls) {
            for (URL url : resourceJarUrls) {
                String path = url.getPath();
                if (path.endsWith(".jar") || path.endsWith(".jar!/")) {
                    String jar = url.toString();
                    if (!jar.startsWith("jar:")) {
                        jar = "jar:" + jar + "!/";
                    }
                    this.addResourceSet(jar);
                    continue;
                }
                this.addResourceSet(url.toString());
            }
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }

    private static class DisablePersistSessionListener
    implements LifecycleListener {
        private DisablePersistSessionListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Context context;
            Manager manager;
            if (event.getType().equals("start") && (manager = (context = (Context)event.getLifecycle()).getManager()) != null && manager instanceof StandardManager) {
                ((StandardManager)manager).setPathname(null);
            }
        }
    }
}

