/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.boot.web.embedded.ams;

import com.apusic.ams.Container;
import com.apusic.ams.Context;
import com.apusic.ams.Engine;
import com.apusic.ams.LifecycleException;
import com.apusic.ams.LifecycleState;
import com.apusic.ams.Service;
import com.apusic.ams.connector.Connector;
import com.apusic.ams.core.StandardContext;
import com.apusic.ams.startup.Aas;
import com.apusic.boot.web.embedded.ams.AasEmbeddedContext;
import com.apusic.boot.web.embedded.ams.AasEmbeddedWebappClassLoader;
import com.apusic.boot.web.embedded.ams.AasStarter;
import com.apusic.boot.web.embedded.ams.ConnectorStartFailedException;
import com.apusic.naming.ContextBindings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.Assert;

public class AasWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(AasWebServer.class);
    private static final AtomicInteger containerCounter = new AtomicInteger(-1);
    private final Object monitor = new Object();
    private final Map<Service, Connector[]> serviceConnectors = new HashMap<Service, Connector[]>();
    private final Aas aas;
    private final boolean autoStart;
    private volatile boolean started;

    public AasWebServer(Aas aas) {
        this(aas, true);
    }

    public AasWebServer(Aas aas, boolean autoStart) {
        Assert.notNull((Object)aas, (String)"Aas Server must not be null");
        this.aas = aas;
        this.autoStart = autoStart;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws WebServerException {
        logger.info((Object)("Aas initialized with port(s): " + this.getPortsDescription(false)));
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.addInstanceIdToEngineName();
                Context context = this.findContext();
                context.addLifecycleListener(event -> {
                    if (context.equals(event.getSource()) && "start".equals(event.getType())) {
                        this.removeServiceConnectors();
                    }
                });
                this.aas.start();
                this.rethrowDeferredStartupExceptions();
                try {
                    ContextBindings.bindClassLoader((Object)context, (Object)context.getNamingToken(), (ClassLoader)this.getClass().getClassLoader());
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.startDaemonAwaitThread();
            }
            catch (Exception ex) {
                this.stopSilently();
                this.destroySilently();
                throw new WebServerException("Unable to start embedded Aas", (Throwable)ex);
            }
        }
    }

    private Context findContext() {
        for (Container child : this.aas.getHost().findChildren()) {
            if (!(child instanceof Context)) continue;
            return (Context)child;
        }
        throw new IllegalStateException("The host does not contain a Context");
    }

    private void addInstanceIdToEngineName() {
        int instanceId = containerCounter.incrementAndGet();
        if (instanceId > 0) {
            Engine engine = this.aas.getEngine();
            engine.setName(engine.getName() + "-" + instanceId);
        }
    }

    private void removeServiceConnectors() {
        for (Service service : this.aas.getServer().findServices()) {
            Connector[] connectors = (Connector[])service.findConnectors().clone();
            this.serviceConnectors.put(service, connectors);
            for (Connector connector : connectors) {
                service.removeConnector(connector);
            }
        }
    }

    private void rethrowDeferredStartupExceptions() throws Exception {
        Container[] children;
        for (Container container : children = this.aas.getHost().findChildren()) {
            Exception exception;
            AasStarter aasStarter;
            if (container instanceof AasEmbeddedContext && (aasStarter = ((AasEmbeddedContext)container).getStarter()) != null && (exception = aasStarter.getStartUpException()) != null) {
                throw exception;
            }
            if (LifecycleState.STARTED.equals((Object)container.getState())) continue;
            throw new IllegalStateException(container + " failed to start");
        }
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread("container-" + containerCounter.get()){

            @Override
            public void run() {
                AasWebServer.this.aas.getServer().await();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                this.addPreviouslyRemovedConnectors();
                Connector connector = this.aas.getConnector();
                if (connector != null && this.autoStart) {
                    this.performDeferredLoadOnStartup();
                }
                this.checkThatConnectorsHaveStarted();
                this.started = true;
                logger.info((Object)("Aas started on port(s): " + this.getPortsDescription(true) + " with context path '" + this.getContextPath() + "'"));
            }
            catch (ConnectorStartFailedException ex) {
                this.stopSilently();
                throw ex;
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to start embedded Aas server", (Throwable)ex);
            }
            finally {
                Context context = this.findContext();
                ContextBindings.unbindClassLoader((Object)context, (Object)context.getNamingToken(), (ClassLoader)this.getClass().getClassLoader());
            }
        }
    }

    private void checkThatConnectorsHaveStarted() {
        this.checkConnectorHasStarted(this.aas.getConnector());
        for (Connector connector : this.aas.getService().findConnectors()) {
            this.checkConnectorHasStarted(connector);
        }
    }

    private void checkConnectorHasStarted(Connector connector) {
        if (LifecycleState.FAILED.equals((Object)connector.getState())) {
            throw new ConnectorStartFailedException(connector.getPort());
        }
    }

    private void stopSilently() {
        try {
            this.stopAas();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void destroySilently() {
        try {
            this.aas.destroy();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void stopAas() throws LifecycleException {
        if (Thread.currentThread().getContextClassLoader() instanceof AasEmbeddedWebappClassLoader) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        this.aas.stop();
    }

    private void addPreviouslyRemovedConnectors() {
        Service[] services;
        for (Service service : services = this.aas.getServer().findServices()) {
            Connector[] connectors = this.serviceConnectors.get(service);
            if (connectors == null) continue;
            for (Connector connector : connectors) {
                service.addConnector(connector);
                if (this.autoStart) continue;
                this.stopProtocolHandler(connector);
            }
            this.serviceConnectors.remove(service);
        }
    }

    private void stopProtocolHandler(Connector connector) {
        try {
            connector.getProtocolHandler().stop();
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot pause connector: ", (Throwable)ex);
        }
    }

    private void performDeferredLoadOnStartup() {
        try {
            for (Container child : this.aas.getHost().findChildren()) {
                if (!(child instanceof AasEmbeddedContext)) continue;
                ((AasEmbeddedContext)child).deferredLoadOnStartup();
            }
        }
        catch (Exception ex) {
            if (ex instanceof WebServerException) {
                throw (WebServerException)ex;
            }
            throw new WebServerException("Unable to start embedded Aas connectors", (Throwable)ex);
        }
    }

    Map<Service, Connector[]> getServiceConnectors() {
        return this.serviceConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            boolean wasStarted = this.started;
            try {
                this.started = false;
                try {
                    this.stopAas();
                    this.aas.destroy();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to stop embedded Aas", (Throwable)ex);
            }
            finally {
                if (wasStarted) {
                    containerCounter.decrementAndGet();
                }
            }
        }
    }

    private String getPortsDescription(boolean localPort) {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.aas.getService().findConnectors()) {
            if (ports.length() != 0) {
                ports.append(' ');
            }
            int port = localPort ? connector.getLocalPort() : connector.getPort();
            ports.append(port).append(" (").append(connector.getScheme()).append(')');
        }
        return ports.toString();
    }

    public int getPort() {
        Connector connector = this.aas.getConnector();
        if (connector != null) {
            return connector.getLocalPort();
        }
        return 0;
    }

    private String getContextPath() {
        return Arrays.stream(this.aas.getHost().findChildren()).filter(AasEmbeddedContext.class::isInstance).map(AasEmbeddedContext.class::cast).map(StandardContext::getPath).collect(Collectors.joining(" "));
    }

    public Aas getAas() {
        return this.aas;
    }
}

