/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.boot.web.embedded.ams;

import com.apusic.ams.connector.Connector;
import com.apusic.boot.web.embedded.ams.AasConnectorCustomizer;
import com.apusic.connector.ProtocolHandler;
import com.apusic.connector.UpgradeProtocol;
import com.apusic.connector.http11.AbstractHttp11Protocol;
import com.apusic.connector.http2.Http2Protocol;
import java.lang.reflect.Method;
import org.springframework.boot.web.server.Compression;
import org.springframework.util.StringUtils;

class CompressionConnectorCustomizer
implements AasConnectorCustomizer {
    private final Compression compression;

    CompressionConnectorCustomizer(Compression compression) {
        this.compression = compression;
    }

    @Override
    public void customize(Connector connector) {
        if (this.compression != null && this.compression.getEnabled()) {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                this.customize((AbstractHttp11Protocol)handler);
            }
            for (UpgradeProtocol upgradeProtocol : connector.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                this.customize((Http2Protocol)upgradeProtocol);
            }
        }
    }

    private void customize(Http2Protocol protocol) {
        Compression compression = this.compression;
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize(compression));
        protocol.setCompressibleMimeType(this.getMimeTypes(compression));
        if (this.compression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(this.getExcludedUserAgents());
        }
    }

    private void customize(AbstractHttp11Protocol<?> protocol) {
        Compression compression = this.compression;
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize(compression));
        protocol.setCompressibleMimeType(this.getMimeTypes(compression));
        if (this.compression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(this.getExcludedUserAgents());
        }
    }

    private int getMinResponseSize(Compression compression) {
        boolean newVersion = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.springframework.util.unit.DataSize");
            compression.getClass().getDeclaredMethod("setMinResponseSize", clazz);
            newVersion = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newVersion) {
            try {
                Method method = clazz.getDeclaredMethod("toBytes", new Class[0]);
                method.setAccessible(true);
                return ((Long)method.invoke((Object)compression.getMinResponseSize(), new Object[0])).intValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 4096;
            }
        }
        try {
            Method method = compression.getClass().getDeclaredMethod("getMinResponseSize", new Class[0]);
            return Integer.parseInt(method.invoke((Object)compression, new Object[0]).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 4096;
        }
    }

    private String getMimeTypes(Compression compression) {
        return StringUtils.arrayToCommaDelimitedString((Object[])compression.getMimeTypes());
    }

    private String getExcludedUserAgents() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.compression.getExcludedUserAgents());
    }
}

