/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.boot.web.embedded.ams;

import java.io.File;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="server", ignoreUnknownFields=true)
public class ServerProperties {
    private Integer port;
    private InetAddress address;
    @NestedConfigurationProperty
    private final ErrorProperties error = new ErrorProperties();
    private Boolean useForwardHeaders;
    private String serverHeader;
    private Integer maxHttpHeaderSize = 8192;
    private Duration connectionTimeout;
    @NestedConfigurationProperty
    private Ssl ssl;
    private Compression compression = new Compression();
    @NestedConfigurationProperty
    private final Http2 http2 = new Http2();
    private final Servlet servlet = new Servlet();
    private final AAS aas = new AAS();

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public Boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    public void setUseForwardHeaders(Boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public Integer getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(Integer maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public ErrorProperties getError() {
        return this.error;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public Http2 getHttp2() {
        return this.http2;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public AAS getAAS() {
        return this.aas;
    }

    public static class AAS {
        private final Accesslog accesslog = new Accesslog();
        private String internalProxies = "10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1";
        private String protocolHeader;
        private String protocolHeaderHttpsValue = "https";
        private String portHeader = "X-Forwarded-Port";
        private String remoteIpHeader;
        private File basedir;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration backgroundProcessorDelay = Duration.ofSeconds(10L);
        private int maxThreads = 200;
        private int minSpareThreads = 10;
        private Integer maxHttpPostSize = 0x200000;
        private Integer maxHttpHeaderSize = 0;
        private Integer maxSwallowSize = 0x1400000;
        private Boolean redirectContextRoot = true;
        private Boolean useRelativeRedirects;
        private Charset uriEncoding = StandardCharsets.UTF_8;
        private int maxConnections = 10000;
        private int acceptCount = 100;
        private int maxKeepaliveTimeout = 30000;
        private boolean compression = false;
        private boolean enableLookups = true;
        private int maxKeepaliveRequests = 100;
        private String compressableMimeType = "text/html,text/plain,text/css,application/javascript,application/json,application/x-font-ttf,application/x-font-otf,image/svg+xml";
        private int compressionMinSize = 4096;
        private boolean disableUploadTimeout = false;
        private List<String> additionalTldSkipPatterns = new ArrayList<String>();
        private final Resource resource = new Resource();
        private String relaxedPathChars;
        private String relaxedQueryChars;
        private boolean useSendfile = true;
        private String licensePath = null;

        public String getRelaxedPathChars() {
            return this.relaxedPathChars;
        }

        public void setRelaxedPathChars(String relaxedPathChars) {
            this.relaxedPathChars = relaxedPathChars;
        }

        public String getRelaxedQueryChars() {
            return this.relaxedQueryChars;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        public int getMinSpareThreads() {
            return this.minSpareThreads;
        }

        public void setMinSpareThreads(int minSpareThreads) {
            this.minSpareThreads = minSpareThreads;
        }

        public Integer getMaxHttpPostSize() {
            return this.maxHttpPostSize;
        }

        public void setMaxHttpPostSize(Integer maxHttpPostSize) {
            this.maxHttpPostSize = maxHttpPostSize;
        }

        public Accesslog getAccesslog() {
            return this.accesslog;
        }

        public Duration getBackgroundProcessorDelay() {
            return this.backgroundProcessorDelay;
        }

        public void setBackgroundProcessorDelay(Duration backgroundProcessorDelay) {
            this.backgroundProcessorDelay = backgroundProcessorDelay;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public String getInternalProxies() {
            return this.internalProxies;
        }

        public void setInternalProxies(String internalProxies) {
            this.internalProxies = internalProxies;
        }

        public String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getProtocolHeaderHttpsValue() {
            return this.protocolHeaderHttpsValue;
        }

        public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
            this.protocolHeaderHttpsValue = protocolHeaderHttpsValue;
        }

        public String getPortHeader() {
            return this.portHeader;
        }

        public void setPortHeader(String portHeader) {
            this.portHeader = portHeader;
        }

        public Boolean getRedirectContextRoot() {
            return this.redirectContextRoot;
        }

        public void setRedirectContextRoot(Boolean redirectContextRoot) {
            this.redirectContextRoot = redirectContextRoot;
        }

        public Boolean getUseRelativeRedirects() {
            return this.useRelativeRedirects;
        }

        public void setUseRelativeRedirects(Boolean useRelativeRedirects) {
            this.useRelativeRedirects = useRelativeRedirects;
        }

        public String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        public Charset getUriEncoding() {
            return this.uriEncoding;
        }

        public void setUriEncoding(Charset uriEncoding) {
            this.uriEncoding = uriEncoding;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="server.max-http-header-size")
        public Integer getMaxHttpHeaderSize() {
            return this.maxHttpHeaderSize;
        }

        @Deprecated
        public void setMaxHttpHeaderSize(Integer maxHttpHeaderSize) {
            this.maxHttpHeaderSize = maxHttpHeaderSize;
        }

        public Integer getMaxSwallowSize() {
            return this.maxSwallowSize;
        }

        public void setMaxSwallowSize(Integer maxSwallowSize) {
            this.maxSwallowSize = maxSwallowSize;
        }

        public int getAcceptCount() {
            return this.acceptCount;
        }

        public void setAcceptCount(int acceptCount) {
            this.acceptCount = acceptCount;
        }

        public List<String> getAdditionalTldSkipPatterns() {
            return this.additionalTldSkipPatterns;
        }

        public void setAdditionalTldSkipPatterns(List<String> additionalTldSkipPatterns) {
            this.additionalTldSkipPatterns = additionalTldSkipPatterns;
        }

        public int getMaxKeepaliveTimeout() {
            return this.maxKeepaliveTimeout;
        }

        public void setMaxKeepaliveTimeout(int maxKeepaliveTimeout) {
            this.maxKeepaliveTimeout = maxKeepaliveTimeout;
        }

        public boolean isCompression() {
            return this.compression;
        }

        public void setCompression(boolean compression) {
            this.compression = compression;
        }

        public String getCompressableMimeType() {
            return this.compressableMimeType;
        }

        public void setCompressableMimeType(String compressableMimeType) {
            this.compressableMimeType = compressableMimeType;
        }

        public int getCompressionMinSize() {
            return this.compressionMinSize;
        }

        public void setCompressionMinSize(int compressionMinSize) {
            this.compressionMinSize = compressionMinSize;
        }

        public boolean isEnableLookups() {
            return this.enableLookups;
        }

        public void setEnableLookups(boolean enableLookups) {
            this.enableLookups = enableLookups;
        }

        public int getMaxKeepaliveRequests() {
            return this.maxKeepaliveRequests;
        }

        public void setMaxKeepaliveRequests(int maxKeepaliveRequests) {
            this.maxKeepaliveRequests = maxKeepaliveRequests;
        }

        public boolean isDisableUploadTimeout() {
            return this.disableUploadTimeout;
        }

        public void setDisableUploadTimeout(boolean disableUploadTimeout) {
            this.disableUploadTimeout = disableUploadTimeout;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setRelaxedQueryChars(String relaxedQueryChars) {
            this.relaxedQueryChars = relaxedQueryChars;
        }

        public boolean isUseSendfile() {
            return this.useSendfile;
        }

        public void setUseSendfile(boolean useSendfile) {
            this.useSendfile = useSendfile;
        }

        public String getLicensePath() {
            return this.licensePath;
        }

        public void setLicensePath(String licensePath) {
            this.licensePath = licensePath;
        }

        public static class Resource {
            private boolean allowCaching = true;
            private Duration cacheTtl;

            public boolean isAllowCaching() {
                return this.allowCaching;
            }

            public void setAllowCaching(boolean allowCaching) {
                this.allowCaching = allowCaching;
            }

            public Duration getCacheTtl() {
                return this.cacheTtl;
            }

            public void setCacheTtl(Duration cacheTtl) {
                this.cacheTtl = cacheTtl;
            }
        }

        public static class Accesslog {
            private boolean enabled = false;
            private String pattern = "common";
            private String directory = "logs";
            protected String prefix = "access_log";
            private String suffix = ".log";
            private boolean rotate = true;
            private boolean renameOnRotate = false;
            private String fileDateFormat = ".yyyy-MM-dd";
            private boolean requestAttributesEnabled = false;
            private boolean buffered = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public String getDirectory() {
                return this.directory;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }

            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }

            public boolean isRotate() {
                return this.rotate;
            }

            public void setRotate(boolean rotate) {
                this.rotate = rotate;
            }

            public boolean isRenameOnRotate() {
                return this.renameOnRotate;
            }

            public void setRenameOnRotate(boolean renameOnRotate) {
                this.renameOnRotate = renameOnRotate;
            }

            public String getFileDateFormat() {
                return this.fileDateFormat;
            }

            public void setFileDateFormat(String fileDateFormat) {
                this.fileDateFormat = fileDateFormat;
            }

            public boolean isRequestAttributesEnabled() {
                return this.requestAttributesEnabled;
            }

            public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
                this.requestAttributesEnabled = requestAttributesEnabled;
            }

            public boolean isBuffered() {
                return this.buffered;
            }

            public void setBuffered(boolean buffered) {
                this.buffered = buffered;
            }
        }
    }

    public static class Servlet {
        private final Map<String, String> contextParameters = new HashMap<String, String>();
        private String contextPath;
        private String applicationDisplayName = "application";
        @NestedConfigurationProperty
        private final Jsp jsp = new Jsp();
        @NestedConfigurationProperty
        private final Session session = new Session();

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = this.cleanContextPath(contextPath);
        }

        private String cleanContextPath(String contextPath) {
            if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
                return contextPath.substring(0, contextPath.length() - 1);
            }
            return contextPath;
        }

        public String getApplicationDisplayName() {
            return this.applicationDisplayName;
        }

        public void setApplicationDisplayName(String displayName) {
            this.applicationDisplayName = displayName;
        }

        public Map<String, String> getContextParameters() {
            return this.contextParameters;
        }

        public Jsp getJsp() {
            return this.jsp;
        }

        public Session getSession() {
            return this.session;
        }
    }
}

