/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import com.apusic.ams.connector.ConnectorInputStream;
import com.apusic.ams.connector.ConnectorOutputStream;
import com.apusic.ams.connector.RequestFacade;
import com.apusic.ams.connector.Response;
import com.apusic.ams.connector.ResponseFacade;
import com.apusic.connector.Request;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.AasHeadersAdapter;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class AasHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public AasHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    protected ServletServerHttpRequest createRequest(HttpServletRequest request, AsyncContext asyncContext) throws IOException, URISyntaxException {
        Assert.notNull((Object)this.getServletPath(), (String)"Servlet path is not initialized");
        return new AasServerHttpRequest(request, asyncContext, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext asyncContext, ServletServerHttpRequest request) throws IOException {
        return new AasServerHttpResponse(response, asyncContext, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class AasServerHttpResponse
    extends ServletServerHttpResponse {
        private static final Field CONNECTOR_RESPONSE_FIELD;

        AasServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(AasServerHttpResponse.createAasHttpHeaders(response), response, context, factory, bufferSize, request);
        }

        private static HttpHeaders createAasHttpHeaders(HttpServletResponse response) {
            ResponseFacade responseFacade = AasServerHttpResponse.getResponseFacade(response);
            Response connectorResponse = (Response)ReflectionUtils.getField((Field)CONNECTOR_RESPONSE_FIELD, (Object)responseFacade);
            Assert.state((connectorResponse != null ? 1 : 0) != 0, (String)"No AAS connector response");
            com.apusic.connector.Response aasResponse = connectorResponse.getConnectorResponse();
            AasHeadersAdapter headers = new AasHeadersAdapter(aasResponse.getMimeHeaders());
            return new HttpHeaders((MultiValueMap)headers);
        }

        private static ResponseFacade getResponseFacade(HttpServletResponse response) {
            if (response instanceof ResponseFacade) {
                return (ResponseFacade)response;
            }
            if (response instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
                HttpServletResponse wrappedResponse = (HttpServletResponse)wrapper.getResponse();
                return AasServerHttpResponse.getResponseFacade(wrappedResponse);
            }
            throw new IllegalArgumentException("Cannot convert [" + response.getClass() + "] to com.apusic.ams.connector.ResponseFacade");
        }

        protected void applyHeaders() {
            long contentLength;
            Charset charset;
            HttpServletResponse response = (HttpServletResponse)this.getNativeResponse();
            MediaType contentType = this.getHeaders().getContentType();
            if (response.getContentType() == null && contentType != null) {
                response.setContentType(contentType.toString());
            }
            Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
            if (response.getCharacterEncoding() == null && charset != null) {
                response.setCharacterEncoding(charset.name());
            }
            if ((contentLength = this.getHeaders().getContentLength()) != -1L) {
                response.setContentLengthLong(contentLength);
            }
        }

        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ByteBuffer input = dataBuffer.asByteBuffer();
            int len = input.remaining();
            ServletResponse response = (ServletResponse)this.getNativeResponse();
            ((ConnectorOutputStream)response.getOutputStream()).write(input);
            return len;
        }

        static {
            Field field = ReflectionUtils.findField(ResponseFacade.class, (String)"response");
            Assert.state((field != null ? 1 : 0) != 0, (String)"Incompatible AAS implementation");
            ReflectionUtils.makeAccessible((Field)field);
            CONNECTOR_RESPONSE_FIELD = field;
        }
    }

    private static final class AasServerHttpRequest
    extends ServletServerHttpRequest {
        private static final Field CONNECTOR_REQUEST_FIELD;
        private final int bufferSize;
        private final DataBufferFactory factory;

        AasServerHttpRequest(HttpServletRequest request, AsyncContext context, String servletPath, DataBufferFactory factory, int bufferSize) throws IOException, URISyntaxException {
            super(AasServerHttpRequest.createAasHttpHeaders(request), request, context, servletPath, factory, bufferSize);
            this.factory = factory;
            this.bufferSize = bufferSize;
        }

        private static HttpHeaders createAasHttpHeaders(HttpServletRequest request) {
            RequestFacade requestFacade = AasServerHttpRequest.getRequestFacade(request);
            com.apusic.ams.connector.Request connectorRequest = (com.apusic.ams.connector.Request)ReflectionUtils.getField((Field)CONNECTOR_REQUEST_FIELD, (Object)requestFacade);
            Assert.state((connectorRequest != null ? 1 : 0) != 0, (String)"No AAS connector request");
            Request aasRequest = connectorRequest.getConnectorRequest();
            AasHeadersAdapter headers = new AasHeadersAdapter(aasRequest.getMimeHeaders());
            return new HttpHeaders((MultiValueMap)headers);
        }

        private static RequestFacade getRequestFacade(HttpServletRequest request) {
            if (request instanceof RequestFacade) {
                return (RequestFacade)request;
            }
            if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
                return AasServerHttpRequest.getRequestFacade(wrappedRequest);
            }
            throw new IllegalArgumentException("Cannot convert [" + request.getClass() + "] to com.apusic.ams.connector.RequestFacade");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DataBuffer readFromInputStream() throws IOException {
            boolean release = true;
            int capacity = this.bufferSize;
            DataBuffer dataBuffer = this.factory.allocateBuffer(capacity);
            try {
                ByteBuffer byteBuffer = dataBuffer.asByteBuffer(0, capacity);
                ServletRequest request = (ServletRequest)this.getNativeRequest();
                int read = ((ConnectorInputStream)request.getInputStream()).read(byteBuffer);
                this.logBytesRead(read);
                if (read > 0) {
                    dataBuffer.writePosition(read);
                    release = false;
                    DataBuffer dataBuffer2 = dataBuffer;
                    return dataBuffer2;
                }
                if (read == -1) {
                    DataBuffer dataBuffer3 = EOF_BUFFER;
                    return dataBuffer3;
                }
                DataBuffer dataBuffer4 = null;
                return dataBuffer4;
            }
            finally {
                if (release) {
                    DataBufferUtils.release((DataBuffer)dataBuffer);
                }
            }
        }

        static {
            Field field = ReflectionUtils.findField(RequestFacade.class, (String)"request");
            Assert.state((field != null ? 1 : 0) != 0, (String)"Incompatible AAS implementation");
            ReflectionUtils.makeAccessible((Field)field);
            CONNECTOR_REQUEST_FIELD = field;
        }
    }
}

