/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.asn1.cms;

import com.bes.enterprise.cipher.asn1.ASN1Boolean;
import com.bes.enterprise.cipher.asn1.ASN1EncodableVector;
import com.bes.enterprise.cipher.asn1.ASN1Object;
import com.bes.enterprise.cipher.asn1.ASN1Primitive;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.DERIA5String;
import com.bes.enterprise.cipher.asn1.DERSequence;
import com.bes.enterprise.cipher.asn1.DERUTF8String;
import com.bes.enterprise.cipher.asn1.cms.Attributes;

public class MetaData
extends ASN1Object {
    private ASN1Boolean hashProtected;
    private DERUTF8String fileName;
    private DERIA5String mediaType;
    private Attributes otherMetaData;

    public MetaData(ASN1Boolean hashProtected, DERUTF8String fileName, DERIA5String mediaType, Attributes otherMetaData) {
        this.hashProtected = hashProtected;
        this.fileName = fileName;
        this.mediaType = mediaType;
        this.otherMetaData = otherMetaData;
    }

    private MetaData(ASN1Sequence seq) {
        this.hashProtected = ASN1Boolean.getInstance(seq.getObjectAt(0));
        int index = 1;
        if (index < seq.size() && seq.getObjectAt(index) instanceof DERUTF8String) {
            this.fileName = DERUTF8String.getInstance(seq.getObjectAt(index++));
        }
        if (index < seq.size() && seq.getObjectAt(index) instanceof DERIA5String) {
            this.mediaType = DERIA5String.getInstance(seq.getObjectAt(index++));
        }
        if (index < seq.size()) {
            this.otherMetaData = Attributes.getInstance(seq.getObjectAt(index++));
        }
    }

    public static MetaData getInstance(Object obj) {
        if (obj instanceof MetaData) {
            return (MetaData)obj;
        }
        if (obj != null) {
            return new MetaData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.hashProtected);
        if (this.fileName != null) {
            v.add(this.fileName);
        }
        if (this.mediaType != null) {
            v.add(this.mediaType);
        }
        if (this.otherMetaData != null) {
            v.add(this.otherMetaData);
        }
        return new DERSequence(v);
    }

    public boolean isHashProtected() {
        return this.hashProtected.isTrue();
    }

    public DERUTF8String getFileName() {
        return this.fileName;
    }

    public DERIA5String getMediaType() {
        return this.mediaType;
    }

    public Attributes getOtherMetaData() {
        return this.otherMetaData;
    }
}

