/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.commitments;

import com.bes.enterprise.cipher.crypto.Commitment;
import com.bes.enterprise.cipher.crypto.Committer;
import com.bes.enterprise.cipher.crypto.DataLengthException;
import com.bes.enterprise.cipher.crypto.Digest;
import com.bes.enterprise.cipher.crypto.ExtendedDigest;
import com.bes.enterprise.cipher.util.Arrays;
import java.security.SecureRandom;

public class HashCommitter
implements Committer {
    private final Digest digest;
    private final int byteLength;
    private final SecureRandom random;

    public HashCommitter(ExtendedDigest digest, SecureRandom random) {
        this.digest = digest;
        this.byteLength = digest.getByteLength();
        this.random = random;
    }

    @Override
    public Commitment commit(byte[] message) {
        if (message.length > this.byteLength / 2) {
            throw new DataLengthException("Message to be committed to too large for digest.");
        }
        byte[] w = new byte[this.byteLength - message.length];
        this.random.nextBytes(w);
        return new Commitment(w, this.calculateCommitment(w, message));
    }

    @Override
    public boolean isRevealed(Commitment commitment, byte[] message) {
        if (message.length + commitment.getSecret().length != this.byteLength) {
            throw new DataLengthException("Message and witness secret lengths do not match.");
        }
        byte[] calcCommitment = this.calculateCommitment(commitment.getSecret(), message);
        return Arrays.constantTimeAreEqual(commitment.getCommitment(), calcCommitment);
    }

    private byte[] calculateCommitment(byte[] w, byte[] message) {
        byte[] commitment = new byte[this.digest.getDigestSize()];
        this.digest.update(w, 0, w.length);
        this.digest.update(message, 0, message.length);
        this.digest.doFinal(commitment, 0);
        return commitment;
    }
}

