/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.generators;

import com.bes.enterprise.cipher.crypto.AsymmetricCipherKeyPair;
import com.bes.enterprise.cipher.crypto.AsymmetricCipherKeyPairGenerator;
import com.bes.enterprise.cipher.crypto.KeyGenerationParameters;
import com.bes.enterprise.cipher.crypto.generators.DHKeyGeneratorHelper;
import com.bes.enterprise.cipher.crypto.params.DHParameters;
import com.bes.enterprise.cipher.crypto.params.ElGamalKeyGenerationParameters;
import com.bes.enterprise.cipher.crypto.params.ElGamalParameters;
import com.bes.enterprise.cipher.crypto.params.ElGamalPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

