/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.signers;

import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.CryptoServicesRegistrar;
import com.bes.enterprise.cipher.crypto.DSA;
import com.bes.enterprise.cipher.crypto.params.ECDomainParameters;
import com.bes.enterprise.cipher.crypto.params.ECKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPublicKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.math.ec.ECAlgorithms;
import com.bes.enterprise.cipher.math.ec.ECConstants;
import com.bes.enterprise.cipher.math.ec.ECMultiplier;
import com.bes.enterprise.cipher.math.ec.ECPoint;
import com.bes.enterprise.cipher.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECGOST3410Signer
implements DSA {
    ECKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s;
        ECPoint p;
        BigInteger r;
        BigInteger k;
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger e = new BigInteger(1, mRev);
        ECDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        BigInteger d = ((ECPrivateKeyParameters)this.key).getD();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        while ((k = new BigInteger(n.bitLength(), this.random)).equals(ECConstants.ZERO) || (r = (p = basePointMultiplier.multiply(ec.getG(), k).normalize()).getAffineXCoord().toBigInteger().mod(n)).equals(ECConstants.ZERO) || (s = k.multiply(e).add(d.multiply(r)).mod(n)).equals(ECConstants.ZERO)) {
        }
        return new BigInteger[]{r, s};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint Q;
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger e = new BigInteger(1, mRev);
        BigInteger n = this.key.getParameters().getN();
        if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ECConstants.ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger v = e.modInverse(n);
        BigInteger z1 = s.multiply(v).mod(n);
        BigInteger z2 = n.subtract(r).multiply(v).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, z1, Q = ((ECPublicKeyParameters)this.key).getQ(), z2).normalize();
        if (point.isInfinity()) {
            return false;
        }
        BigInteger R = point.getAffineXCoord().toBigInteger().mod(n);
        return R.equals(r);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

