/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.tls;

import com.bes.enterprise.cipher.crypto.CryptoException;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.DSAPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.RSAKeyParameters;
import com.bes.enterprise.cipher.crypto.tls.AbstractTlsSignerCredentials;
import com.bes.enterprise.cipher.crypto.tls.Certificate;
import com.bes.enterprise.cipher.crypto.tls.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.crypto.tls.TlsContext;
import com.bes.enterprise.cipher.crypto.tls.TlsDSSSigner;
import com.bes.enterprise.cipher.crypto.tls.TlsECDSASigner;
import com.bes.enterprise.cipher.crypto.tls.TlsFatalAlert;
import com.bes.enterprise.cipher.crypto.tls.TlsRSASigner;
import com.bes.enterprise.cipher.crypto.tls.TlsSigner;
import com.bes.enterprise.cipher.crypto.tls.TlsUtils;
import java.io.IOException;

public class DefaultTlsSignerCredentials
extends AbstractTlsSignerCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    protected TlsSigner signer;

    public DefaultTlsSignerCredentials(TlsContext context, Certificate certificate, AsymmetricKeyParameter privateKey) {
        this(context, certificate, privateKey, null);
    }

    public DefaultTlsSignerCredentials(TlsContext context, Certificate certificate, AsymmetricKeyParameter privateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (TlsUtils.isTLSv12(context) && signatureAndHashAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        if (privateKey instanceof RSAKeyParameters) {
            this.signer = new TlsRSASigner();
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            this.signer = new TlsDSSSigner();
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.signer = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.signer.init(context);
        this.context = context;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] generateCertificateSignature(byte[] hash) throws IOException {
        try {
            if (TlsUtils.isTLSv12(this.context)) {
                return this.signer.generateRawSignature(this.signatureAndHashAlgorithm, this.privateKey, hash);
            }
            return this.signer.generateRawSignature(this.privateKey, hash);
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }
}

