/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.tls;

import com.bes.enterprise.cipher.crypto.tls.AbstractTlsClient;
import com.bes.enterprise.cipher.crypto.tls.DefaultTlsCipherFactory;
import com.bes.enterprise.cipher.crypto.tls.TlsAuthentication;
import com.bes.enterprise.cipher.crypto.tls.TlsCipherFactory;
import com.bes.enterprise.cipher.crypto.tls.TlsFatalAlert;
import com.bes.enterprise.cipher.crypto.tls.TlsKeyExchange;
import com.bes.enterprise.cipher.crypto.tls.TlsPSKIdentity;
import com.bes.enterprise.cipher.crypto.tls.TlsPSKKeyExchange;
import com.bes.enterprise.cipher.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this(new DefaultTlsCipherFactory(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        super(cipherFactory);
        this.pskIdentity = pskIdentity;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, null, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

