/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.gmssl.AbstractTlsClient;
import com.bes.enterprise.cipher.gmssl.DefaultTlsDHConfigVerifier;
import com.bes.enterprise.cipher.gmssl.DefaultTlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.TlsAuthentication;
import com.bes.enterprise.cipher.gmssl.TlsDHConfigVerifier;
import com.bes.enterprise.cipher.gmssl.TlsECConfigVerifier;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchange;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.TlsPSKIdentity;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCrypto;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsPSKIdentity pskIdentity;
    protected int[] supportedCipherSuites;

    public PSKTlsClient(TlsCrypto crypto, TlsPSKIdentity pskIdentity) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier(), pskIdentity);
    }

    public PSKTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsDHConfigVerifier dhConfigVerifier, TlsPSKIdentity pskIdentity) {
        super(crypto, keyExchangeFactory);
        this.dhConfigVerifier = dhConfigVerifier;
        this.pskIdentity = pskIdentity;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    @Override
    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 14: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, this.dhConfigVerifier, null);
            }
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, this.createECConfigVerifier());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfigVerifier dhConfigVerifier, TlsECConfigVerifier ecConfigVerifier) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, dhConfigVerifier, ecConfigVerifier, this.clientECPointFormats, this.serverECPointFormats);
    }
}

